/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.dwarf.Augmentation;
import com.uqm.crashsight.symtabtool.dwarf.AugmentationData;
import com.uqm.crashsight.symtabtool.dwarf.BaseAddresses;
import com.uqm.crashsight.symtabtool.dwarf.CallFrameInstructionIter;
import com.uqm.crashsight.symtabtool.dwarf.CommonInformationEntry;
import com.uqm.crashsight.symtabtool.dwarf.DwEhPe;
import com.uqm.crashsight.symtabtool.dwarf.Format;
import com.uqm.crashsight.symtabtool.dwarf.Pointer;
import com.uqm.crashsight.symtabtool.dwarf.PointerEncodingParameters;
import com.uqm.crashsight.symtabtool.dwarf.Reader;
import com.uqm.crashsight.symtabtool.dwarf.UninitializedUnwindContext;
import com.uqm.crashsight.symtabtool.dwarf.UnwindSection;
import com.uqm.crashsight.symtabtool.dwarf.UnwindTable;
import com.uqm.crashsight.symtabtool.dwarf._UnwindSectionPrivate;
import java.util.Map;

class FrameDescriptionEntry {
    Long offset;
    Long length;
    Format format;
    CommonInformationEntry cie;
    Long initialSegment;
    Long initialAddress;
    Long addressRange;
    AugmentationData augmentation;
    Reader instructions;

    public FrameDescriptionEntry(Long offset, Long length, Format format, CommonInformationEntry cie, Long initialSegment, Long initialAddress, Long addressRange, AugmentationData augmentation, Reader instructions) {
        this.offset = offset;
        this.length = length;
        this.format = format;
        this.cie = cie;
        this.initialSegment = initialSegment;
        this.initialAddress = initialAddress;
        this.addressRange = addressRange;
        this.augmentation = augmentation;
        this.instructions = instructions;
    }

    public static FrameDescriptionEntry parseRest(Long offset, Long length, Format format, Long ciePointer, Reader rest, _UnwindSectionPrivate section, BaseAddresses bases, Map<Long, CommonInformationEntry> cieMap) {
        CommonInformationEntry cie = cieMap.get(ciePointer);
        if (cie == null) {
            return null;
        }
        long initialSegment = 0L;
        if (cie.segmentSize > 0) {
            initialSegment = rest.readAddress(cie.segmentSize);
        }
        PointerEncodingParameters parameters = new PointerEncodingParameters(bases.ehFrame, null, cie.addressSize, section.section());
        Pair<Long, Long> pair = FrameDescriptionEntry.parseAddress(rest, cie, parameters);
        long initialAddress = pair.getKey();
        long addressRange = pair.getValue();
        AugmentationData augData = null;
        if (cie.augmentation != null) {
            augData = AugmentationData.parse(cie.augmentation, parameters, rest);
        }
        return new FrameDescriptionEntry(offset, length, format, cie, initialSegment, initialAddress, addressRange, augData, rest);
    }

    public static Pair<Long, Long> parseAddress(Reader input, CommonInformationEntry cie, PointerEncodingParameters parameters) {
        DwEhPe encoding = null;
        if (cie.augmentation != null) {
            encoding = cie.augmentation.fdeAddressEncoding;
        }
        if (encoding != null) {
            Pointer initialAddressPointer = Augmentation.parseEncodedPointer(encoding, parameters, input);
            assert (initialAddressPointer != null);
            long initialAddress = initialAddressPointer.into();
            Pointer addressRangePointer = Augmentation.parseEncodedPointer(encoding.format(), parameters, input);
            assert (addressRangePointer != null);
            long addressRange = addressRangePointer.into();
            return new Pair<Long, Long>(initialAddress, addressRange);
        }
        return new Pair<Long, Long>(input.readAddress(cie.addressSize), input.readAddress(cie.addressSize));
    }

    public CallFrameInstructionIter instructions(UnwindSection section, BaseAddresses bases) {
        DwEhPe fdeAddressEncoding = null;
        if (this.cie.augmentation != null) {
            fdeAddressEncoding = this.cie.augmentation.fdeAddressEncoding;
        }
        return new CallFrameInstructionIter(this.instructions, fdeAddressEncoding, new PointerEncodingParameters(bases.ehFrame, null, this.cie.addressSize, section.section()));
    }

    public UnwindTable rows(UnwindSection section, BaseAddresses bases, UninitializedUnwindContext ctx) {
        return UnwindTable._new(section, bases, ctx, this);
    }

    public long len() {
        return this.addressRange;
    }
}

