/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.dwarf.Endianity;
import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import com.uqm.crashsight.symtabtool.dwarf.Reader;

class EndianSlice<Endian extends Endianity>
implements Reader {
    ParseBuffer slice;
    Endian endian;

    public EndianSlice(ParseBuffer slice, Endian endian) {
        this.slice = slice;
        this.endian = endian;
    }

    public ParseBuffer buf() {
        return this.slice;
    }

    public long offsetFrom(EndianSlice<Endian> base) {
        long basePtr = base.slice.getPtr();
        long ptr = this.slice.getPtr();
        assert (basePtr <= ptr);
        assert (ptr + this.slice.len() <= basePtr + base.slice.len());
        return ptr - basePtr;
    }

    public ParseBuffer readSlice(long len) {
        if (this.slice.len() < len) {
            throw new RuntimeException("UnexpectedEof");
        }
        ParseBuffer[] splits = this.slice.take(len);
        this.slice = splits[1];
        return splits[0];
    }

    private long _find(byte b) {
        return this.slice.find(b);
    }

    @Override
    public Endianity endian() {
        return this.endian;
    }

    @Override
    public EndianSlice<Endian> _clone() {
        ParseBuffer buffer = this.slice.copy();
        return new EndianSlice<Endian>(buffer, this.endian);
    }

    @Override
    public Long len() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.slice.isEmpty();
    }

    @Override
    public Long offsetId() {
        return this.slice.getSectionOffset();
    }

    @Override
    public void empty() {
    }

    @Override
    public Long offsetFrom(Reader base) {
        return this.offsetFrom((EndianSlice)base);
    }

    @Override
    public void readSlice(byte[] buf) {
    }

    @Override
    public short readU8() {
        return this.slice.readU8();
    }

    @Override
    public int readU16() {
        return this.slice.readU16();
    }

    @Override
    public long readU32() {
        return this.slice.readU32();
    }

    @Override
    public long readU64() {
        return this.slice.readI64();
    }

    @Override
    public short readI16() {
        return this.slice.readI16();
    }

    @Override
    public int readI32() {
        return this.slice.readI32();
    }

    @Override
    public long readI64() {
        return this.slice.readI64();
    }

    @Override
    public long readULeb128() {
        return this.slice.parseULeb128();
    }

    @Override
    public long readSLeb128() {
        return this.slice.parseSLeb128();
    }

    @Override
    public Long find(byte b) {
        long pos = this._find(b);
        if (pos == -1L) {
            throw new RuntimeException("UnexpectedEof:" + this.offsetId());
        }
        return pos;
    }

    @Override
    public void skip(Long len) {
        if (this.slice.len() < len) {
            throw new RuntimeException("UnexpectedEof:" + this.offsetId());
        }
        this.readSlice(len);
    }

    @Override
    public Reader split(Long offset) {
        ParseBuffer buffer = this.readSlice(offset);
        return new EndianSlice<Endian>(buffer, this.endian);
    }
}

