/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.Arch;
import com.uqm.crashsight.symtabtool.dwarf.BaseAddresses;
import com.uqm.crashsight.symtabtool.dwarf.CfaRule;
import com.uqm.crashsight.symtabtool.dwarf.CfiEntriesIter;
import com.uqm.crashsight.symtabtool.dwarf.CieOffsetEncoding;
import com.uqm.crashsight.symtabtool.dwarf.CieOrFde;
import com.uqm.crashsight.symtabtool.dwarf.CommonInformationEntry;
import com.uqm.crashsight.symtabtool.dwarf.DebugFrame;
import com.uqm.crashsight.symtabtool.dwarf.DwarfSection;
import com.uqm.crashsight.symtabtool.dwarf.EhFrame;
import com.uqm.crashsight.symtabtool.dwarf.ElfObject;
import com.uqm.crashsight.symtabtool.dwarf.Format;
import com.uqm.crashsight.symtabtool.dwarf.FrameDescriptionEntry;
import com.uqm.crashsight.symtabtool.dwarf.Leb128Parser;
import com.uqm.crashsight.symtabtool.dwarf.PartialFrameDescriptionEntry;
import com.uqm.crashsight.symtabtool.dwarf.Reader;
import com.uqm.crashsight.symtabtool.dwarf.Register;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRule;
import com.uqm.crashsight.symtabtool.dwarf.RegisterRulePair;
import com.uqm.crashsight.symtabtool.dwarf.RunTimeEndian;
import com.uqm.crashsight.symtabtool.dwarf.UninitializedUnwindContext;
import com.uqm.crashsight.symtabtool.dwarf.UnwindInfo;
import com.uqm.crashsight.symtabtool.dwarf.UnwindSection;
import com.uqm.crashsight.symtabtool.dwarf.UnwindTable;
import com.uqm.crashsight.symtabtool.dwarf.UnwindTableRow;
import com.uqm.crashsight.symtabtool.elf.ElfHeaderParser;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFile;
import java.io.BufferedWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class EhFrameParser {
    ElfObject elfObject = null;
    String archName = null;
    public static Map<Long, CommonInformationEntry> cieMap = new HashMap<Long, CommonInformationEntry>();
    private BufferedWriter writer = null;
    private FileChannel fileChannel = null;
    private ByteBuffer buffer = null;
    public static final int DW_EH_PE_format_omit = 255;
    public static final int DW_EH_PE_uleb128 = 1;
    public static final int DW_EH_PE_udata2 = 2;
    public static final int DW_EH_PE_udata4 = 3;
    public static final int DW_EH_PE_udata8 = 4;
    public static final int DW_EH_PE_sleb128 = 9;
    public static final int DW_EH_PE_sdata2 = 10;
    public static final int DW_EH_PE_sdata4 = 11;
    public static final int DW_EH_PE_sdata8 = 12;
    public static final int DW_EH_PE_absptr = 0;
    public static final int DW_EH_PE_pcrel = 16;
    public static final int DW_EH_PE_datarel = 48;
    public static final int DW_EH_PE_application_omit = 255;
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    private BinaryFileReader binaryFileReader = null;

    public ElfObject elfObject(ElfHeaderParser headerParser, ElfParser elfParser) {
        return new ElfObject(headerParser, elfParser);
    }

    public static CieOrFde parseCfiEntry(BaseAddresses bases, UnwindSection section, Reader input) {
        long cieIdOrOffset;
        Long offset = null;
        Long length = null;
        Format format = Format.Dwarf32;
        do {
            Reader reader = section.section();
            offset = input.offsetFrom(reader);
            Pair<Long, Format> pair = input.readInitialLength();
            assert (pair != null);
            length = pair.getKey();
            format = pair.getValue();
            if (!section.lengthValueIsEndOfEntries(length)) continue;
            return null;
        } while (length == 0L && format == Format.Dwarf32);
        Reader rest = input.split(length);
        Long cieOffsetBase = rest.offsetFrom(section.section());
        CieOffsetEncoding cieOffsetEncoding = section.cieOffsetEncoding(format);
        long l = cieIdOrOffset = cieOffsetEncoding == CieOffsetEncoding.U32 ? rest.readU32() : rest.readU64();
        if (section.isCie(format, cieIdOrOffset)) {
            CommonInformationEntry cie = CommonInformationEntry.parseRest(offset, length, format, bases, section, rest);
            cieMap.put(cie.offset, cie);
            return new CieOrFde(cie, null);
        }
        Long cieOffset = cieIdOrOffset;
        cieOffset = section.resolveCieOffset(cieOffsetBase, cieOffset);
        if (cieOffset == null) {
            throw new RuntimeException("OffsetOutOfBounds");
        }
        PartialFrameDescriptionEntry fde = new PartialFrameDescriptionEntry(offset, length, format, cieOffset, rest, section, bases);
        return new CieOrFde(null, fde);
    }

    public void parseDwarf(ElfHeaderParser headerParser, ElfParser elfParser, FileChannel fc, ByteBuffer buffer) {
        this.fileChannel = fc;
        this.buffer = buffer;
        this.elfObject = this.elfObject(headerParser, elfParser);
        this.archName = this.elfObject.arch()._name();
        RunTimeEndian endian = this.elfObject.endianity();
        DwarfSection section = this.elfObject.section(".debug_frame");
        if (section != null) {
            section = this.elfObject.section(".debug_frame");
            DebugFrame<RunTimeEndian> frame = DebugFrame._new(section.data, endian);
            UnwindInfo<DebugFrame<RunTimeEndian>> info = UnwindInfo._new(this.elfObject, section.address, frame);
            this.readCfi(info);
        } else {
            section = this.elfObject.section(".eh_frame");
            EhFrame<RunTimeEndian> frame = EhFrame._new(section.data, endian);
            UnwindInfo<EhFrame<RunTimeEndian>> info = UnwindInfo._new(this.elfObject, section.address, frame);
            this.readCfi(info);
        }
    }

    public <U extends UnwindSection> void readCfi(UnwindInfo<U> info) {
        CieOrFde entry;
        UninitializedUnwindContext ctx = new UninitializedUnwindContext();
        CfiEntriesIter entriesIter = ((UnwindSection)info.section).entries(info.bases);
        while ((entry = entriesIter.next()) != null) {
            PartialFrameDescriptionEntry partialFde;
            FrameDescriptionEntry fde;
            if (entry.fde == null || (fde = (partialFde = entry.fde).parse(cieMap)) == null) continue;
            this.processFde(info, ctx, fde);
        }
    }

    public <U extends UnwindSection> void processFde(UnwindInfo<U> info, UninitializedUnwindContext ctx, FrameDescriptionEntry fde) {
        UnwindTableRow row;
        Register ra = fde.cie.returnAddressRegister;
        UnwindTable table = fde.rows((UnwindSection)info.section, info.bases, ctx);
        ArrayList<UnwindTableRow> rows = new ArrayList<UnwindTableRow>();
        while ((row = table.nextRow()) != null) {
            UnwindTableRow c = row._clone();
            rows.add(c);
        }
        UnwindTableRow firstRow = (UnwindTableRow)rows.get(0);
        long start = firstRow.startAddress;
        long length = ((UnwindTableRow)rows.get((int)(rows.size() - 1))).endAddress - start;
        if (start < info.loadAddress) {
            return;
        }
        HashMap<Long, RegisterRule> ruleCache = new HashMap<Long, RegisterRule>();
        CfaRule cfaCache = null;
        for (UnwindTableRow row2 : rows) {
            long startAddr;
            boolean written = false;
            StringBuilder line = new StringBuilder();
            if (row2.startAddress == start) {
                startAddr = start - info.loadAddress;
                line.append(String.format(Locale.ROOT, "STACK CFI INIT %x %x", startAddr, length));
            } else {
                startAddr = row2.startAddress - info.loadAddress;
                line.append(String.format(Locale.ROOT, "STACK CFI %x", startAddr));
            }
            if (cfaCache == null || !cfaCache.equals(row2.cfa)) {
                cfaCache = row2.cfa;
                written = EhFrameParser.writeCfaRule(line, info.arch, row2.cfa);
            }
            for (RegisterRulePair pair : row2.registers.rules()) {
                long r = pair.register.val;
                RegisterRule cacheRule = (RegisterRule)ruleCache.get(r);
                if (cacheRule != null && cacheRule.equals(pair.registerRule)) continue;
                ruleCache.put(r, pair.registerRule);
                written = EhFrameParser.writeRegisterRule(line, info.arch, pair.register, pair.registerRule, ra);
            }
            if (!written) continue;
            SymtabFile.writeStrToBuffer(this.fileChannel, this.buffer, line + "\n");
        }
    }

    public static boolean writeCfaRule(StringBuilder target, Arch arch, CfaRule rule) {
        String formatted = "";
        if (rule.registerAndOffset != null) {
            String reg = arch.cpuFamily().cfiRegisterName(rule.registerAndOffset.register.val);
            if (reg != null) {
                formatted = String.format(Locale.ROOT, "%s %d +", reg, rule.registerAndOffset.offset);
            } else {
                return false;
            }
        }
        if (rule.expression != null) {
            return false;
        }
        target.append(String.format(Locale.ROOT, " .cfa: %s", formatted));
        return true;
    }

    public static boolean writeRegisterRule(StringBuilder target, Arch arch, Register register, RegisterRule rule, Register ra) {
        String registerName;
        String reg;
        String formatted = "";
        if (rule.undefined != null) {
            return false;
        }
        if (rule.sameValue != null) {
            reg = arch.cpuFamily().cfiRegisterName(register.val);
            if (reg != null) {
                formatted = reg;
            } else {
                return false;
            }
        }
        if (rule.offset != null) {
            formatted = String.format(Locale.ROOT, ".cfa %d + ^", rule.offset);
        }
        if (rule.valueOffset != null) {
            formatted = String.format(Locale.ROOT, ".cfa %d + ^", rule.valueOffset);
        }
        if (rule.register != null) {
            reg = arch.cpuFamily().cfiRegisterName(rule.register.val);
            if (reg != null) {
                formatted = reg;
            } else {
                return false;
            }
        }
        if (rule.expression != null) {
            return false;
        }
        if (rule.valExpression != null) {
            return false;
        }
        if (rule.architectural != null) {
            return false;
        }
        if (register.val == ra.val) {
            registerName = ".ra";
        } else {
            String reg2;
            if (register.val == 265) {
                boolean bl = true;
            }
            if ((reg2 = arch.cpuFamily().cfiRegisterName(register.val)) != null) {
                registerName = reg2;
            } else {
                return false;
            }
        }
        target.append(String.format(Locale.ROOT, " %s: %s", registerName, formatted));
        return true;
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return this.binaryFileReader.skip(this.sectionOffset);
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            Log.error("Failed to open file\uff1a%s", this.fileName);
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean parse(BufferedWriter writer) {
        try {
            Log.info("Contents of the .eh_frame section:\n\n", new Object[0]);
            if (!this.openFile()) {
                this.close();
                return false;
            }
            long cieId = 0L;
            int fdeLsdaEncoding = 255;
            int fdePointerEncoding = 255;
            boolean cieAugmentationStringHasZ = false;
            long fdePcBegin = 0L;
            long fdePcBeginSize = 64L;
            long addressOfLocation = 0L;
            while (this.binaryFileReader.getOffset() - this.sectionOffset < this.sectionSize) {
                long cieIdOrPointer;
                long cieSectionOffset = this.binaryFileReader.getOffset() - this.sectionOffset;
                long length = this.binaryFileReader.readUInt();
                if (length == 0L) {
                    Log.error("CIE process end", new Object[0]);
                    break;
                }
                long dwarfFormat = Long.compare(length, -1L) == 0 ? 64L : 32L;
                long extendedLength = 0L;
                if (dwarfFormat == 64L) {
                    extendedLength = this.binaryFileReader.readULong();
                }
                if ((cieIdOrPointer = this.binaryFileReader.readUInt()) != 0L) continue;
                fdeLsdaEncoding = 255;
                fdePointerEncoding = 255;
                cieAugmentationStringHasZ = false;
                cieId = cieSectionOffset;
                byte version = this.binaryFileReader.readByte();
                StringBuilder sb = new StringBuilder();
                char c = '\u0000';
                while ((c = (char)(this.binaryFileReader.readByte() & 0xFF)) != '\u0000') {
                    sb.append(c);
                }
                String augmentationString = sb.toString();
                long ehData = 0L;
                if (augmentationString.contains("eh")) {
                    ehData = dwarfFormat == 32L ? this.binaryFileReader.readUInt() : this.binaryFileReader.readULong();
                }
                long codeAlignmentFactor = Leb128Parser.parseULeb128(this.binaryFileReader);
                long dataAlignmentFactor = Leb128Parser.parseSLeb128(this.binaryFileReader);
                short returnAddressRegister = this.binaryFileReader.readByte();
                byte[] augmentationData = null;
                long augmentationDataLength = 0L;
                if (augmentationString.charAt(0) != 'z') continue;
                cieAugmentationStringHasZ = true;
                augmentationDataLength = Leb128Parser.parseULeb128(this.binaryFileReader);
                augmentationData = new byte[(int)augmentationDataLength];
                this.binaryFileReader.readByteArray(augmentationData);
                block8: for (int i = 1; i < augmentationString.length(); ++i) {
                    char cc = augmentationString.charAt(i);
                    switch (cc) {
                        case 'L': {
                            fdeLsdaEncoding = this.binaryFileReader.readByte();
                            continue block8;
                        }
                        case 'P': {
                            short s = this.binaryFileReader.readByte();
                        }
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    public ElfObject getElfObject() {
        return this.elfObject;
    }

    public String getArchName() {
        return this.archName;
    }

    public BufferedWriter getWriter() {
        return this.writer;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public BinaryFileReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public void setElfObject(ElfObject elfObject) {
        this.elfObject = elfObject;
    }

    public void setArchName(String archName) {
        this.archName = archName;
    }

    public void setWriter(BufferedWriter writer) {
        this.writer = writer;
    }

    public void setFileChannel(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSectionOffset(long sectionOffset) {
        this.sectionOffset = sectionOffset;
    }

    public void setSectionSize(long sectionSize) {
        this.sectionSize = sectionSize;
    }

    public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EhFrameParser)) {
            return false;
        }
        EhFrameParser other = (EhFrameParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSectionOffset() != other.getSectionOffset()) {
            return false;
        }
        if (this.getSectionSize() != other.getSectionSize()) {
            return false;
        }
        ElfObject this$elfObject = this.getElfObject();
        ElfObject other$elfObject = other.getElfObject();
        if (this$elfObject == null ? other$elfObject != null : !this$elfObject.equals(other$elfObject)) {
            return false;
        }
        String this$archName = this.getArchName();
        String other$archName = other.getArchName();
        if (this$archName == null ? other$archName != null : !this$archName.equals(other$archName)) {
            return false;
        }
        BufferedWriter this$writer = this.getWriter();
        BufferedWriter other$writer = other.getWriter();
        if (this$writer == null ? other$writer != null : !this$writer.equals(other$writer)) {
            return false;
        }
        FileChannel this$fileChannel = this.getFileChannel();
        FileChannel other$fileChannel = other.getFileChannel();
        if (this$fileChannel == null ? other$fileChannel != null : !this$fileChannel.equals(other$fileChannel)) {
            return false;
        }
        ByteBuffer this$buffer = this.getBuffer();
        ByteBuffer other$buffer = other.getBuffer();
        if (this$buffer == null ? other$buffer != null : !((Object)this$buffer).equals(other$buffer)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        BinaryFileReader this$binaryFileReader = this.getBinaryFileReader();
        BinaryFileReader other$binaryFileReader = other.getBinaryFileReader();
        return !(this$binaryFileReader == null ? other$binaryFileReader != null : !this$binaryFileReader.equals(other$binaryFileReader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EhFrameParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sectionOffset = this.getSectionOffset();
        result = result * 59 + (int)($sectionOffset >>> 32 ^ $sectionOffset);
        long $sectionSize = this.getSectionSize();
        result = result * 59 + (int)($sectionSize >>> 32 ^ $sectionSize);
        ElfObject $elfObject = this.getElfObject();
        result = result * 59 + ($elfObject == null ? 43 : $elfObject.hashCode());
        String $archName = this.getArchName();
        result = result * 59 + ($archName == null ? 43 : $archName.hashCode());
        BufferedWriter $writer = this.getWriter();
        result = result * 59 + ($writer == null ? 43 : $writer.hashCode());
        FileChannel $fileChannel = this.getFileChannel();
        result = result * 59 + ($fileChannel == null ? 43 : $fileChannel.hashCode());
        ByteBuffer $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : ((Object)$buffer).hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        BinaryFileReader $binaryFileReader = this.getBinaryFileReader();
        result = result * 59 + ($binaryFileReader == null ? 43 : $binaryFileReader.hashCode());
        return result;
    }

    public String toString() {
        return "EhFrameParser(elfObject=" + this.getElfObject() + ", archName=" + this.getArchName() + ", writer=" + this.getWriter() + ", fileChannel=" + this.getFileChannel() + ", buffer=" + this.getBuffer() + ", fileName=" + this.getFileName() + ", sectionOffset=" + this.getSectionOffset() + ", sectionSize=" + this.getSectionSize() + ", binaryFileReader=" + this.getBinaryFileReader() + ")";
    }
}

