/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.dwarf.EndianSlice;
import com.uqm.crashsight.symtabtool.dwarf.Endianity;
import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import com.uqm.crashsight.symtabtool.dwarf.Reader;
import com.uqm.crashsight.symtabtool.dwarf.UnwindSectionExt;

class EhFrame<Endian extends Endianity>
implements UnwindSectionExt {
    EndianSlice<Endian> section;
    byte addressSize;

    EhFrame() {
    }

    @Override
    public void setAddressSize(byte addressSize) {
        this.addressSize = addressSize;
    }

    public static <Endian extends Endianity> EhFrame<Endian> from(EndianSlice<Endian> section) {
        EhFrame<Endian> ehFrame = new EhFrame<Endian>();
        ehFrame.section = section;
        ehFrame.addressSize = (byte)8;
        return ehFrame;
    }

    public static <Endian extends Endianity> EhFrame<Endian> _new(ParseBuffer section, Endian endian) {
        EndianSlice<Endian> slice = new EndianSlice<Endian>(section, endian);
        return EhFrame.from(slice);
    }

    @Override
    public Reader section() {
        return this.section;
    }

    @Override
    public boolean lengthValueIsEndOfEntries(Long offset) {
        return offset == 0L;
    }

    @Override
    public boolean hasAddressAndSegmentSizes(short version) {
        return false;
    }

    @Override
    public short addressSize() {
        return this.addressSize;
    }

    @Override
    public short segmentSize() {
        return 0;
    }

    @Override
    public Long resolveCieOffset(long base, long offset) {
        if (base < offset) {
            return null;
        }
        return base - offset;
    }
}

