/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.SubroutineVariable;
import com.uqm.crashsight.symtabtool.common.VariableEntry;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.dwarf.DebugAbbrevParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugAddrParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugInfoPasrser;
import com.uqm.crashsight.symtabtool.dwarf.DebugLineParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugLineStrParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugRangesParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugRnglistParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugStrOffsetsParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugStrParser;
import com.uqm.crashsight.symtabtool.dwarf.DwarfInfoBean;
import com.uqm.crashsight.symtabtool.symtab.Symbol;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class DwarfParser {
    public static final long DWARF2_VERSION = 2L;
    public static final long DWARF3_VERSION = 3L;
    public static final long DWARF4_VERSION = 4L;
    public static final long DWARF5_VERSION = 5L;
    public static final long DWARF_ADDR_BITS_32 = 32L;
    public static final long DWARF_ADDR_BITS_64 = 64L;
    public static final long FILE_FORMAT_32 = 32L;
    public static final long FILE_FORMAT_64 = 64L;
    public static final long DWARF_FORMAT_32 = 32L;
    public static final long DWARF_FORMAT_64 = 64L;
    public int cunum = 0;
    private String fileName = null;
    private long fileFormat = 0L;
    long dwarfVersion = 4L;
    private DebugAbbrevParser debugAbbrev = null;
    private DebugInfoPasrser debugInfo = null;
    private DebugStrParser debugStr = null;
    private DebugLineParser debugLine = null;
    private DebugRangesParser debugRanges = null;
    private long parseDebugLineCost = 0L;
    private DebugStrOffsetsParser debugStrOffsetsParser = null;
    private DebugLineStrParser debugLineStrParser = null;
    private DebugRnglistParser debugRnglistParser = null;
    private DebugAddrParser debugAddrParser = null;

    private DwarfParser() {
    }

    public DwarfParser(String fileName) {
        this.setFileName(fileName);
    }

    private static void sortSubroutineTable(Vector<Subroutine> subroutineTable) {
        Collections.sort(subroutineTable, new Comparator<Subroutine>(){

            @Override
            public int compare(Subroutine a, Subroutine b) {
                if (a.getLowPc() == b.getLowPc()) {
                    return a.getLevel() - b.getLevel();
                }
                return (int)(a.getLowPc() - b.getLowPc());
            }
        });
    }

    private static void sortLineInfoTable(Vector<DebugLineParser.DebugLineEntry> lineInfoTable) {
        Collections.sort(lineInfoTable, new Comparator<DebugLineParser.DebugLineEntry>(){

            @Override
            public int compare(DebugLineParser.DebugLineEntry a, DebugLineParser.DebugLineEntry b) {
                return (int)(a.getAddress() - b.getAddress());
            }
        });
    }

    public static SymbolTable getSymbolTable(Vector<Subroutine> subroutines, DwarfInfoBean dwarfInfoBean) {
        DwarfParser dwarfParser = new DwarfParser();
        dwarfParser.getDwarfInfo(dwarfInfoBean);
        SymbolTable symbolTable = dwarfParser.getSymbolTable(subroutines);
        dwarfParser.close();
        return symbolTable;
    }

    private boolean setFileName(String fileName) {
        if (null == fileName) {
            return false;
        }
        this.fileName = fileName;
        return true;
    }

    public boolean setDebugAbbrev(long sectionOffset, long sectionSize) {
        if (sectionOffset < 0L || sectionSize <= 0L) {
            Log.error("Not a valid debug_abbrev section", new Object[0]);
            return false;
        }
        this.debugAbbrev = new DebugAbbrevParser(this.fileName, sectionOffset, sectionSize);
        return true;
    }

    public boolean setDebugStrOffsets(long sectionOffset, long sectionSize) {
        if (sectionOffset < 0L || sectionSize <= 0L) {
            Log.error("Not a valid debug_str_offsets section", new Object[0]);
            return false;
        }
        this.debugStrOffsetsParser = new DebugStrOffsetsParser(this.fileName, sectionOffset, sectionSize);
        return true;
    }

    public boolean setDebugInfo(long sectionOffset, long sectionSize, DebugStrOffsetsParser debugStrOffsetsParser) {
        if (sectionOffset < 0L || sectionSize <= 0L) {
            Log.error("Not a valid debug_info section", new Object[0]);
            return false;
        }
        this.debugInfo = new DebugInfoPasrser(this.fileName, sectionOffset, sectionSize, debugStrOffsetsParser);
        return true;
    }

    public boolean setDebugStr(long sectionOffset, long sectionSize) {
        if (sectionOffset < 0L || sectionSize <= 0L) {
            Log.error("Not a valid debug_str section", new Object[0]);
            return false;
        }
        this.debugStr = new DebugStrParser(this.fileName, sectionOffset, sectionSize);
        return true;
    }

    public boolean setDebugLine(long sectionOffset, long sectionSize) {
        if (sectionOffset < 0L || sectionSize <= 0L) {
            Log.error("Not a valid debug_line section", new Object[0]);
            return false;
        }
        this.debugLine = new DebugLineParser(this.fileName, sectionOffset, sectionSize);
        return true;
    }

    public void setDebugRanges(long sectionOffset, long sectionSize) {
        if (sectionOffset < 0L || sectionSize <= 0L) {
            return;
        }
        this.debugRanges = new DebugRangesParser(this.fileName, sectionOffset, sectionSize);
    }

    public void setDebugLineStr(long sectionOffset, long sectionSize) {
        if (sectionOffset < 0L || sectionSize <= 0L) {
            return;
        }
        this.debugLineStrParser = new DebugLineStrParser(this.fileName, sectionOffset, sectionSize);
    }

    public void setDebugRnglist(long sectionOffset, long sectionSize, DebugAddrParser debugAddrParser) {
        if (sectionOffset < 0L || sectionSize <= 0L) {
            return;
        }
        this.debugRnglistParser = new DebugRnglistParser(this.fileName, sectionOffset, sectionSize);
        this.debugRnglistParser.setDebugAddrParser(debugAddrParser);
    }

    public void setDebugAddr(long sectionOffset, long sectionSize) {
        if (sectionOffset < 0L || sectionSize <= 0L) {
            return;
        }
        this.debugAddrParser = new DebugAddrParser(this.fileName, sectionOffset, sectionSize);
    }

    private void getDwarfInfo(DwarfInfoBean dwarfInfoBean) {
        if (!this.setFileName(dwarfInfoBean.getFileName())) {
            return;
        }
        if (!this.setDebugAbbrev(dwarfInfoBean.getDebugAbbrevOffset(), dwarfInfoBean.getDebugAbbrevSize())) {
            return;
        }
        if (!this.setDebugLine(dwarfInfoBean.getDebugLineOffset(), dwarfInfoBean.getDebugLineSize())) {
            return;
        }
        this.setDebugStr(dwarfInfoBean.getDebugStrOffset(), dwarfInfoBean.getDebugStrSize());
        this.setDebugRanges(dwarfInfoBean.getDebugRangesOffset(), dwarfInfoBean.getDebugRangesSize());
        this.setDebugStrOffsets(dwarfInfoBean.getDebugStrOffsetsOffset(), dwarfInfoBean.getDebugStrOffsetsSize());
        this.setDebugLineStr(dwarfInfoBean.getDebugLineStrOffset(), dwarfInfoBean.getDebugLineStrSize());
        this.setDebugAddr(dwarfInfoBean.getDebugAddrOffset(), dwarfInfoBean.getDebugAddrSize());
        this.setDebugRnglist(dwarfInfoBean.getDebugRngListOffset(), dwarfInfoBean.getDebugRngListSize(), this.debugAddrParser);
        if (!this.setDebugInfo(dwarfInfoBean.getDebugInfoOffset(), dwarfInfoBean.getDebugInfoSize(), this.debugStrOffsetsParser)) {
            return;
        }
        long dwarfVersion = 4L;
        if (dwarfInfoBean.getDebugRngListOffset() != -1L) {
            dwarfVersion = 5L;
        }
        this.dwarfVersion = dwarfVersion;
    }

    private boolean checkInit() {
        if (null == this.fileName) {
            return false;
        }
        if (null == this.debugAbbrev) {
            return false;
        }
        if (null == this.debugInfo) {
            return false;
        }
        if (null == this.debugLine) {
            return false;
        }
        if (32L != this.debugLine.getAddrBits() && 64L == this.debugLine.getAddrBits()) {
            Log.error("File format no setting", new Object[0]);
            return false;
        }
        return true;
    }

    public boolean setFileFormat(long addrBits) {
        switch ((int)addrBits) {
            case 4: 
            case 32: {
                this.fileFormat = 32L;
                break;
            }
            case 8: 
            case 64: {
                this.fileFormat = 64L;
                break;
            }
            default: {
                Log.warn("Address bits error", new Object[0]);
                return false;
            }
        }
        return true;
    }

    public long getFileFormat() {
        return this.fileFormat;
    }

    private boolean checkFileFormat() {
        return 0L != this.fileFormat;
    }

    private boolean setDebugLineAddrBits() {
        if (32L == this.fileFormat) {
            this.debugLine.setAddrBits(32L);
        } else if (64L == this.fileFormat) {
            this.debugLine.setAddrBits(64L);
        } else {
            Log.error("File format error", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean setDebugRangesAddrBits() {
        if (null == this.debugRanges) {
            return true;
        }
        if (32L == this.fileFormat) {
            this.debugRanges.setAddrBits(32L);
        } else if (64L == this.fileFormat) {
            this.debugRanges.setAddrBits(64L);
        } else {
            Log.error("File format error", new Object[0]);
            return false;
        }
        return true;
    }

    private long getDebugLineOffset(HashMap<Long, DebugInfoPasrser.DebugInfoEntry> debugInfoTable) {
        DebugInfoPasrser.DebugInfoEntry entry = debugInfoTable.get(this.debugInfo.getCuDieOffset());
        if (null == entry) {
            Log.error("Failed to get debug info table", new Object[0]);
            return 0L;
        }
        String attributeValue = entry.getAttribute(16L);
        if (null == attributeValue) {
            Log.error("Compilation unit has not DW_AT_stmt_list", new Object[0]);
            return 0L;
        }
        return Long.parseLong(attributeValue, 16);
    }

    private Vector<DebugLineParser.DebugLineEntry> getLineInfoTable(long offset) {
        long startTime = System.currentTimeMillis();
        if (!this.checkFileFormat()) {
            return null;
        }
        Vector<DebugLineParser.DebugLineEntry> lineInfoTable = this.debugLine.getLineInfoTable(offset, this.debugStr, this.debugLineStrParser);
        DwarfParser.sortLineInfoTable(lineInfoTable);
        this.parseDebugLineCost += System.currentTimeMillis() - startTime;
        return lineInfoTable;
    }

    private String parseSubroutineName(Map<Long, DebugInfoPasrser.DebugInfoEntry> debugInfoTable, DebugInfoPasrser.DebugInfoEntry debugInfoEntry, HashSet<DebugInfoPasrser.DebugInfoEntry> backupEntries) {
        String name;
        block19: {
            String mipsLinkageName;
            long at = 0L;
            name = debugInfoEntry.getAttribute(3L);
            if (null != name) {
                at = 3L;
            }
            if (null != (mipsLinkageName = debugInfoEntry.getAttribute(8199L))) {
                name = mipsLinkageName;
                at = 8199L;
            } else {
                String linkageName = debugInfoEntry.getAttribute(110L);
                if (null != linkageName) {
                    name = linkageName;
                    at = 110L;
                }
            }
            try {
                if (at == 0L) break block19;
                long form = debugInfoEntry.getAttributeForm().get(at);
                switch ((int)form) {
                    case 8: {
                        break;
                    }
                    case 14: {
                        String debugString = this.debugStr.getString(Long.parseLong(name, 16));
                        if (null == debugString) break;
                        name = debugString;
                        break;
                    }
                    case 31: {
                        String debugString = this.debugLineStrParser.getString(Long.parseLong(name, 16));
                        if (null == debugString) break;
                        name = debugString;
                        break;
                    }
                    case 26: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        try {
                            long strOffsetsBase = Long.parseLong(debugInfoEntry.getCompileUnit().getAttribute(114L), 16);
                            long offsetIndex = Long.parseLong(name, 16);
                            long offset = this.debugStrOffsetsParser.getStrOffset(strOffsetsBase, (int)offsetIndex);
                            String debugString = this.debugStr.getString(offset);
                            if (null != debugString) {
                                name = debugString;
                            }
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (name != null) {
            return name;
        }
        String attributeValue = debugInfoEntry.getAttribute(71L);
        if (null == attributeValue && null == (attributeValue = debugInfoEntry.getAttribute(49L))) {
            return null;
        }
        long offset = Long.parseLong(attributeValue, 16);
        DebugInfoPasrser.DebugInfoEntry referenceEntry = debugInfoTable.get(offset);
        if (null == referenceEntry || referenceEntry == debugInfoEntry) {
            return null;
        }
        if (backupEntries.contains(referenceEntry)) {
            return null;
        }
        backupEntries.add(referenceEntry);
        return this.parseSubroutineName(debugInfoTable, referenceEntry, backupEntries);
    }

    private String parseSubroutineName(Map<Long, DebugInfoPasrser.DebugInfoEntry> debugInfoTable, DebugInfoPasrser.DebugInfoEntry debugInfoEntry) {
        return this.parseSubroutineName(debugInfoTable, debugInfoEntry, new HashSet<DebugInfoPasrser.DebugInfoEntry>());
    }

    private String getInlineFuncName(DebugInfoPasrser.DebugInfoEntry debugInfoEntry, String name) {
        String parentName = null;
        for (DebugInfoPasrser.DebugInfoEntry parent = debugInfoEntry.getParent(); parent != null && parent.getLevel() > 0; parent = parent.getParent()) {
            if (StringUtils.isEmpty(parent.getName())) {
                continue;
            }
            parentName = parent.getName();
            break;
        }
        if (parentName == null) {
            return name;
        }
        if (debugInfoEntry.getTag() == 29L) {
            StringBuilder sb = new StringBuilder();
            long callLine = Long.parseLong(debugInfoEntry.getAttribute(89L), 16);
            long fileIndex = Long.parseLong(debugInfoEntry.getAttribute(88L), 16);
            String callFile = this.debugLine.getSourceFile((int)fileIndex);
            sb.append(parentName).append("!").append(callFile).append("!").append(callLine).append(";").append(name);
            return sb.toString();
        }
        if (StringUtils.isEmpty(name)) {
            return parentName;
        }
        return parentName + ";" + name;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Vector<Subroutine> parseEntrySubroutines(Map<Long, DebugInfoPasrser.DebugInfoEntry> debugInfoTable, DebugInfoPasrser.DebugInfoEntry debugInfoEntry) {
        if (null == this.debugRanges && null == this.debugRnglistParser) {
            return null;
        }
        Vector<Object> ranges = new Vector();
        if (5L != this.dwarfVersion) {
            String attributeValue = debugInfoEntry.getAttribute(85L);
            if (null != attributeValue) {
                long offset = Long.parseLong(attributeValue, 16);
                if (offset == 704536L) {
                    boolean bl = true;
                }
                if (null != (ranges = this.debugRanges.getRangesTable(offset))) {
                    // empty if block
                }
            }
        } else {
            long offsetLocation;
            Vector<DebugRnglistParser.DebugRangeEntry> dwarf5Ranges;
            String attributeValue;
            long addrBase = 0L;
            long rnglistsBase = 0L;
            for (Map.Entry<Long, DebugInfoPasrser.DebugInfoEntry> entry : this.debugInfo.debugInfoTable.entrySet()) {
                if (entry.getValue().getTag() != 17L) continue;
                String hex = entry.getValue().attributeTable.get(115L);
                if (hex != null) {
                    addrBase = Long.parseLong(hex, 16);
                }
                if ((hex = entry.getValue().attributeTable.get(116L)) == null) break;
                rnglistsBase = Long.parseLong(hex, 16);
                break;
            }
            if (null == (attributeValue = debugInfoEntry.getAttribute(85L)) || null == (dwarf5Ranges = this.debugRnglistParser.getRangesTable(offsetLocation = Long.parseLong(attributeValue, 16), addrBase, rnglistsBase))) {
                // empty if block
            }
        }
        if (null == ranges || ranges.isEmpty()) {
            return null;
        }
        String name = this.parseSubroutineName(debugInfoTable, debugInfoEntry);
        if (null == (name = this.getInlineFuncName(debugInfoEntry, name))) {
            return null;
        }
        if (StringUtils.contains((CharSequence)name, "testCrashLevel1")) {
            boolean offset = true;
        }
        debugInfoEntry.setName(name);
        Vector<Subroutine> subroutines = new Vector<Subroutine>();
        Iterator<Object> iterator2 = ranges.iterator();
        while (iterator2.hasNext()) {
            DebugRangesParser.DebugRangeEntry debugRangeEntry = (DebugRangesParser.DebugRangeEntry)iterator2.next();
            Subroutine subroutine = new Subroutine();
            subroutine.setLowPc(debugRangeEntry.getLowPc());
            subroutine.setHighPc(debugRangeEntry.getHighPc());
            subroutine.setLevel(debugInfoEntry.getLevel());
            subroutine.setName(name);
            subroutines.add(subroutine);
        }
        return subroutines;
    }

    private Subroutine parseSubroutine(Map<Long, DebugInfoPasrser.DebugInfoEntry> debugInfoTable, DebugInfoPasrser.DebugInfoEntry debugInfoEntry) {
        String attributeValue;
        Long lowPc = this.parsePc(debugInfoEntry, 17L);
        if (lowPc == null) {
            return null;
        }
        if (lowPc == 6707964L) {
            boolean bl = true;
        }
        if (null == (attributeValue = debugInfoEntry.getAttribute(18L))) {
            return null;
        }
        long highPc = Long.parseLong(attributeValue, 16);
        if (highPc < lowPc) {
            highPc = lowPc + highPc;
        }
        Subroutine subroutine = new Subroutine();
        subroutine.setLowPc(lowPc);
        subroutine.setHighPc(highPc);
        String name = this.parseSubroutineName(debugInfoTable, debugInfoEntry);
        name = this.getInlineFuncName(debugInfoEntry, name);
        if (null == name) {
            return null;
        }
        if (StringUtils.contains((CharSequence)name, "testCrashLevel1")) {
            boolean bl = true;
        }
        subroutine.setName(name);
        debugInfoEntry.setName(name);
        subroutine.setLevel(debugInfoEntry.getLevel());
        return subroutine;
    }

    private Long parsePc(DebugInfoPasrser.DebugInfoEntry debugInfoEntry, long attribute) {
        String attributeValue = debugInfoEntry.getAttribute(attribute);
        if (null == attributeValue) {
            return null;
        }
        long form = debugInfoEntry.getAttributeForm().get(attribute);
        switch ((int)form) {
            case 1: 
            case 14: {
                return Long.parseLong(attributeValue, 16);
            }
            case 27: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                DebugInfoPasrser.DebugInfoEntry cu = debugInfoEntry.getCompileUnit();
                long addrBase = Long.parseLong(cu.getAttribute(115L), 16);
                long addressIndex = Long.parseLong(attributeValue, 16);
                return this.debugAddrParser.getAddress(addrBase, (int)addressIndex);
            }
        }
        return null;
    }

    public TreeMap<Long, List<Subroutine>> filterOutSubroutines(Map<Long, DebugInfoPasrser.DebugInfoEntry> debugInfoTable) {
        TreeMap<Long, List<Subroutine>> subroutineTable = new TreeMap<Long, List<Subroutine>>();
        for (Map.Entry<Long, DebugInfoPasrser.DebugInfoEntry> entry : debugInfoTable.entrySet()) {
            DebugInfoPasrser.DebugInfoEntry debugInfoEntry = entry.getValue();
            if (debugInfoEntry.getTag() == 17L) continue;
            Subroutine subroutine = null;
            Vector<Subroutine> subroutines = this.parseEntrySubroutines(debugInfoTable, debugInfoEntry);
            if (null != subroutines) {
                for (Subroutine subroutine1 : subroutines) {
                    List list = subroutineTable.getOrDefault(subroutine1.getHighPc(), new ArrayList());
                    list.add(subroutine1);
                    subroutineTable.put(subroutine1.getHighPc(), list);
                    if (subroutine1.getHighPc() != 6707986L) continue;
                    boolean bl = true;
                }
            } else {
                subroutine = this.parseSubroutine(debugInfoTable, debugInfoEntry);
                if (null != subroutine) {
                    List list = subroutineTable.getOrDefault(subroutine.getHighPc(), new ArrayList());
                    list.add(subroutine);
                    subroutineTable.put(subroutine.getHighPc(), list);
                    if (subroutine.getHighPc() == 6707986L) {
                        boolean bl = true;
                    }
                }
            }
            if (subroutine == null && (subroutines == null || subroutines.size() <= 0)) continue;
            debugInfoEntry.subroutines = new ArrayList<Subroutine>();
            if (subroutine != null) {
                debugInfoEntry.subroutines.add(subroutine);
                continue;
            }
            debugInfoEntry.subroutines.addAll(subroutines);
        }
        return subroutineTable;
    }

    private VariableEntry parseVariable(Map<Long, DebugInfoPasrser.DebugInfoEntry> debugInfoTable, DebugInfoPasrser.DebugInfoEntry debugInfoEntry) {
        VariableEntry variable = new VariableEntry();
        String location = debugInfoEntry.getAttribute(2L);
        if (location == null) {
            return null;
        }
        if (!StringUtils.startsWith(location, "block_")) {
            return null;
        }
        location = location.substring("block_".length());
        byte[] block = Base64.getDecoder().decode(location);
        variable.setBlock(block);
        variable.setBlockHex(Utils.byteArrayToHexString(block));
        String readable = this.debugInfo.parseLocation(block);
        if (StringUtils.isEmpty(readable)) {
            readable = "block: " + variable.getBlockHex();
        }
        variable.setReadable(readable);
        String name = debugInfoEntry.getAttribute(3L);
        if (name == null) {
            name = "null";
        } else {
            try {
                long offset = Long.parseLong(name, 16);
                String debugString = this.debugStr.getString(offset);
                if (null != debugString) {
                    name = debugString;
                }
            }
            catch (NumberFormatException offset) {
                // empty catch block
            }
        }
        variable.setName(name);
        if (name.equals("stackLocalA")) {
            boolean offset = true;
        }
        long size = 0L;
        try {
            String typeOffset = debugInfoEntry.getAttribute(73L);
            long cuOffset = Long.parseLong(typeOffset, 16);
            DebugInfoPasrser.DebugInfoEntry typeEntry = debugInfoTable.get(cuOffset);
            while (typeEntry != null) {
                String byteSize = typeEntry.getAttribute(11L);
                if (byteSize != null) {
                    size = Long.parseLong(byteSize, 16);
                    break;
                }
                typeOffset = typeEntry.getAttribute(73L);
                cuOffset = Long.parseLong(typeOffset, 16);
                typeEntry = debugInfoTable.get(cuOffset);
            }
        }
        catch (Throwable e) {
            return null;
        }
        if (size == 0L) {
            return null;
        }
        variable.setSize(size);
        return variable;
    }

    public List<SubroutineVariable> filterOutVariables(Map<Long, DebugInfoPasrser.DebugInfoEntry> debugInfoTable) {
        LinkedHashMap subroutineMap = new LinkedHashMap();
        for (Map.Entry<Long, DebugInfoPasrser.DebugInfoEntry> entry : debugInfoTable.entrySet()) {
            List<VariableEntry> variableEntries;
            VariableEntry variableEntry;
            DebugInfoPasrser.DebugInfoEntry die = entry.getValue();
            if (die.getTag() != 5L && die.getTag() != 52L || (variableEntry = this.parseVariable(debugInfoTable, die)) == null || die.getParent() == null || die.getParent().subroutines == null) continue;
            if (subroutineMap.containsKey(die.getParent().cuOffset)) {
                variableEntries = (List)subroutineMap.get(die.getParent().cuOffset);
                variableEntries.add(variableEntry);
                continue;
            }
            variableEntries = new ArrayList<VariableEntry>();
            variableEntries.add(variableEntry);
            subroutineMap.put(die.getParent().cuOffset, variableEntries);
        }
        ArrayList<SubroutineVariable> subroutineVariables = new ArrayList<SubroutineVariable>();
        for (Map.Entry entry : subroutineMap.entrySet()) {
            DebugInfoPasrser.DebugInfoEntry parent = debugInfoTable.get(entry.getKey());
            SubroutineVariable subroutineVariable = new SubroutineVariable();
            subroutineVariable.setSubroutines(parent.subroutines);
            subroutineVariable.setVariableEntries((List)entry.getValue());
            subroutineVariables.add(subroutineVariable);
        }
        return subroutineVariables;
    }

    private int dfs() {
        return 1;
    }

    private void splitInline(Vector<Subroutine> subroutineTable, Subroutine subroutine) {
        Subroutine preSubroutine;
        if (!subroutineTable.isEmpty() && (preSubroutine = subroutineTable.lastElement()).getHighPc() > subroutine.getLowPc()) {
            subroutineTable.lastElement().setHighPc(subroutine.getHighPc());
        }
    }

    private void setSymbolValue(Symbol symbol, DebugLineParser.DebugLineEntry lineInfo) {
        symbol.setAddress(lineInfo.getAddress());
        symbol.setSourceFile(lineInfo.getPathName());
        symbol.setSourceLine(lineInfo.getLineNumber());
        symbol.setSourceEndLine(lineInfo.getEndLineNumber());
        symbol.setSourceColumn(lineInfo.getColumnNumber());
    }

    private void setSymbolValue(Symbol symbol, Subroutine subroutine) {
        symbol.setAddress(subroutine.getLowPc());
        symbol.setEndAddress(subroutine.getHighPc());
        symbol.setFunction(subroutine.getName());
    }

    private Vector<Symbol> mergeToSymbolTable(Vector<DebugLineParser.DebugLineEntry> lineInfoTable, Vector<Subroutine> subroutineTable) {
        int parentIndex;
        Long start = System.currentTimeMillis();
        Vector<Symbol> table = new Vector<Symbol>();
        int nextParentIndex = parentIndex = 0;
        int childIndex = parentIndex;
        for (int i = 0; i < lineInfoTable.size(); ++i) {
            DebugLineParser.DebugLineEntry lineInfo = lineInfoTable.elementAt(i);
            if (lineInfo.getAddress() == 219199232L) {
                boolean bl = true;
            }
            DebugLineParser.DebugLineEntry nextLineInfo = null;
            if (i + 1 < lineInfoTable.size()) {
                nextLineInfo = lineInfoTable.elementAt(i + 1);
            }
            Symbol symbol = new Symbol();
            if (parentIndex >= subroutineTable.size()) {
                this.setSymbolValue(symbol, lineInfo);
                table.add(symbol);
                continue;
            }
            Subroutine parentNode = subroutineTable.elementAt(parentIndex);
            if (parentNode.beyond(lineInfo.getAddress())) {
                this.setSymbolValue(symbol, lineInfo);
                table.add(symbol);
                continue;
            }
            if (parentNode.below(lineInfo.getAddress())) {
                this.setSymbolValue(symbol, parentNode);
                table.add(symbol);
                ++parentIndex;
                --i;
                continue;
            }
            if (!parentNode.contain(lineInfo.getAddress())) continue;
            nextParentIndex = parentIndex;
            childIndex = parentIndex;
            this.setSymbolValue(symbol, lineInfo);
            symbol.setFunction(parentNode.getName());
            symbol.setEndAddress(parentNode.getHighPc());
            if (null != nextLineInfo && parentNode.contain(nextLineInfo.getAddress())) {
                symbol.setEndAddress(nextLineInfo.getAddress());
            }
            int backupIndex = 0;
            boolean hasSetInline = false;
            while (++childIndex < subroutineTable.size()) {
                Subroutine childNode = subroutineTable.elementAt(childIndex);
                if (!parentNode.contain(childNode)) {
                    nextParentIndex = childIndex;
                    break;
                }
                if (childNode.contain(lineInfo.getAddress())) {
                    backupIndex = childIndex;
                    symbol.setFunction(childNode.getName());
                    if (null == nextLineInfo || childNode.contain(nextLineInfo.getAddress())) continue;
                    symbol.setEndAddress(childNode.getHighPc());
                    continue;
                }
                hasSetInline = false;
            }
            table.add(symbol);
            Symbol restSymbol = symbol;
            if (0 != backupIndex && null != nextLineInfo) {
                Subroutine node;
                while (++backupIndex < subroutineTable.size() && (node = subroutineTable.elementAt(backupIndex)).getLowPc() == restSymbol.getEndAddress() && node.below(nextLineInfo.getAddress())) {
                    restSymbol = new Symbol();
                    this.setSymbolValue(restSymbol, lineInfo);
                    this.setSymbolValue(restSymbol, node);
                    table.add(restSymbol);
                }
            }
            if (null == nextLineInfo || parentNode.contain(nextLineInfo.getAddress())) continue;
            if (parentIndex == nextParentIndex) {
                ++parentIndex;
                continue;
            }
            parentIndex = nextParentIndex;
        }
        Log.info("mergeToSymbolTable cost %d", System.currentTimeMillis() - start);
        return table;
    }

    private Vector<Symbol> mergeToSymbolTable2(Vector<DebugLineParser.DebugLineEntry> lineInfoTable, TreeMap<Long, List<Subroutine>> highPcSubroutineTable, TreeMap<Long, List<Subroutine>> highPcSymtabSubroutineTable) {
        Vector<Symbol> table = new Vector<Symbol>();
        if (lineInfoTable == null) {
            return table;
        }
        TreeMap<Long, List<Subroutine>> lowPcSubroutineTable = this.getLowPcKeyTreeMap(highPcSubroutineTable);
        TreeMap<Long, List<Subroutine>> lowPcSymtabSubroutineTable = this.getLowPcKeyTreeMap(highPcSymtabSubroutineTable);
        for (int i = 0; i < lineInfoTable.size(); ++i) {
            Subroutine subroutine;
            boolean bl;
            DebugLineParser.DebugLineEntry debugLineEntry = lineInfoTable.elementAt(i);
            if (debugLineEntry.getAddress() == 6796056L) {
                bl = true;
            }
            if (debugLineEntry.getAddress() == 6824602L) {
                bl = true;
            }
            if ((subroutine = this.findCeilingSubroutine(highPcSubroutineTable, debugLineEntry.getAddress())) == null && (subroutine = this.findFloorSubroutine(lowPcSubroutineTable, debugLineEntry.getAddress())) == null && (subroutine = this.findCeilingSubroutine(highPcSymtabSubroutineTable, debugLineEntry.getAddress())) == null) {
                subroutine = this.findFloorSubroutine(lowPcSymtabSubroutineTable, debugLineEntry.getAddress());
            }
            if (subroutine == null) continue;
            Symbol symbol = new Symbol(debugLineEntry, subroutine);
            if (symbol.getAddress() == 2457304L) {
                boolean bl2 = true;
            }
            if (i + 1 < lineInfoTable.size()) {
                DebugLineParser.DebugLineEntry nextLineEntry = lineInfoTable.elementAt(i + 1);
                if (StringUtils.equalsIgnoreCase(debugLineEntry.getPathName(), nextLineEntry.getPathName()) && nextLineEntry.getAddress() < subroutine.getHighPc()) {
                    symbol.setEndAddress(nextLineEntry.getAddress());
                }
            }
            table.add(symbol);
        }
        return table;
    }

    private TreeMap<Long, List<Subroutine>> getLowPcKeyTreeMap(TreeMap<Long, List<Subroutine>> treeMap) {
        TreeMap<Long, List<Subroutine>> lowPcTreeMap = new TreeMap<Long, List<Subroutine>>();
        for (Map.Entry<Long, List<Subroutine>> entry : treeMap.entrySet()) {
            for (Subroutine subroutine : entry.getValue()) {
                List list = lowPcTreeMap.getOrDefault(subroutine.getLowPc(), new ArrayList());
                list.add(subroutine);
                lowPcTreeMap.put(subroutine.getLowPc(), list);
            }
        }
        return lowPcTreeMap;
    }

    private Subroutine findCeilingSubroutine(TreeMap<Long, List<Subroutine>> subroutineTable, long address) {
        Map.Entry<Long, List<Subroutine>> entry = subroutineTable.ceilingEntry(address);
        return this.containAddress(entry, address);
    }

    private Subroutine findFloorSubroutine(TreeMap<Long, List<Subroutine>> subroutineTable, long address) {
        Map.Entry<Long, List<Subroutine>> entry = subroutineTable.floorEntry(address);
        return this.containAddress(entry, address);
    }

    private Subroutine containAddress(Map.Entry<Long, List<Subroutine>> entry, long address) {
        if (entry == null) {
            return null;
        }
        List<Subroutine> subroutines = entry.getValue();
        for (int i = subroutines.size() - 1; i >= 0; --i) {
            Subroutine subroutine = subroutines.get(i);
            if (!subroutine.contain(address)) continue;
            return subroutine;
        }
        return null;
    }

    private void compare(Vector<Symbol> symbols1, Vector<Symbol> symbols2) {
        if (symbols1.size() != symbols2.size()) {
            Log.error("symbols1.size() != symbols2.size()", new Object[0]);
        }
        symbols1.sort((a, b) -> {
            if (a.getAddress() == b.getAddress()) {
                return (int)(a.getEndAddress() - b.getEndAddress());
            }
            return (int)(a.getAddress() - b.getAddress());
        });
        symbols2.sort((a, b) -> {
            if (a.getAddress() == b.getAddress()) {
                return (int)(a.getEndAddress() - b.getEndAddress());
            }
            return (int)(a.getAddress() - b.getAddress());
        });
        for (int i = 0; i < symbols1.size(); ++i) {
            Symbol symbol1 = symbols1.elementAt(i);
            Symbol symbol2 = symbols2.elementAt(i);
            if (symbol1.getAddress() != symbol2.getAddress()) {
                Log.error("symbols1.size() != symbols2.size()", new Object[0]);
            }
            if (symbol1.getEndAddress() != symbol2.getEndAddress()) {
                Log.error("symbols1.size() != symbols2.size()", new Object[0]);
            }
            if (!Objects.equals(symbol1.getFunction(), symbol2.getFunction())) {
                Log.error("symbols1.size() != symbols2.size()", new Object[0]);
            }
            if (!Objects.equals(symbol1.getSourceFile(), symbol2.getSourceFile())) {
                Log.error("symbols1.size() != symbols2.size()", new Object[0]);
            }
            if (symbol1.getSourceLine() != symbol2.getSourceLine()) {
                Log.error("symbols1.size() != symbols2.size()", new Object[0]);
            }
            if (symbol1.getSourceColumn() == symbol2.getSourceColumn()) continue;
            Log.error("symbols1.size() != symbols2.size()", new Object[0]);
        }
    }

    private Vector<Symbol> filterSymbolTable(HashSet<Long> addressTable, Vector<Symbol> symbolTable) {
        Vector<Symbol> restSymbolTable = new Vector<Symbol>();
        for (Symbol symbol : symbolTable) {
            if (addressTable.contains(symbol.getAddress())) continue;
            addressTable.add(symbol.getAddress());
            restSymbolTable.add(symbol);
        }
        return restSymbolTable;
    }

    public SymbolTable getSymbolTable(Vector<Subroutine> subroutines) {
        if (!this.checkInit()) {
            return null;
        }
        TreeMap<Long, List<Subroutine>> symtabSubroutines = new TreeMap<Long, List<Subroutine>>();
        for (Subroutine subroutine : subroutines) {
            List list = symtabSubroutines.getOrDefault(subroutine.getHighPc(), new ArrayList());
            list.add(subroutine);
            symtabSubroutines.put(subroutine.getHighPc(), list);
        }
        LinkedHashMap<Long, DebugInfoPasrser.DebugInfoEntry> debugInfoTable = this.debugInfo.getDebugInfoTable(this.debugAbbrev, 0L);
        if (null == debugInfoTable) {
            Log.error("Failed to get debug info table", new Object[0]);
            return null;
        }
        if (!this.setFileFormat(this.debugInfo.getAddrBits())) {
            Log.error("Failed to set file format", new Object[0]);
            return null;
        }
        if (!this.setDebugLineAddrBits()) {
            Log.error("Failed to set address bits of debug line", new Object[0]);
            return null;
        }
        if (!this.setDebugRangesAddrBits()) {
            Log.error("Failed to set address bits of debug rages", new Object[0]);
            return null;
        }
        SymbolTable symbolTable = new SymbolTable();
        HashSet<Long> addressTable = new HashSet<Long>();
        while (null != debugInfoTable) {
            if (!debugInfoTable.isEmpty()) {
                long offset = this.getDebugLineOffset(debugInfoTable);
                Vector<DebugLineParser.DebugLineEntry> lineInfoTable = this.getLineInfoTable(offset);
                TreeMap<Long, List<Subroutine>> subroutineTable = this.filterOutSubroutines(debugInfoTable);
                Vector<Symbol> symbols = this.mergeToSymbolTable2(lineInfoTable, subroutineTable, symtabSubroutines);
                symbols = this.filterSymbolTable(addressTable, symbols);
                symbolTable.add(symbols);
            }
            debugInfoTable = this.debugInfo.next(this.debugAbbrev);
        }
        if (!symbolTable.sort()) {
            Log.error("Failed to sort symbol table", new Object[0]);
            return null;
        }
        return symbolTable;
    }

    public void close() {
        if (null != this.debugStr) {
            this.debugStr.close();
        }
        if (null != this.debugLine) {
            this.debugLine.close();
        }
        if (null != this.debugInfo) {
            this.debugInfo.close();
        }
        this.debugStr = null;
        this.debugAbbrev = null;
        this.debugLine = null;
        this.debugInfo = null;
        this.debugRanges = null;
    }
}

