/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class DebugStrOffsetsParser {
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    BinaryFileReader binaryFileReader;
    TreeMap<Long, List<Long>> strOffsetsBaseToOffsets = null;

    public DebugStrOffsetsParser(String fileName, long sectionOffset, long sectionSize) {
        this.fileName = fileName;
        this.sectionOffset = sectionOffset;
        this.sectionSize = sectionSize;
        this.parseStrOffsetsBaseToOffsets();
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return this.binaryFileReader.skip(this.sectionOffset);
    }

    private void parseStrOffsetsBaseToOffsets() {
        if (this.strOffsetsBaseToOffsets != null) {
            return;
        }
        if (!this.openFile()) {
            return;
        }
        this.strOffsetsBaseToOffsets = new TreeMap();
        long fileOffset = this.sectionOffset;
        while (fileOffset < this.sectionOffset + this.sectionSize) {
            DebugStrOffsetsHeader header = new DebugStrOffsetsHeader(this.fileName, fileOffset);
            if (!header.parse()) {
                return;
            }
            fileOffset = header.getNextHeaderFileOffset();
            this.strOffsetsBaseToOffsets.put(header.getStrOffsetsBaseFileOffset() - this.sectionOffset, header.getAddresses());
        }
        this.close();
    }

    public long getStrOffset(long addrBase, int index) {
        try {
            List<Long> addresses = this.strOffsetsBaseToOffsets.get(addrBase);
            return addresses.get(index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public BinaryFileReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public TreeMap<Long, List<Long>> getStrOffsetsBaseToOffsets() {
        return this.strOffsetsBaseToOffsets;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSectionOffset(long sectionOffset) {
        this.sectionOffset = sectionOffset;
    }

    public void setSectionSize(long sectionSize) {
        this.sectionSize = sectionSize;
    }

    public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }

    public void setStrOffsetsBaseToOffsets(TreeMap<Long, List<Long>> strOffsetsBaseToOffsets) {
        this.strOffsetsBaseToOffsets = strOffsetsBaseToOffsets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebugStrOffsetsParser)) {
            return false;
        }
        DebugStrOffsetsParser other = (DebugStrOffsetsParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSectionOffset() != other.getSectionOffset()) {
            return false;
        }
        if (this.getSectionSize() != other.getSectionSize()) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        BinaryFileReader this$binaryFileReader = this.getBinaryFileReader();
        BinaryFileReader other$binaryFileReader = other.getBinaryFileReader();
        if (this$binaryFileReader == null ? other$binaryFileReader != null : !this$binaryFileReader.equals(other$binaryFileReader)) {
            return false;
        }
        TreeMap<Long, List<Long>> this$strOffsetsBaseToOffsets = this.getStrOffsetsBaseToOffsets();
        TreeMap<Long, List<Long>> other$strOffsetsBaseToOffsets = other.getStrOffsetsBaseToOffsets();
        return !(this$strOffsetsBaseToOffsets == null ? other$strOffsetsBaseToOffsets != null : !((Object)this$strOffsetsBaseToOffsets).equals(other$strOffsetsBaseToOffsets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DebugStrOffsetsParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sectionOffset = this.getSectionOffset();
        result = result * 59 + (int)($sectionOffset >>> 32 ^ $sectionOffset);
        long $sectionSize = this.getSectionSize();
        result = result * 59 + (int)($sectionSize >>> 32 ^ $sectionSize);
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        BinaryFileReader $binaryFileReader = this.getBinaryFileReader();
        result = result * 59 + ($binaryFileReader == null ? 43 : $binaryFileReader.hashCode());
        TreeMap<Long, List<Long>> $strOffsetsBaseToOffsets = this.getStrOffsetsBaseToOffsets();
        result = result * 59 + ($strOffsetsBaseToOffsets == null ? 43 : ((Object)$strOffsetsBaseToOffsets).hashCode());
        return result;
    }

    public String toString() {
        return "DebugStrOffsetsParser(fileName=" + this.getFileName() + ", sectionOffset=" + this.getSectionOffset() + ", sectionSize=" + this.getSectionSize() + ", binaryFileReader=" + this.getBinaryFileReader() + ", strOffsetsBaseToOffsets=" + this.getStrOffsetsBaseToOffsets() + ")";
    }

    public static class DebugStrOffsetsHeader {
        String fileName;
        long fileOffset;
        BinaryFileReader binaryFileReader;
        private long dwarfFormat = 0L;
        private long unitLength = 0L;
        private long version = 0L;
        private long padding = 0L;
        long strOffsetsBaseFileOffset;
        long nextHeaderFileOffset;
        List<Long> addresses = new ArrayList<Long>();

        public DebugStrOffsetsHeader(String fileName, long fileOffset) {
            this.fileName = fileName;
            this.fileOffset = fileOffset;
        }

        private boolean checkInit() {
            return this.fileOffset >= 0L;
        }

        private void close() {
            if (null == this.binaryFileReader) {
                return;
            }
            if (!this.binaryFileReader.close()) {
                return;
            }
            this.binaryFileReader = null;
        }

        private boolean openFile() {
            if (!this.checkInit()) {
                return false;
            }
            if (null != this.binaryFileReader) {
                this.close();
            }
            try {
                this.binaryFileReader = new BinaryFileReader(this.fileName);
            }
            catch (Exception e) {
                Log.error(e);
                return false;
            }
            return this.binaryFileReader.skip(this.fileOffset);
        }

        public boolean parse() {
            if (!this.openFile()) {
                return false;
            }
            if (!this.parseUnitLength()) {
                return false;
            }
            this.nextHeaderFileOffset = this.binaryFileReader.getOffset() + this.unitLength;
            if (!this.parseVersion()) {
                return false;
            }
            if (!this.parsePadding()) {
                return false;
            }
            this.strOffsetsBaseFileOffset = this.binaryFileReader.getOffset();
            if (!this.parseAddresses()) {
                return false;
            }
            this.close();
            return true;
        }

        private boolean parseUnitLength() {
            try {
                this.unitLength = this.binaryFileReader.readUInt();
                if (-1L == this.unitLength) {
                    this.dwarfFormat = 64L;
                    this.unitLength = this.binaryFileReader.readULong();
                } else {
                    this.dwarfFormat = 32L;
                }
                this.binaryFileReader.resetReadBytes();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseVersion() {
            try {
                this.version = this.binaryFileReader.readUShort();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parsePadding() {
            try {
                this.padding = this.binaryFileReader.readUShort();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseAddresses() {
            while (this.binaryFileReader.getOffset() < this.nextHeaderFileOffset) {
                Long address = this.parseAddress();
                if (address == null) {
                    return false;
                }
                this.addresses.add(address);
            }
            return true;
        }

        private Long parseAddress() {
            try {
                if (32L == this.dwarfFormat) {
                    return this.binaryFileReader.readUInt();
                }
                if (64L == this.dwarfFormat) {
                    return this.binaryFileReader.readULong();
                }
                Log.warn("parseAddress invalid: dwarfFormat == %d", this.dwarfFormat);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getFileOffset() {
            return this.fileOffset;
        }

        public BinaryFileReader getBinaryFileReader() {
            return this.binaryFileReader;
        }

        public long getDwarfFormat() {
            return this.dwarfFormat;
        }

        public long getUnitLength() {
            return this.unitLength;
        }

        public long getVersion() {
            return this.version;
        }

        public long getPadding() {
            return this.padding;
        }

        public long getStrOffsetsBaseFileOffset() {
            return this.strOffsetsBaseFileOffset;
        }

        public long getNextHeaderFileOffset() {
            return this.nextHeaderFileOffset;
        }

        public List<Long> getAddresses() {
            return this.addresses;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setFileOffset(long fileOffset) {
            this.fileOffset = fileOffset;
        }

        public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
            this.binaryFileReader = binaryFileReader;
        }

        public void setDwarfFormat(long dwarfFormat) {
            this.dwarfFormat = dwarfFormat;
        }

        public void setUnitLength(long unitLength) {
            this.unitLength = unitLength;
        }

        public void setVersion(long version) {
            this.version = version;
        }

        public void setPadding(long padding) {
            this.padding = padding;
        }

        public void setStrOffsetsBaseFileOffset(long strOffsetsBaseFileOffset) {
            this.strOffsetsBaseFileOffset = strOffsetsBaseFileOffset;
        }

        public void setNextHeaderFileOffset(long nextHeaderFileOffset) {
            this.nextHeaderFileOffset = nextHeaderFileOffset;
        }

        public void setAddresses(List<Long> addresses) {
            this.addresses = addresses;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebugStrOffsetsHeader)) {
                return false;
            }
            DebugStrOffsetsHeader other = (DebugStrOffsetsHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFileOffset() != other.getFileOffset()) {
                return false;
            }
            if (this.getDwarfFormat() != other.getDwarfFormat()) {
                return false;
            }
            if (this.getUnitLength() != other.getUnitLength()) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            if (this.getPadding() != other.getPadding()) {
                return false;
            }
            if (this.getStrOffsetsBaseFileOffset() != other.getStrOffsetsBaseFileOffset()) {
                return false;
            }
            if (this.getNextHeaderFileOffset() != other.getNextHeaderFileOffset()) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            BinaryFileReader this$binaryFileReader = this.getBinaryFileReader();
            BinaryFileReader other$binaryFileReader = other.getBinaryFileReader();
            if (this$binaryFileReader == null ? other$binaryFileReader != null : !this$binaryFileReader.equals(other$binaryFileReader)) {
                return false;
            }
            List<Long> this$addresses = this.getAddresses();
            List<Long> other$addresses = other.getAddresses();
            return !(this$addresses == null ? other$addresses != null : !((Object)this$addresses).equals(other$addresses));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DebugStrOffsetsHeader;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $fileOffset = this.getFileOffset();
            result = result * 59 + (int)($fileOffset >>> 32 ^ $fileOffset);
            long $dwarfFormat = this.getDwarfFormat();
            result = result * 59 + (int)($dwarfFormat >>> 32 ^ $dwarfFormat);
            long $unitLength = this.getUnitLength();
            result = result * 59 + (int)($unitLength >>> 32 ^ $unitLength);
            long $version = this.getVersion();
            result = result * 59 + (int)($version >>> 32 ^ $version);
            long $padding = this.getPadding();
            result = result * 59 + (int)($padding >>> 32 ^ $padding);
            long $strOffsetsBaseFileOffset = this.getStrOffsetsBaseFileOffset();
            result = result * 59 + (int)($strOffsetsBaseFileOffset >>> 32 ^ $strOffsetsBaseFileOffset);
            long $nextHeaderFileOffset = this.getNextHeaderFileOffset();
            result = result * 59 + (int)($nextHeaderFileOffset >>> 32 ^ $nextHeaderFileOffset);
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            BinaryFileReader $binaryFileReader = this.getBinaryFileReader();
            result = result * 59 + ($binaryFileReader == null ? 43 : $binaryFileReader.hashCode());
            List<Long> $addresses = this.getAddresses();
            result = result * 59 + ($addresses == null ? 43 : ((Object)$addresses).hashCode());
            return result;
        }

        public String toString() {
            return "DebugStrOffsetsParser.DebugStrOffsetsHeader(fileName=" + this.getFileName() + ", fileOffset=" + this.getFileOffset() + ", binaryFileReader=" + this.getBinaryFileReader() + ", dwarfFormat=" + this.getDwarfFormat() + ", unitLength=" + this.getUnitLength() + ", version=" + this.getVersion() + ", padding=" + this.getPadding() + ", strOffsetsBaseFileOffset=" + this.getStrOffsetsBaseFileOffset() + ", nextHeaderFileOffset=" + this.getNextHeaderFileOffset() + ", addresses=" + this.getAddresses() + ")";
        }
    }
}

