/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.DebugAddrParser;
import com.uqm.crashsight.symtabtool.dwarf.Leb128Parser;
import java.io.IOException;
import java.util.TreeMap;
import java.util.Vector;

public class DebugRnglistParser {
    public final int DW_RLE_end_of_list = 0;
    public final int DW_RLE_base_addressx = 1;
    public final int DW_RLE_startx_endx = 2;
    public final int DW_RLE_startx_length = 3;
    public final int DW_RLE_offset_pair = 4;
    public final int DW_RLE_base_address = 5;
    public final int DW_RLE_start_end = 6;
    public final int DW_RLE_start_length = 7;
    DebugAddrParser debugAddrParser = null;
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    private BinaryFileReader binaryFileReader = null;
    TreeMap<Long, DebugRnglistHeader> rnglistsBaseToHeader = null;

    public DebugRnglistParser(String fileName, long sectionOffset, long sectionSize) {
        this.fileName = fileName;
        this.sectionOffset = sectionOffset;
        this.sectionSize = sectionSize;
        this.parseRnglistsBaseToHeader();
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return this.binaryFileReader.skip(this.sectionOffset);
    }

    private void parseRnglistsBaseToHeader() {
        if (this.rnglistsBaseToHeader != null) {
            return;
        }
        if (!this.openFile()) {
            return;
        }
        this.rnglistsBaseToHeader = new TreeMap();
        long fileOffset = this.sectionOffset;
        while (fileOffset < this.sectionOffset + this.sectionSize) {
            DebugRnglistHeader header = new DebugRnglistHeader(this.fileName, fileOffset);
            if (!header.parse()) {
                return;
            }
            fileOffset = header.getNextHeaderFileOffset();
            this.rnglistsBaseToHeader.put(header.getBeginOfOffsetArrayInFile() - this.sectionOffset, header);
        }
        this.close();
    }

    public Vector<DebugRangeEntry> getRangesTable(long offsetLocation, long addrBase, long rnglistsBase) {
        if (offsetLocation < 0L) {
            return null;
        }
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(rnglistsBase)) {
            this.close();
            return null;
        }
        DebugRnglistHeader header = this.rnglistsBaseToHeader.get(rnglistsBase);
        if (header == null) {
            return null;
        }
        Vector<DebugRangeEntry> rangesTable = this.parseRangesTable(header, offsetLocation, addrBase);
        this.close();
        return rangesTable;
    }

    private Vector<DebugRangeEntry> parseRangesTable(DebugRnglistHeader header, long offsetLocation, long addrBase) {
        Vector<Long> offsets = header.getOffsets();
        long offset = offsets.get((int)offsetLocation);
        this.binaryFileReader.skip(offset);
        Vector<DebugRangeEntry> rangesTable = new Vector<DebugRangeEntry>();
        long lowPc = 0L;
        long highPc = 0L;
        long baseAddress = 0L;
        try {
            while (true) {
                int kind = (int)this.binaryFileReader.readUByte();
                switch (kind) {
                    case 0: {
                        return rangesTable;
                    }
                    case 1: {
                        long baseAddressInDebugAddr = Leb128Parser.parseULeb128(this.binaryFileReader);
                        baseAddress = this.debugAddrParser.getAddress(addrBase, (int)baseAddressInDebugAddr);
                        break;
                    }
                    case 2: {
                        long startIndexInDebugAddr = Leb128Parser.parseULeb128(this.binaryFileReader);
                        lowPc = this.debugAddrParser.getAddress(addrBase, (int)startIndexInDebugAddr);
                        long endIndexInDebugAddr = Leb128Parser.parseULeb128(this.binaryFileReader);
                        highPc = this.debugAddrParser.getAddress(addrBase, (int)endIndexInDebugAddr);
                        break;
                    }
                    case 3: {
                        long startIndexInDebugAddr = Leb128Parser.parseULeb128(this.binaryFileReader);
                        lowPc = this.debugAddrParser.getAddress(addrBase, (int)startIndexInDebugAddr);
                        long length = Leb128Parser.parseULeb128(this.binaryFileReader);
                        highPc = lowPc + length;
                        break;
                    }
                    case 4: {
                        long startOffset = Leb128Parser.parseULeb128(this.binaryFileReader);
                        long endOffset = Leb128Parser.parseULeb128(this.binaryFileReader);
                        lowPc = startOffset + baseAddress;
                        highPc = endOffset + baseAddress;
                        break;
                    }
                    case 5: {
                        baseAddress = this.readFormAddr(header.addrBits);
                        break;
                    }
                    case 6: {
                        lowPc = this.readFormAddr(header.addrBits);
                        highPc = this.readFormAddr(header.addrBits);
                        break;
                    }
                    case 7: {
                        lowPc = this.readFormAddr(header.addrBits);
                        long length = Leb128Parser.parseULeb128(this.binaryFileReader);
                        highPc = lowPc + length;
                        break;
                    }
                }
                DebugRangeEntry entry = new DebugRangeEntry();
                entry.setLowPc(lowPc);
                entry.setHighPc(highPc);
                rangesTable.add(entry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private long readFormAddr(long addrBits) {
        try {
            if (32L == addrBits) {
                return this.binaryFileReader.readUInt();
            }
            if (64L == addrBits) {
                return this.binaryFileReader.readULong();
            }
            Log.warn("readFormAddr invalid: addrBits == %d", addrBits);
        }
        catch (Exception e) {
            Log.warn("readFormAddr err: %s", e.toString());
            return 0L;
        }
        return 0L;
    }

    public int getDW_RLE_end_of_list() {
        return this.DW_RLE_end_of_list;
    }

    public int getDW_RLE_base_addressx() {
        return this.DW_RLE_base_addressx;
    }

    public int getDW_RLE_startx_endx() {
        return this.DW_RLE_startx_endx;
    }

    public int getDW_RLE_startx_length() {
        return this.DW_RLE_startx_length;
    }

    public int getDW_RLE_offset_pair() {
        return this.DW_RLE_offset_pair;
    }

    public int getDW_RLE_base_address() {
        return this.DW_RLE_base_address;
    }

    public int getDW_RLE_start_end() {
        return this.DW_RLE_start_end;
    }

    public int getDW_RLE_start_length() {
        return this.DW_RLE_start_length;
    }

    public DebugAddrParser getDebugAddrParser() {
        return this.debugAddrParser;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public BinaryFileReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public TreeMap<Long, DebugRnglistHeader> getRnglistsBaseToHeader() {
        return this.rnglistsBaseToHeader;
    }

    public void setDebugAddrParser(DebugAddrParser debugAddrParser) {
        this.debugAddrParser = debugAddrParser;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSectionOffset(long sectionOffset) {
        this.sectionOffset = sectionOffset;
    }

    public void setSectionSize(long sectionSize) {
        this.sectionSize = sectionSize;
    }

    public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }

    public void setRnglistsBaseToHeader(TreeMap<Long, DebugRnglistHeader> rnglistsBaseToHeader) {
        this.rnglistsBaseToHeader = rnglistsBaseToHeader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebugRnglistParser)) {
            return false;
        }
        DebugRnglistParser other = (DebugRnglistParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDW_RLE_end_of_list() != other.getDW_RLE_end_of_list()) {
            return false;
        }
        if (this.getDW_RLE_base_addressx() != other.getDW_RLE_base_addressx()) {
            return false;
        }
        if (this.getDW_RLE_startx_endx() != other.getDW_RLE_startx_endx()) {
            return false;
        }
        if (this.getDW_RLE_startx_length() != other.getDW_RLE_startx_length()) {
            return false;
        }
        if (this.getDW_RLE_offset_pair() != other.getDW_RLE_offset_pair()) {
            return false;
        }
        if (this.getDW_RLE_base_address() != other.getDW_RLE_base_address()) {
            return false;
        }
        if (this.getDW_RLE_start_end() != other.getDW_RLE_start_end()) {
            return false;
        }
        if (this.getDW_RLE_start_length() != other.getDW_RLE_start_length()) {
            return false;
        }
        if (this.getSectionOffset() != other.getSectionOffset()) {
            return false;
        }
        if (this.getSectionSize() != other.getSectionSize()) {
            return false;
        }
        DebugAddrParser this$debugAddrParser = this.getDebugAddrParser();
        DebugAddrParser other$debugAddrParser = other.getDebugAddrParser();
        if (this$debugAddrParser == null ? other$debugAddrParser != null : !((Object)this$debugAddrParser).equals(other$debugAddrParser)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        BinaryFileReader this$binaryFileReader = this.getBinaryFileReader();
        BinaryFileReader other$binaryFileReader = other.getBinaryFileReader();
        if (this$binaryFileReader == null ? other$binaryFileReader != null : !this$binaryFileReader.equals(other$binaryFileReader)) {
            return false;
        }
        TreeMap<Long, DebugRnglistHeader> this$rnglistsBaseToHeader = this.getRnglistsBaseToHeader();
        TreeMap<Long, DebugRnglistHeader> other$rnglistsBaseToHeader = other.getRnglistsBaseToHeader();
        return !(this$rnglistsBaseToHeader == null ? other$rnglistsBaseToHeader != null : !((Object)this$rnglistsBaseToHeader).equals(other$rnglistsBaseToHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DebugRnglistParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDW_RLE_end_of_list();
        result = result * 59 + this.getDW_RLE_base_addressx();
        result = result * 59 + this.getDW_RLE_startx_endx();
        result = result * 59 + this.getDW_RLE_startx_length();
        result = result * 59 + this.getDW_RLE_offset_pair();
        result = result * 59 + this.getDW_RLE_base_address();
        result = result * 59 + this.getDW_RLE_start_end();
        result = result * 59 + this.getDW_RLE_start_length();
        long $sectionOffset = this.getSectionOffset();
        result = result * 59 + (int)($sectionOffset >>> 32 ^ $sectionOffset);
        long $sectionSize = this.getSectionSize();
        result = result * 59 + (int)($sectionSize >>> 32 ^ $sectionSize);
        DebugAddrParser $debugAddrParser = this.getDebugAddrParser();
        result = result * 59 + ($debugAddrParser == null ? 43 : ((Object)$debugAddrParser).hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        BinaryFileReader $binaryFileReader = this.getBinaryFileReader();
        result = result * 59 + ($binaryFileReader == null ? 43 : $binaryFileReader.hashCode());
        TreeMap<Long, DebugRnglistHeader> $rnglistsBaseToHeader = this.getRnglistsBaseToHeader();
        result = result * 59 + ($rnglistsBaseToHeader == null ? 43 : ((Object)$rnglistsBaseToHeader).hashCode());
        return result;
    }

    public String toString() {
        return "DebugRnglistParser(DW_RLE_end_of_list=" + this.getDW_RLE_end_of_list() + ", DW_RLE_base_addressx=" + this.getDW_RLE_base_addressx() + ", DW_RLE_startx_endx=" + this.getDW_RLE_startx_endx() + ", DW_RLE_startx_length=" + this.getDW_RLE_startx_length() + ", DW_RLE_offset_pair=" + this.getDW_RLE_offset_pair() + ", DW_RLE_base_address=" + this.getDW_RLE_base_address() + ", DW_RLE_start_end=" + this.getDW_RLE_start_end() + ", DW_RLE_start_length=" + this.getDW_RLE_start_length() + ", debugAddrParser=" + this.getDebugAddrParser() + ", fileName=" + this.getFileName() + ", sectionOffset=" + this.getSectionOffset() + ", sectionSize=" + this.getSectionSize() + ", binaryFileReader=" + this.getBinaryFileReader() + ", rnglistsBaseToHeader=" + this.getRnglistsBaseToHeader() + ")";
    }

    public static class DebugRangeEntry {
        private long lowPc = -1L;
        private long highPc = -1L;

        public long getLowPc() {
            return this.lowPc;
        }

        public void setLowPc(long lowPc) {
            this.lowPc = lowPc;
        }

        public long getHighPc() {
            return this.highPc;
        }

        public void setHighPc(long highPc) {
            this.highPc = highPc;
        }
    }

    public static class DebugRnglistHeader {
        String fileName;
        long fileOffset;
        BinaryFileReader binaryFileReader;
        long nextHeaderFileOffset;
        long beginOfOffsetArrayInFile;
        private long addrBits = 0L;
        private long dwarfFormat = 0L;
        private long unitLength = 0L;
        private long version = 0L;
        private long addressSize = 0L;
        private long segmentSelectorSize;
        private long offsetEntryCount;
        Vector<Long> offsets;

        public DebugRnglistHeader(String fileName, long fileOffset) {
            this.fileName = fileName;
            this.fileOffset = fileOffset;
        }

        private boolean checkInit() {
            return this.fileOffset >= 0L;
        }

        private void close() {
            if (null == this.binaryFileReader) {
                return;
            }
            if (!this.binaryFileReader.close()) {
                return;
            }
            this.binaryFileReader = null;
        }

        private boolean openFile() {
            if (!this.checkInit()) {
                return false;
            }
            if (null != this.binaryFileReader) {
                this.close();
            }
            try {
                this.binaryFileReader = new BinaryFileReader(this.fileName);
            }
            catch (Exception e) {
                Log.error(e);
                return false;
            }
            return this.binaryFileReader.skip(this.fileOffset);
        }

        public boolean parse() {
            if (!this.openFile()) {
                return false;
            }
            if (!this.parseUnitLength()) {
                return false;
            }
            this.nextHeaderFileOffset = this.binaryFileReader.getOffset() + this.unitLength;
            if (!this.parseVersion()) {
                return false;
            }
            if (!this.parseAddressSize()) {
                return false;
            }
            if (!this.parseSegmentSelectorSize()) {
                return false;
            }
            if (!this.parseOffsetEntryCount()) {
                return false;
            }
            this.beginOfOffsetArrayInFile = this.binaryFileReader.getOffset();
            if (!this.parseOffsetLocations()) {
                return false;
            }
            if (!this.setAddrBits()) {
                return false;
            }
            this.close();
            return true;
        }

        public boolean setAddrBits() {
            switch ((int)this.addressSize) {
                case 4: 
                case 32: {
                    this.addrBits = 32L;
                    break;
                }
                case 8: 
                case 64: {
                    this.addrBits = 64L;
                    break;
                }
                default: {
                    Log.warn("Address bits error: %d", this.addrBits);
                    return false;
                }
            }
            return true;
        }

        private boolean parseUnitLength() {
            try {
                this.unitLength = this.binaryFileReader.readUInt();
                if (-1L == this.unitLength) {
                    this.dwarfFormat = 64L;
                    this.unitLength = this.binaryFileReader.readULong();
                } else {
                    this.dwarfFormat = 32L;
                }
                this.binaryFileReader.resetReadBytes();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseVersion() {
            try {
                this.version = this.binaryFileReader.readUShort();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseAddressSize() {
            try {
                this.addressSize = this.binaryFileReader.readUByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            if (4L != this.addressSize && 8L != this.addressSize) {
                Log.error("Address size of debug rnglists header error: %d", this.addressSize);
                return false;
            }
            return true;
        }

        private boolean parseSegmentSelectorSize() {
            try {
                this.segmentSelectorSize = this.binaryFileReader.readUByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseOffsetEntryCount() {
            try {
                this.offsetEntryCount = this.binaryFileReader.readUInt();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseOffsetLocations() {
            this.offsets = new Vector();
            try {
                int i = 0;
                while ((long)i < this.offsetEntryCount) {
                    long offset = this.parseOffset();
                    this.offsets.add(offset);
                    ++i;
                }
            }
            catch (Exception e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private long parseOffset() {
            try {
                if (32L == this.dwarfFormat) {
                    return this.binaryFileReader.readUInt();
                }
                if (64L == this.dwarfFormat) {
                    return this.binaryFileReader.readULong();
                }
            }
            catch (IOException e) {
                Log.error(e);
            }
            return 0L;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getFileOffset() {
            return this.fileOffset;
        }

        public BinaryFileReader getBinaryFileReader() {
            return this.binaryFileReader;
        }

        public long getNextHeaderFileOffset() {
            return this.nextHeaderFileOffset;
        }

        public long getBeginOfOffsetArrayInFile() {
            return this.beginOfOffsetArrayInFile;
        }

        public long getAddrBits() {
            return this.addrBits;
        }

        public long getDwarfFormat() {
            return this.dwarfFormat;
        }

        public long getUnitLength() {
            return this.unitLength;
        }

        public long getVersion() {
            return this.version;
        }

        public long getAddressSize() {
            return this.addressSize;
        }

        public long getSegmentSelectorSize() {
            return this.segmentSelectorSize;
        }

        public long getOffsetEntryCount() {
            return this.offsetEntryCount;
        }

        public Vector<Long> getOffsets() {
            return this.offsets;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setFileOffset(long fileOffset) {
            this.fileOffset = fileOffset;
        }

        public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
            this.binaryFileReader = binaryFileReader;
        }

        public void setNextHeaderFileOffset(long nextHeaderFileOffset) {
            this.nextHeaderFileOffset = nextHeaderFileOffset;
        }

        public void setBeginOfOffsetArrayInFile(long beginOfOffsetArrayInFile) {
            this.beginOfOffsetArrayInFile = beginOfOffsetArrayInFile;
        }

        public void setAddrBits(long addrBits) {
            this.addrBits = addrBits;
        }

        public void setDwarfFormat(long dwarfFormat) {
            this.dwarfFormat = dwarfFormat;
        }

        public void setUnitLength(long unitLength) {
            this.unitLength = unitLength;
        }

        public void setVersion(long version) {
            this.version = version;
        }

        public void setAddressSize(long addressSize) {
            this.addressSize = addressSize;
        }

        public void setSegmentSelectorSize(long segmentSelectorSize) {
            this.segmentSelectorSize = segmentSelectorSize;
        }

        public void setOffsetEntryCount(long offsetEntryCount) {
            this.offsetEntryCount = offsetEntryCount;
        }

        public void setOffsets(Vector<Long> offsets) {
            this.offsets = offsets;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebugRnglistHeader)) {
                return false;
            }
            DebugRnglistHeader other = (DebugRnglistHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFileOffset() != other.getFileOffset()) {
                return false;
            }
            if (this.getNextHeaderFileOffset() != other.getNextHeaderFileOffset()) {
                return false;
            }
            if (this.getBeginOfOffsetArrayInFile() != other.getBeginOfOffsetArrayInFile()) {
                return false;
            }
            if (this.getAddrBits() != other.getAddrBits()) {
                return false;
            }
            if (this.getDwarfFormat() != other.getDwarfFormat()) {
                return false;
            }
            if (this.getUnitLength() != other.getUnitLength()) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            if (this.getAddressSize() != other.getAddressSize()) {
                return false;
            }
            if (this.getSegmentSelectorSize() != other.getSegmentSelectorSize()) {
                return false;
            }
            if (this.getOffsetEntryCount() != other.getOffsetEntryCount()) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            BinaryFileReader this$binaryFileReader = this.getBinaryFileReader();
            BinaryFileReader other$binaryFileReader = other.getBinaryFileReader();
            if (this$binaryFileReader == null ? other$binaryFileReader != null : !this$binaryFileReader.equals(other$binaryFileReader)) {
                return false;
            }
            Vector<Long> this$offsets = this.getOffsets();
            Vector<Long> other$offsets = other.getOffsets();
            return !(this$offsets == null ? other$offsets != null : !((Object)this$offsets).equals(other$offsets));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DebugRnglistHeader;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $fileOffset = this.getFileOffset();
            result = result * 59 + (int)($fileOffset >>> 32 ^ $fileOffset);
            long $nextHeaderFileOffset = this.getNextHeaderFileOffset();
            result = result * 59 + (int)($nextHeaderFileOffset >>> 32 ^ $nextHeaderFileOffset);
            long $beginOfOffsetArrayInFile = this.getBeginOfOffsetArrayInFile();
            result = result * 59 + (int)($beginOfOffsetArrayInFile >>> 32 ^ $beginOfOffsetArrayInFile);
            long $addrBits = this.getAddrBits();
            result = result * 59 + (int)($addrBits >>> 32 ^ $addrBits);
            long $dwarfFormat = this.getDwarfFormat();
            result = result * 59 + (int)($dwarfFormat >>> 32 ^ $dwarfFormat);
            long $unitLength = this.getUnitLength();
            result = result * 59 + (int)($unitLength >>> 32 ^ $unitLength);
            long $version = this.getVersion();
            result = result * 59 + (int)($version >>> 32 ^ $version);
            long $addressSize = this.getAddressSize();
            result = result * 59 + (int)($addressSize >>> 32 ^ $addressSize);
            long $segmentSelectorSize = this.getSegmentSelectorSize();
            result = result * 59 + (int)($segmentSelectorSize >>> 32 ^ $segmentSelectorSize);
            long $offsetEntryCount = this.getOffsetEntryCount();
            result = result * 59 + (int)($offsetEntryCount >>> 32 ^ $offsetEntryCount);
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            BinaryFileReader $binaryFileReader = this.getBinaryFileReader();
            result = result * 59 + ($binaryFileReader == null ? 43 : $binaryFileReader.hashCode());
            Vector<Long> $offsets = this.getOffsets();
            result = result * 59 + ($offsets == null ? 43 : ((Object)$offsets).hashCode());
            return result;
        }

        public String toString() {
            return "DebugRnglistParser.DebugRnglistHeader(fileName=" + this.getFileName() + ", fileOffset=" + this.getFileOffset() + ", binaryFileReader=" + this.getBinaryFileReader() + ", nextHeaderFileOffset=" + this.getNextHeaderFileOffset() + ", beginOfOffsetArrayInFile=" + this.getBeginOfOffsetArrayInFile() + ", addrBits=" + this.getAddrBits() + ", dwarfFormat=" + this.getDwarfFormat() + ", unitLength=" + this.getUnitLength() + ", version=" + this.getVersion() + ", addressSize=" + this.getAddressSize() + ", segmentSelectorSize=" + this.getSegmentSelectorSize() + ", offsetEntryCount=" + this.getOffsetEntryCount() + ", offsets=" + this.getOffsets() + ")";
        }
    }
}

