/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.Vector;

public class DebugRangesParser {
    private static final long RESERVED_LOW_PC = 0L;
    private static final long RESERVED_HIGH_PC = 0L;
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    private BinaryFileReader binaryFileReader = null;
    private long addrBits = 0L;

    public void setSectionSize(long sectionSize) {
        this.sectionSize = sectionSize;
    }

    public void setSectionOffset(long sectionOffset) {
        this.sectionOffset = sectionOffset;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setAddrBits(long addrBits) {
        switch ((int)addrBits) {
            case 4: 
            case 32: {
                this.addrBits = 32L;
                break;
            }
            case 8: 
            case 64: {
                this.addrBits = 64L;
                break;
            }
            default: {
                this.addrBits = 32L;
                Log.warn("Address bits error, default to 32", new Object[0]);
            }
        }
    }

    public DebugRangesParser(String fileName, long sectionOffset, long sectionSize) {
        this.setFileName(fileName);
        this.setSectionOffset(sectionOffset);
        this.setSectionSize(sectionSize);
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return false != this.binaryFileReader.skip(this.sectionOffset);
    }

    public Vector<DebugRangeEntry> getRangesTable(long offset) {
        if (offset < 0L || offset >= this.sectionSize) {
            return null;
        }
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(offset)) {
            this.close();
            return null;
        }
        Vector<DebugRangeEntry> rangesTable = this.parseRangesTable();
        this.close();
        return rangesTable;
    }

    private Vector<DebugRangeEntry> parseRangesTable() {
        Vector<DebugRangeEntry> rangesTable = new Vector<DebugRangeEntry>();
        long lowPc = 0L;
        long highPc = 0L;
        try {
            while (true) {
                if (32L == this.addrBits) {
                    lowPc = this.binaryFileReader.readUInt();
                    highPc = this.binaryFileReader.readUInt();
                } else if (64L == this.addrBits) {
                    lowPc = this.binaryFileReader.readULong();
                    highPc = this.binaryFileReader.readULong();
                } else {
                    Log.warn("Address bits error", new Object[0]);
                    return null;
                }
                if (0L != lowPc || 0L != highPc) {
                    DebugRangeEntry entry = new DebugRangeEntry();
                    entry.setLowPc(lowPc);
                    entry.setHighPc(highPc);
                    rangesTable.add(entry);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        return rangesTable;
    }

    public static class DebugRangeEntry {
        private long lowPc = -1L;
        private long highPc = -1L;

        public void setLowPc(long lowPc) {
            this.lowPc = lowPc;
        }

        public void setHighPc(long highPc) {
            this.highPc = highPc;
        }

        public long getLowPc() {
            return this.lowPc;
        }

        public long getHighPc() {
            return this.highPc;
        }
    }
}

