/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import java.nio.MappedByteBuffer;

public class DebugLineStrParser {
    MappedByteBuffer mapper = null;
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;

    public DebugLineStrParser(String fileName, long sectionOffset, long sectionSize) {
        this.setFileName(fileName);
        this.setSectionOffset(sectionOffset);
        this.setSectionSize(sectionSize);
    }

    public void setSectionSize(long sectionSize) {
        this.sectionSize = sectionSize;
    }

    public void setSectionOffset(long sectionOffset) {
        this.sectionOffset = sectionOffset;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    public void close() {
        if (null == this.mapper) {
            return;
        }
        this.mapper = null;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null == this.mapper) {
            this.mapper = FileHelper.mapSymtabIndexFile(this.fileName, this.sectionOffset, this.sectionSize);
            if (null == this.mapper) {
                return false;
            }
        }
        return true;
    }

    private String pickString(long offset) {
        byte c;
        StringBuffer stringBuffer = new StringBuffer();
        long i = 0L;
        while (0 != (c = this.mapper.get((int)(offset + i)))) {
            stringBuffer.append((char)c);
            ++i;
        }
        return stringBuffer.toString();
    }

    public String getString(long offset) {
        if (offset < 0L || offset >= this.sectionSize) {
            return null;
        }
        if (null == this.mapper && !this.openFile()) {
            return null;
        }
        String ret = this.pickString(offset);
        return ret;
    }
}

