/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.StrUtils;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.dwarf.DebugLineStrParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugStrParser;
import com.uqm.crashsight.symtabtool.dwarf.Leb128Parser;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Vector;

public class DebugLineParser {
    private static final byte SPECIAL_OPCODE = 0;
    private static final byte STANDARD_OPCODE = 1;
    private static final byte EXTENDED_OPCODE = 2;
    private static final byte DW_LNS_copy = 1;
    private static final byte DW_LNS_advance_pc = 2;
    private static final byte DW_LNS_advance_line = 3;
    private static final byte DW_LNS_set_file = 4;
    private static final byte DW_LNS_set_column = 5;
    private static final byte DW_LNS_negate_stmt = 6;
    private static final byte DW_LNS_set_basic_block = 7;
    private static final byte DW_LNS_const_add_pc = 8;
    private static final byte DW_LNS_fixed_advance_pc = 9;
    private static final byte DW_LNS_set_prologue_end = 10;
    private static final byte DW_LNS_set_epilogue_begin = 11;
    private static final byte DW_LNS_set_isa = 12;
    private static final byte DW_LNE_end_sequence = 1;
    private static final byte DW_LNE_set_address = 2;
    private static final byte DW_LNE_define_file = 3;
    private static final byte DW_LNE_set_discriminator = 4;
    private static final byte DW_LNE_lo_user = -128;
    private static final byte DW_LNE_hi_user = -1;
    private long registerAddress = 0L;
    private long registerFileIndex = 1L;
    private long registerLine = 1L;
    private long registerColumn = 0L;
    private long registerOpIndex = 0L;
    private boolean registerIsStmt = false;
    private boolean registerBasicBlock = false;
    private boolean registerEndEquence = false;
    private boolean registerPrologueEnd = false;
    private boolean registerEpilogueBegin = false;
    private long registerIsa = 0L;
    private long registerDiscriminator = 0L;
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    private long addrBits = 0L;
    private BinaryFileReader binaryFileReader = null;
    private LineNumberProgramHeader header = null;
    private Vector<DebugLineEntry> lineInfoTable = null;

    public DebugLineParser(String fileName, long sectionOffset, long sectionSize) {
        this.setFileName(fileName);
        this.setSectionOffset(sectionOffset);
        this.setSectionSize(sectionSize);
    }

    private void initRegisters() {
        this.registerAddress = 0L;
        this.registerFileIndex = 1L;
        this.registerLine = 1L;
        this.registerColumn = 0L;
        this.registerOpIndex = 0L;
        this.registerIsStmt = false;
        this.registerBasicBlock = false;
        this.registerEndEquence = false;
        this.registerPrologueEnd = false;
        this.registerEpilogueBegin = false;
        this.registerIsa = 0L;
        this.registerDiscriminator = 0L;
    }

    public LineNumberProgramHeader getHeader() {
        return this.header;
    }

    public String getSourceFile(int index) {
        if (this.header == null) {
            return null;
        }
        return this.header.getPathName(index);
    }

    public long getAddrBits() {
        return this.addrBits;
    }

    public void setAddrBits(long addrBits) {
        switch ((int)addrBits) {
            case 4: 
            case 32: {
                this.addrBits = 32L;
                break;
            }
            case 8: 
            case 64: {
                this.addrBits = 64L;
                break;
            }
            default: {
                this.addrBits = 32L;
                Log.warn("Address bits error, default to 32", new Object[0]);
            }
        }
    }

    public void setSectionSize(long sectionSize) {
        this.sectionSize = sectionSize;
    }

    public void setSectionOffset(long sectionOffset) {
        this.sectionOffset = sectionOffset;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private void clearEnv() {
        this.header = null;
        this.lineInfoTable = null;
        this.binaryFileReader.resetReadBytes();
        this.initRegisters();
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return false != this.binaryFileReader.skip(this.sectionOffset);
    }

    private boolean checkAddrBits() {
        return 0L != this.addrBits;
    }

    public Vector<DebugLineEntry> getLineInfoTable(long offset, DebugStrParser debugStrParser, DebugLineStrParser debugLineStrParser) {
        if (!this.checkAddrBits()) {
            return null;
        }
        if (offset < 0L || offset >= this.sectionSize) {
            return null;
        }
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(offset)) {
            this.close();
            return null;
        }
        return this.next(debugStrParser, debugLineStrParser);
    }

    public Vector<DebugLineEntry> next(DebugStrParser debugStrParser, DebugLineStrParser debugLineStrParser) {
        if (null == this.binaryFileReader && !this.openFile()) {
            return null;
        }
        if (this.getSectionRestLength() <= 0L) {
            return null;
        }
        this.clearEnv();
        this.lineInfoTable = new Vector();
        this.header = new LineNumberProgramHeader(this.binaryFileReader, debugStrParser, debugLineStrParser);
        if (!this.header.parse()) {
            return null;
        }
        if (!this.parseOpcode()) {
            return null;
        }
        return this.lineInfoTable;
    }

    public long getSectionRestLength() {
        long offset = this.binaryFileReader.getOffset() - this.sectionOffset;
        return this.sectionSize - offset;
    }

    private long getUnitRestLength() {
        return this.header.getUnitLength() - this.binaryFileReader.getReadBytesNum();
    }

    private boolean parseOpcode() {
        boolean ret = false;
        while (this.getUnitRestLength() > 0L) {
            byte code = 0;
            try {
                code = this.binaryFileReader.readByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            byte type = this.getOpcodeType(code);
            switch (type) {
                case 0: {
                    ret = this.parseSpecialOpcode(code);
                    break;
                }
                case 1: {
                    ret = this.parseStandardOpcode(code);
                    break;
                }
                case 2: {
                    ret = this.parseExtendedOpcode();
                    break;
                }
            }
            if (ret) continue;
            Log.error("Faile to parse opcode of debug line", new Object[0]);
            return false;
        }
        return true;
    }

    private byte getOpcodeType(byte b) {
        if (0 == b) {
            return 2;
        }
        if (b > 0 && (long)b < this.header.getOpcodeBase()) {
            return 1;
        }
        return 0;
    }

    private boolean parseSpecialOpcode(byte opcode) {
        long so = Utils.unsignedToLong(opcode);
        if (so < this.header.getOpcodeBase()) {
            Log.error("Faile to special opcode of debug line", new Object[0]);
            return false;
        }
        long adjust = so - this.header.getOpcodeBase();
        long lineInc = (long)this.header.getLineBase() + adjust % this.header.getLineRange();
        long addressInc = adjust / this.header.getLineRange() * this.header.getMinInstructionLength();
        this.registerLine += lineInc;
        this.registerAddress += addressInc;
        this.registerBasicBlock = false;
        this.addToLineInfoTable();
        return true;
    }

    private boolean parseStandardOpcode(byte opcode) {
        long so = Utils.unsignedToLong(opcode);
        if (so >= this.header.getOpcodeBase()) {
            Log.error("Faile to standard opcode of debug line", new Object[0]);
            return false;
        }
        long addressInc = 0L;
        long lineInc = 0L;
        try {
            switch (opcode) {
                case 1: {
                    this.addToLineInfoTable();
                    this.registerBasicBlock = false;
                    break;
                }
                case 2: {
                    addressInc = Leb128Parser.parseULeb128(this.binaryFileReader) * this.header.getMinInstructionLength();
                    this.registerAddress += addressInc;
                    break;
                }
                case 3: {
                    lineInc = Leb128Parser.parseSLeb128(this.binaryFileReader);
                    this.registerLine += lineInc;
                    break;
                }
                case 4: {
                    this.registerFileIndex = Leb128Parser.parseULeb128(this.binaryFileReader);
                    break;
                }
                case 5: {
                    this.registerColumn = Leb128Parser.parseULeb128(this.binaryFileReader);
                    break;
                }
                case 6: {
                    this.registerIsStmt = !this.registerIsStmt;
                    break;
                }
                case 7: {
                    this.registerBasicBlock = true;
                    break;
                }
                case 8: {
                    long adjust = 255L - this.header.getOpcodeBase();
                    addressInc = adjust / this.header.getLineRange() * this.header.getMinInstructionLength();
                    this.registerAddress += addressInc;
                    break;
                }
                case 9: {
                    this.registerAddress += this.binaryFileReader.readUShort();
                    break;
                }
                case 10: {
                    this.registerPrologueEnd = true;
                    break;
                }
                case 11: {
                    this.registerEpilogueBegin = true;
                    break;
                }
                case 12: {
                    this.registerIsa = Leb128Parser.parseULeb128(this.binaryFileReader);
                    break;
                }
                default: {
                    Log.error("Faile to standard opcode of debug line for code: %x", opcode);
                    return false;
                }
            }
        }
        catch (IOException e) {
            Log.error(e);
            return false;
        }
        return true;
    }

    private boolean parseExtendedOpcode() {
        try {
            Leb128Parser.parseULeb128(this.binaryFileReader);
            long opcode = this.binaryFileReader.readUByte();
            switch ((int)opcode) {
                case 1: {
                    this.initRegisters();
                    break;
                }
                case 2: {
                    if (32L == this.addrBits) {
                        this.registerAddress = this.binaryFileReader.readUInt();
                        break;
                    }
                    if (64L == this.addrBits) {
                        this.registerAddress = this.binaryFileReader.readULong();
                        break;
                    }
                    Log.warn("Address bits error", new Object[0]);
                    return false;
                }
                case 3: {
                    FileNameEntry fne = new FileNameEntry(this.binaryFileReader);
                    this.header.getFileNameTable().add(fne);
                    break;
                }
                case 4: {
                    this.registerDiscriminator = Leb128Parser.parseULeb128(this.binaryFileReader);
                    break;
                }
                default: {
                    Log.error("Fail to extended opcode of debug line for code: %x", opcode);
                    return false;
                }
            }
        }
        catch (IOException e) {
            Log.error(e);
            return false;
        }
        return true;
    }

    private void addToLineInfoTable() {
        DebugLineEntry entry = new DebugLineEntry();
        String pathName = this.header.getPathName(this.registerFileIndex);
        if (!this.lineInfoTable.isEmpty()) {
            DebugLineEntry preEntry = this.lineInfoTable.lastElement();
            if (preEntry.getPathName().equals(pathName)) {
                if (preEntry.getAddress() == this.registerAddress) {
                    if (preEntry.getLineNumber() != this.registerLine) {
                        if (0L == preEntry.getLineNumber()) {
                            preEntry.setLineNumber(this.registerLine);
                        } else {
                            preEntry.setEndLineNumber(this.registerLine);
                        }
                    }
                    return;
                }
            } else if (preEntry.getAddress() == this.registerAddress) {
                preEntry.setAddress(this.registerAddress);
                preEntry.setLineNumber(this.registerLine);
                preEntry.setColumnNumber(this.registerColumn);
                preEntry.setPathName(pathName);
                return;
            }
        }
        entry.setAddress(this.registerAddress);
        entry.setLineNumber(this.registerLine);
        entry.setColumnNumber(this.registerColumn);
        entry.setPathName(pathName);
        this.lineInfoTable.add(entry);
    }

    private static class FileNameEntry {
        private StringBuffer fileName = new StringBuffer();
        private long indexOfDirTable = 0L;
        private long lastModTime = 0L;
        private long fileLength = 0L;
        private String md5;

        public FileNameEntry(StringBuffer sb) {
            this.fileName = sb;
        }

        public FileNameEntry(BinaryFileReader binaryFileReader) {
            this.parse(binaryFileReader);
        }

        private boolean parse(BinaryFileReader binaryFileReader) {
            boolean ret = false;
            try {
                char c = '\u0000';
                while ('\u0000' != (c = (char)binaryFileReader.readByte())) {
                    this.fileName.append(c);
                }
                this.indexOfDirTable = Leb128Parser.parseULeb128(binaryFileReader);
                this.lastModTime = Leb128Parser.parseULeb128(binaryFileReader);
                this.fileLength = Leb128Parser.parseULeb128(binaryFileReader);
                ret = true;
            }
            catch (Exception e) {
                Log.error(e);
            }
            return ret;
        }

        public String getFileName() {
            return this.fileName.toString();
        }

        public long getIndexOfDirTable() {
            return this.indexOfDirTable;
        }
    }

    public static class LineNumberProgramHeader {
        private static final byte DW_FORM_STRING = 8;
        private static final byte DW_FORM_line_strp = 31;
        private static final byte DW_FORM_strp = 14;
        private static final byte DW_FORM_strp_sup = 29;
        private static final byte DW_FORM_data1 = 11;
        private static final byte DW_FORM_data2 = 5;
        private static final byte DW_FORM_data4 = 6;
        private static final byte DW_FORM_data8 = 7;
        private static final byte DW_FORM_data16 = 30;
        private static final byte DW_FORM_udata = 15;
        private static final byte DW_FORM_block = 9;
        private static final String PATH_SEPARATOR = "/";
        private static final int IDENTIFICATION_OF_64BIT = -1;
        private BinaryFileReader binaryFileReader = null;
        DebugStrParser debugStrParser;
        DebugLineStrParser debugLineStrParser;
        private long dwarfFormat = 0L;
        private long unitLength = 0L;
        private long version = 2L;
        private long addressSize;
        private long segmentSelectorSize;
        private long headerLength = 0L;
        private long minInstructionLength = 0L;
        private long maxInstructionLength = 0L;
        private long defaultIsStmt = 0L;
        private byte lineBase = 0;
        private long lineRange = 0L;
        private long opcodeBase = 0L;
        private byte[] standardOpcodeLengths = null;
        public static final byte DW_LNCT_path = 1;
        public static final byte DW_LNCT_directory_index = 2;
        public static final byte DW_LNCT_timestamp = 3;
        public static final byte DW_LNCT_size = 4;
        public static final byte DW_LNCT_MD5 = 5;
        public static final int DW_LNS_lo_user = 8192;
        public static final int DW_LNS_hi_user = 16383;
        private long dwarf5DirectoryEntryFormatCount = 0L;
        private Dwarf5DirectoryEntryFormat[] dwarf5DirectoryEntryFormats = null;
        private long dwarf5DirectoriesCount;
        private Dwarf5Directory[] dwarf5Directories = null;
        private long dwarf5FileNameEntryFormatCount = 0L;
        private Dwarf5FileNameEntryFormat[] dwarf5FileNameEntryFormats = null;
        private long dwarf5FilesCount = 0L;
        private Dwarf5File[] dwarf5Files = null;
        private Vector<StringBuffer> dirTable = new Vector();
        private Vector<FileNameEntry> fileNameTable = new Vector();

        public LineNumberProgramHeader(BinaryFileReader binaryFileReader, DebugStrParser debugStrParser, DebugLineStrParser debugLineStrParser) {
            this.setBinaryFileReader(binaryFileReader);
            this.debugStrParser = debugStrParser;
            this.debugLineStrParser = debugLineStrParser;
        }

        private boolean parseUnitLength() {
            try {
                this.unitLength = this.binaryFileReader.readUInt();
                if (-1L == this.unitLength) {
                    this.dwarfFormat = 64L;
                    this.unitLength = this.binaryFileReader.readULong();
                }
                this.dwarfFormat = 32L;
                this.binaryFileReader.resetReadBytes();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseVersion() {
            try {
                this.version = this.binaryFileReader.readUShort();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseAddressSize() {
            try {
                this.addressSize = this.binaryFileReader.readUByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseSegmentSelectorSize() {
            try {
                this.segmentSelectorSize = this.binaryFileReader.readUByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseHeaderLength() {
            try {
                if (32L == this.dwarfFormat) {
                    this.headerLength = this.binaryFileReader.readUInt();
                } else if (64L == this.dwarfFormat) {
                    this.headerLength = this.binaryFileReader.readULong();
                }
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseMinInstructionLength() {
            try {
                this.minInstructionLength = this.binaryFileReader.readUByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseMaxInstructionLength() {
            try {
                this.maxInstructionLength = this.binaryFileReader.readUByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseDefaultIsStmt() {
            try {
                this.defaultIsStmt = this.binaryFileReader.readUByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseLineBase() {
            try {
                this.lineBase = this.binaryFileReader.readByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseLineRange() {
            try {
                this.lineRange = this.binaryFileReader.readUByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseOpcodeBase() {
            try {
                this.opcodeBase = this.binaryFileReader.readUByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            if (this.opcodeBase <= 0L) {
                Log.error("Failed to parse opcode base: opcodeBase is less than 1", new Object[0]);
                return false;
            }
            return true;
        }

        private boolean parseStandardOpcodeLengths() {
            this.standardOpcodeLengths = new byte[(int)(this.opcodeBase - 1L)];
            return this.binaryFileReader.readByteArray(this.standardOpcodeLengths);
        }

        private boolean parseDirectoryEntryFormatCount() {
            try {
                this.dwarf5DirectoryEntryFormatCount = this.binaryFileReader.readUByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseDirectoryEntryFormat() {
            try {
                this.dwarf5DirectoryEntryFormats = new Dwarf5DirectoryEntryFormat[(int)this.dwarf5DirectoryEntryFormatCount];
                int i = 0;
                while ((long)i < this.dwarf5DirectoryEntryFormatCount) {
                    Dwarf5DirectoryEntryFormat format = new Dwarf5DirectoryEntryFormat();
                    format.typeCode = Leb128Parser.parseULeb128(this.binaryFileReader);
                    format.formCode = Leb128Parser.parseULeb128(this.binaryFileReader);
                    this.dwarf5DirectoryEntryFormats[i] = format;
                    ++i;
                }
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseDirectoriesCount() {
            try {
                this.dwarf5DirectoriesCount = Leb128Parser.parseULeb128(this.binaryFileReader);
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseDirectories() {
            try {
                this.dwarf5Directories = new Dwarf5Directory[(int)this.dwarf5DirectoriesCount];
                int i = 0;
                while ((long)i < this.dwarf5DirectoriesCount) {
                    int j = 0;
                    while ((long)j < this.dwarf5DirectoryEntryFormatCount) {
                        Dwarf5DirectoryEntryFormat format = this.dwarf5DirectoryEntryFormats[j];
                        if (format.typeCode == 1L) {
                            String directoryName = this.parseDwarf5LNCT((int)format.formCode);
                            Dwarf5Directory dwarf5Directory = new Dwarf5Directory();
                            dwarf5Directory.directoryName = directoryName;
                            this.dwarf5Directories[i] = dwarf5Directory;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseFileNameEntryFormatCount() {
            try {
                this.dwarf5FileNameEntryFormatCount = Leb128Parser.parseULeb128(this.binaryFileReader);
            }
            catch (Exception e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseFileNameEntryFormat() {
            try {
                this.dwarf5FileNameEntryFormats = new Dwarf5FileNameEntryFormat[(int)this.dwarf5FileNameEntryFormatCount];
                int i = 0;
                while ((long)i < this.dwarf5FileNameEntryFormatCount) {
                    Dwarf5FileNameEntryFormat format = new Dwarf5FileNameEntryFormat();
                    format.typeCode = Leb128Parser.parseULeb128(this.binaryFileReader);
                    format.formCode = Leb128Parser.parseULeb128(this.binaryFileReader);
                    this.dwarf5FileNameEntryFormats[i] = format;
                    ++i;
                }
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseFileNamesCount() {
            try {
                this.dwarf5FilesCount = Leb128Parser.parseULeb128(this.binaryFileReader);
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseFileNames() {
            try {
                this.dwarf5Files = new Dwarf5File[(int)this.dwarf5FilesCount];
                int i = 0;
                while ((long)i < this.dwarf5FilesCount) {
                    Dwarf5File dwarf5File = new Dwarf5File();
                    int j = 0;
                    while ((long)j < this.dwarf5FileNameEntryFormatCount) {
                        Dwarf5FileNameEntryFormat format = this.dwarf5FileNameEntryFormats[j];
                        String name = this.parseDwarf5LNCT((int)format.formCode);
                        switch ((int)format.typeCode) {
                            case 1: {
                                dwarf5File.name = name;
                                break;
                            }
                            case 2: {
                                dwarf5File.directoryIndex = Integer.parseInt(name, 16);
                                break;
                            }
                            case 3: {
                                dwarf5File.timestamp = Long.parseLong(name, 16);
                                break;
                            }
                            case 4: {
                                dwarf5File.size = Long.parseLong(name, 16);
                                break;
                            }
                            case 5: {
                                dwarf5File.md5 = name;
                            }
                        }
                        ++j;
                    }
                    this.dwarf5Files[i] = dwarf5File;
                    ++i;
                }
            }
            catch (Exception e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean fillDirTable() {
            this.dirTable.add(new StringBuffer("."));
            char c = '\u0000';
            try {
                while ('\u0000' != (c = (char)this.binaryFileReader.readByte())) {
                    StringBuffer str = new StringBuffer();
                    while ('\u0000' != c) {
                        str.append(c);
                        c = (char)this.binaryFileReader.readByte();
                    }
                    this.dirTable.add(str);
                }
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean fillFileNameTable() {
            this.fileNameTable.add(new FileNameEntry(new StringBuffer(".")));
            char c = '\u0000';
            try {
                while ('\u0000' != (c = (char)this.binaryFileReader.readByte())) {
                    FileNameEntry fne = new FileNameEntry(this.binaryFileReader);
                    fne.fileName.insert(0, c);
                    this.fileNameTable.add(fne);
                }
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private void setBinaryFileReader(BinaryFileReader binaryFileReader) {
            this.binaryFileReader = binaryFileReader;
        }

        public boolean parse() {
            if (null == this.binaryFileReader) {
                return false;
            }
            if (!this.parseUnitLength()) {
                return false;
            }
            if (!this.parseVersion()) {
                return false;
            }
            if (5L == this.version) {
                if (!this.parseAddressSize()) {
                    return false;
                }
                if (!this.parseSegmentSelectorSize()) {
                    return false;
                }
            }
            if (!this.parseHeaderLength()) {
                return false;
            }
            if (!this.parseMinInstructionLength()) {
                return false;
            }
            if (!(4L != this.version && 5L != this.version || this.parseMaxInstructionLength())) {
                return false;
            }
            if (!this.parseDefaultIsStmt()) {
                return false;
            }
            if (!this.parseLineBase()) {
                return false;
            }
            if (!this.parseLineRange()) {
                return false;
            }
            if (!this.parseOpcodeBase()) {
                return false;
            }
            if (!this.parseStandardOpcodeLengths()) {
                return false;
            }
            if (5L == this.version) {
                if (!this.parseDirectoryEntryFormatCount()) {
                    return false;
                }
                if (!this.parseDirectoryEntryFormat()) {
                    return false;
                }
                if (!this.parseDirectoriesCount()) {
                    return false;
                }
                if (!this.parseDirectories()) {
                    return false;
                }
                if (!this.parseFileNameEntryFormatCount()) {
                    return false;
                }
                if (!this.parseFileNameEntryFormat()) {
                    return false;
                }
                if (!this.parseFileNamesCount()) {
                    return false;
                }
                if (!this.parseFileNames()) {
                    return false;
                }
                for (Dwarf5Directory dwarf5Directory : this.dwarf5Directories) {
                    String directoryName = dwarf5Directory.directoryName;
                    this.dirTable.add(new StringBuffer(directoryName));
                }
                for (Dwarf5File dwarf5File : this.dwarf5Files) {
                    FileNameEntry entry = new FileNameEntry(new StringBuffer(dwarf5File.name));
                    entry.lastModTime = dwarf5File.timestamp;
                    entry.fileLength = dwarf5File.size;
                    entry.md5 = dwarf5File.md5;
                    this.fileNameTable.add(entry);
                }
            } else {
                if (!this.fillDirTable()) {
                    return false;
                }
                if (!this.fillFileNameTable()) {
                    return false;
                }
            }
            return true;
        }

        public long getUnitLength() {
            return this.unitLength;
        }

        public long getVersion() {
            return this.version;
        }

        public long getHeaderLength() {
            return this.headerLength;
        }

        public long getMinInstructionLength() {
            return this.minInstructionLength;
        }

        public byte getLineBase() {
            return this.lineBase;
        }

        public long getLineRange() {
            return this.lineRange;
        }

        public long getOpcodeBase() {
            return this.opcodeBase;
        }

        private String getDirName(long index) {
            return this.dirTable.get((int)index).toString();
        }

        public Vector<FileNameEntry> getFileNameTable() {
            return this.fileNameTable;
        }

        public String getFileName(long index) {
            FileNameEntry entry = this.fileNameTable.get((int)index);
            return entry.getFileName();
        }

        public String getPathName(long index) {
            if ((long)this.fileNameTable.size() <= index) {
                Log.error("debugline index " + index + "is missing!", new Object[0]);
                return "";
            }
            FileNameEntry entry = this.fileNameTable.get((int)index);
            String fileName = entry.getFileName();
            String dirName = this.getDirName(entry.getIndexOfDirTable());
            if (2L == this.version && Paths.get(fileName, new String[0]).isAbsolute()) {
                return fileName;
            }
            return dirName + PATH_SEPARATOR + fileName;
        }

        private String parseDwarf5LNCT(int form) {
            String name = "";
            String value = "";
            switch (form) {
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 15: 
                case 30: {
                    return this.parseConstant(form);
                }
                case 8: {
                    return this.parseString();
                }
                case 14: {
                    value = this.parseStringPointer();
                    return this.debugStrParser.getString(Long.parseLong(value, 16));
                }
                case 31: {
                    value = this.parseStringPointer();
                    return this.debugLineStrParser.getString(Long.parseLong(value, 16));
                }
                case 29: {
                    value = this.parseStringPointer();
                    return "";
                }
                case 9: {
                    return this.parseBlock(form);
                }
            }
            return name;
        }

        private String parseString() {
            StringBuilder stringBuffer = new StringBuilder();
            byte b = 0;
            try {
                while (0 != (b = this.binaryFileReader.readByte())) {
                    stringBuffer.append((char)b);
                }
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
            return stringBuffer.toString();
        }

        private String parseStringPointer() {
            long offset = 0L;
            try {
                if (32L == this.dwarfFormat) {
                    offset = this.binaryFileReader.readUInt();
                } else if (64L == this.dwarfFormat) {
                    offset = this.binaryFileReader.readULong();
                }
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
            return Long.toHexString(offset);
        }

        private String parseConstant(long valueForm) {
            long constant = 0L;
            try {
                switch ((int)valueForm) {
                    case 11: {
                        constant = this.binaryFileReader.readUByte();
                        break;
                    }
                    case 5: {
                        constant = this.binaryFileReader.readUShort();
                        break;
                    }
                    case 6: {
                        constant = this.binaryFileReader.readUInt();
                        break;
                    }
                    case 7: {
                        constant = this.binaryFileReader.readULong();
                        break;
                    }
                    case 30: {
                        byte[] md5 = new byte[16];
                        this.binaryFileReader.readByteArray(md5);
                        return StrUtils.bytesToHex(md5);
                    }
                    case 15: {
                        constant = Leb128Parser.parseULeb128(this.binaryFileReader);
                        break;
                    }
                }
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
            return Long.toHexString(constant);
        }

        private String parseBlock(long valueForm) {
            long blockLength = 0L;
            try {
                switch ((int)valueForm) {
                    case 9: {
                        blockLength = Leb128Parser.parseULeb128(this.binaryFileReader);
                        break;
                    }
                }
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
            byte[] array = new byte[(int)blockLength];
            if (!this.binaryFileReader.readByteArray(array)) {
                return null;
            }
            return Base64.getEncoder().encodeToString(array);
        }
    }

    public static class Dwarf5File {
        String name;
        int directoryIndex;
        long timestamp;
        long size;
        String md5;
    }

    public static class Dwarf5FileNameEntryFormat {
        long typeCode;
        long formCode;
    }

    public static class Dwarf5Directory {
        String directoryName;
    }

    public static class Dwarf5DirectoryEntryFormat {
        long typeCode;
        long formCode;
    }

    public static class DebugLineEntry {
        private long address = -1L;
        private long lineNumber = -1L;
        private long endLineNumber = -1L;
        private long columnNumber = -1L;
        private String pathName = null;

        public void copy(DebugLineEntry entry) {
            this.setAddress(entry.address);
            this.setLineNumber(entry.lineNumber);
            this.setLineNumber(entry.endLineNumber);
            this.setPathName(entry.pathName);
            this.setColumnNumber(entry.columnNumber);
        }

        public long getAddress() {
            return this.address;
        }

        public void setAddress(long address) {
            this.address = address;
        }

        public long getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(long lineNumber) {
            this.lineNumber = lineNumber;
        }

        public long getEndLineNumber() {
            return this.endLineNumber;
        }

        public void setEndLineNumber(long endLineNumber) {
            if (0L == endLineNumber) {
                return;
            }
            if (endLineNumber < this.lineNumber) {
                this.endLineNumber = this.lineNumber;
                this.lineNumber = endLineNumber;
            } else {
                this.endLineNumber = endLineNumber;
            }
        }

        public long getColumnNumber() {
            return this.columnNumber;
        }

        public void setColumnNumber(long columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getPathName() {
            return this.pathName;
        }

        public void setPathName(String pathName) {
            this.pathName = pathName;
        }

        public String toString() {
            return "DebugLineEntry{address=" + Long.toHexString(this.address) + ", endLineNumber=" + this.endLineNumber + ", pathName='" + this.pathName + '\'' + ", lineNumber=" + this.lineNumber + ", columnNumber=" + this.columnNumber + '}';
        }
    }
}

