/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.DebugAbbrevParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugStrOffsetsParser;
import com.uqm.crashsight.symtabtool.dwarf.Leb128Parser;
import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class DebugInfoPasrser {
    public static final long DW_TAG_COMPILE_UNIT = 17L;
    public static final long DW_TAG_SUBPROGRAM = 46L;
    public static final long DW_TAG_INLINED_SUBROUTINE = 29L;
    public static final long DW_TAG_PARTIAL_UNIT = 46L;
    public static final long DW_TAG_formal_parameter = 5L;
    public static final long DW_TAG_variable = 52L;
    public static final long DW_AT_MIPS_LINKAGE_NAME = 8199L;
    public static final long DW_AT_LINKAGE_NAME = 110L;
    public static final long DW_AT_NAME = 3L;
    public static final long DW_AT_STMT_LIST = 16L;
    public static final long DW_AT_LOW_PC = 17L;
    public static final long DW_AT_HIGH_PC = 18L;
    public static final long DW_AT_ABSTRACT_ORIGIN = 49L;
    public static final long DW_AT_SPECIFICATION = 71L;
    public static final long DW_AT_ENTRY_PC = 82L;
    public static final long DW_AT_RANGES = 85L;
    public static final long DW_AT_CALL_FILE = 88L;
    public static final long DW_AT_CALL_LINE = 89L;
    public static final long DW_AT_SLIBLING = 1L;
    public static final long DW_AT_location = 2L;
    public static final long DW_AT_byte_size = 11L;
    public static final long DW_AT_type = 73L;
    public static final long DW_AT_str_offsets_base = 114L;
    public static final long DW_AT_addr_base = 115L;
    public static final long DW_AT_rnglists_base = 116L;
    public static final String DW_AT_location_prefix = "block_";
    public static final int DW_OP_addr = 3;
    public static final int DW_OP_deref = 6;
    public static final int DW_OP_const1u = 8;
    public static final int DW_OP_const1s = 9;
    public static final int DW_OP_const2u = 10;
    public static final int DW_OP_const2s = 11;
    public static final int DW_OP_const4u = 12;
    public static final int DW_OP_const4s = 13;
    public static final int DW_OP_const8u = 14;
    public static final int DW_OP_const8s = 15;
    public static final int DW_OP_constu = 16;
    public static final int DW_OP_consts = 17;
    public static final int DW_OP_dup = 18;
    public static final int DW_OP_drop = 19;
    public static final int DW_OP_over = 20;
    public static final int DW_OP_pick = 21;
    public static final int DW_OP_swap = 22;
    public static final int DW_OP_rot = 23;
    public static final int DW_OP_xderef = 24;
    public static final int DW_OP_abs = 25;
    public static final int DW_OP_and = 26;
    public static final int DW_OP_div = 27;
    public static final int DW_OP_minus = 28;
    public static final int DW_OP_mod = 29;
    public static final int DW_OP_mul = 30;
    public static final int DW_OP_neg = 31;
    public static final int DW_OP_not = 32;
    public static final int DW_OP_or = 33;
    public static final int DW_OP_plus = 34;
    public static final int DW_OP_plus_uconst = 35;
    public static final int DW_OP_shl = 36;
    public static final int DW_OP_shr = 37;
    public static final int DW_OP_shra = 38;
    public static final int DW_OP_xor = 39;
    public static final int DW_OP_skip = 47;
    public static final int DW_OP_bra = 40;
    public static final int DW_OP_eq = 41;
    public static final int DW_OP_ge = 42;
    public static final int DW_OP_gt = 43;
    public static final int DW_OP_le = 44;
    public static final int DW_OP_lt = 45;
    public static final int DW_OP_ne = 46;
    public static final int DW_OP_lit0 = 48;
    public static final int DW_OP_lit1 = 49;
    public static final int DW_OP_lit31 = 79;
    public static final int DW_OP_reg0 = 80;
    public static final int DW_OP_reg1 = 81;
    public static final int DW_OP_reg31 = 111;
    public static final int DW_OP_breg0 = 112;
    public static final int DW_OP_breg1 = 113;
    public static final int DW_OP_breg31 = 143;
    public static final int DW_OP_regx = 144;
    public static final int DW_OP_fbreg = 145;
    public static final int DW_OP_bregx = 146;
    public static final int DW_OP_piece = 147;
    public static final int DW_OP_deref_size = 148;
    public static final int DW_OP_xderef_size = 149;
    public static final int DW_OP_nop = 150;
    public static final int DW_OP_push_object_address = 151;
    public static final int DW_OP_call2 = 152;
    public static final int DW_OP_call4 = 153;
    public static final int DW_OP_call_ref = 154;
    public static final int DW_OP_from_tls_address = 155;
    public static final int DW_OP_tls_cfa = 156;
    public static final int DW_OP_bit_piece = 157;
    public static final int DW_OP_implicit_value = 158;
    public static final int DW_OP_stack_value = 159;
    public static final int DW_OP_lo_user = 224;
    public static final int DW_OP_hi_user = 155;
    private static final long RESERVED_ABBREV_CODE = 0L;
    private static final long DW_CHILDREN_NO = 0L;
    private static final long DW_CHILDREN_YES = 1L;
    public static final byte DW_FORM_ADDR = 1;
    private static final byte DW_FORM_BLOCK2 = 3;
    private static final byte DW_FORM_BLOCK4 = 4;
    private static final byte DW_FORM_DATA2 = 5;
    private static final byte DW_FORM_DATA4 = 6;
    private static final byte DW_FORM_DATA8 = 7;
    public static final byte DW_FORM_STRING = 8;
    private static final byte DW_FORM_BLOCK = 9;
    private static final byte DW_FORM_BLOCK1 = 10;
    private static final byte DW_FORM_DATA1 = 11;
    private static final byte DW_FORM_FLAG = 12;
    private static final byte DW_FORM_SDATA = 13;
    public static final byte DW_FORM_STRP = 14;
    private static final byte DW_FORM_UDATA = 15;
    private static final byte DW_FORM_REF_ADDR = 16;
    private static final byte DW_FORM_REF1 = 17;
    private static final byte DW_FORM_REF2 = 18;
    private static final byte DW_FORM_REF4 = 19;
    private static final byte DW_FORM_REF8 = 20;
    private static final byte DW_FORM_REF_UDATA = 21;
    private static final byte DW_FORM_INDIRECT = 22;
    public static final byte DW_FORM_SEC_OFFSET = 23;
    private static final byte DW_FORM_EXPRLOC = 24;
    private static final byte DW_FORM_FLAG_PRESENT = 25;
    private static final byte DW_FORM_REF_SIG8 = 32;
    public static final byte DW_FORM_STRX = 26;
    public static final byte DW_FORM_ADDRX = 27;
    private static final byte DW_FORM_REF_SUP4 = 28;
    private static final byte DW_FORM_STRP_SUP = 29;
    private static final byte DW_FORM_DATA16 = 30;
    public static final byte DW_FORM_LINE_STRP = 31;
    public static final byte DW_FORM_IMPLICIT_CONST = 33;
    private static final byte DW_FORM_LOCLISTX = 34;
    public static final byte DW_FORM_RNGLISTX = 35;
    private static final byte DW_FORM_REF_SUP8 = 36;
    public static final byte DW_FORM_STRX1 = 37;
    public static final byte DW_FORM_STRX2 = 38;
    public static final byte DW_FORM_STRX3 = 39;
    public static final byte DW_FORM_STRX4 = 40;
    public static final byte DW_FORM_ADDRX1 = 41;
    public static final byte DW_FORM_ADDRX2 = 42;
    public static final byte DW_FORM_ADDRX3 = 43;
    public static final byte DW_FORM_ADDRX4 = 44;
    private static final long[] parse_context = new long[]{17L, 46L, 29L, 46L};
    public static long countInx = 0L;
    public long sectionOffset = 0L;
    public LinkedHashMap<Long, Long> dieParentMap = null;
    public long cuOffset = 0L;
    Map<Long, Long> m = new HashMap<Long, Long>();
    private String fileName = null;
    private long sectionSize = 0L;
    private long addrBits = 0L;
    private long dwarfFormat = 0L;
    private BinaryFileReader binaryFileReader = null;
    private CompilationUnitHeader header = null;
    public LinkedHashMap<Long, DebugInfoEntry> debugInfoTable = null;
    private Stack<Long> dieParentStack = null;
    private long cuDieOffset = 0L;
    private long timeCost = 0L;
    DebugStrOffsetsParser debugStrOffsetsParser;

    public DebugInfoPasrser(String fileName, long sectionOffset, long sectionSize, DebugStrOffsetsParser debugStrOffsetsParser) {
        this.fileName = fileName;
        this.sectionOffset = sectionOffset;
        this.sectionSize = sectionSize;
        this.debugStrOffsetsParser = debugStrOffsetsParser;
    }

    public boolean setAddrBits(long addrBits) {
        switch ((int)addrBits) {
            case 4: 
            case 32: {
                this.addrBits = 32L;
                break;
            }
            case 8: 
            case 64: {
                this.addrBits = 64L;
                break;
            }
            default: {
                Log.warn("Address bits error: %d", addrBits);
                return false;
            }
        }
        return true;
    }

    public long getAddrBits() {
        return this.addrBits;
    }

    public boolean setDwarfFormat(long format) {
        switch ((int)format) {
            case 4: 
            case 32: {
                this.dwarfFormat = 32L;
                break;
            }
            case 8: 
            case 64: {
                this.dwarfFormat = 64L;
                break;
            }
            default: {
                Log.error("File format error: %d", format);
                return false;
            }
        }
        return true;
    }

    public long getTimeCost() {
        return this.timeCost;
    }

    public void setTimeCost(long timeCost) {
        this.timeCost = timeCost;
    }

    private void clearEnv() {
        this.header = null;
        this.debugInfoTable = null;
        this.binaryFileReader.resetReadBytes();
        this.dieParentMap = null;
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            Log.error("Failed to close file: %s", this.fileName);
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return false != this.binaryFileReader.skip(this.sectionOffset);
    }

    private long getOffsetInCompilationUnit() {
        return this.binaryFileReader.getOffset() - this.cuOffset;
    }

    public long getSectionRestLength() {
        long offset = this.binaryFileReader.getOffset() - this.sectionOffset;
        return this.sectionSize - offset;
    }

    private long getUnitRestLength() {
        return this.header.getUnitLength() - this.binaryFileReader.getReadBytesNum();
    }

    public long getCuDieOffset() {
        return this.cuDieOffset;
    }

    public LinkedHashMap<Long, DebugInfoEntry> getDebugInfoTable(DebugAbbrevParser debugAbbrev, long offset) {
        if (offset < 0L || offset >= this.sectionSize) {
            return null;
        }
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(offset)) {
            this.close();
            return null;
        }
        return this.next(debugAbbrev);
    }

    public LinkedHashMap<Long, DebugInfoEntry> next(DebugAbbrevParser debugAbbrev) {
        long startTme = System.currentTimeMillis();
        if (null == this.binaryFileReader && !this.openFile()) {
            return null;
        }
        if (this.getSectionRestLength() <= 0L) {
            return null;
        }
        this.clearEnv();
        this.cuOffset = this.binaryFileReader.getOffset();
        this.debugInfoTable = new LinkedHashMap();
        this.dieParentStack = new Stack();
        this.dieParentMap = new LinkedHashMap();
        this.header = new CompilationUnitHeader(this.binaryFileReader);
        if (!this.header.parse()) {
            return null;
        }
        if (!this.setDwarfFormat(this.header.getDwarfFormat())) {
            return null;
        }
        if (!this.setAddrBits(this.header.getAddressSize())) {
            return null;
        }
        if (!this.parseDebugInfoTable(debugAbbrev)) {
            Log.error("Failed to parse debug info table", new Object[0]);
            return null;
        }
        this.timeCost += System.currentTimeMillis() - startTme;
        return this.debugInfoTable;
    }

    private boolean parseDebugInfoTable(DebugAbbrevParser debugAbbrev) {
        this.cuDieOffset = this.getOffsetInCompilationUnit();
        long abbrevOffset = this.header.getDebugAbbrevOffset();
        HashMap<Long, DebugAbbrevParser.DebugAbbrevEntry> abbrevTable = debugAbbrev.getAbbrevTable(abbrevOffset);
        int level = 0;
        this.dieParentStack.push(0L);
        DebugInfoEntry compileUnit = null;
        try {
            while (this.getUnitRestLength() > 0L) {
                long offset = this.getOffsetInCompilationUnit();
                long abbrevCode = 0L;
                abbrevCode = Leb128Parser.parseULeb128(this.binaryFileReader);
                if (0L == abbrevCode) {
                    if (--level < 0) continue;
                    this.dieParentStack.pop();
                    continue;
                }
                this.dieParentMap.put(offset, this.dieParentStack.peek());
                DebugAbbrevParser.DebugAbbrevEntry abbrevEntry = abbrevTable.get(abbrevCode);
                if (null == abbrevEntry) {
                    Log.error("Failed to get abbrev entry, abbrev code\uff1a%d", abbrevCode);
                    return false;
                }
                DebugInfoEntry entry = this.parseDebugInfoEntry(abbrevEntry);
                if (null == entry) {
                    Log.error("Failed to parse debug info entry", new Object[0]);
                    return false;
                }
                entry.setLevel(level);
                entry.setParent(this.debugInfoTable.getOrDefault(this.dieParentStack.peek(), null));
                entry.cuOffset = offset;
                if (entry.getTag() == 17L) {
                    compileUnit = entry;
                } else {
                    entry.setCompileUnit(compileUnit);
                }
                if (1L == (long)abbrevEntry.getHasChild()) {
                    ++level;
                    this.dieParentStack.push(offset);
                }
                this.debugInfoTable.put(offset, entry);
            }
        }
        catch (IOException e) {
            Log.error(e);
            return false;
        }
        return true;
    }

    private DebugInfoEntry parseDebugInfoEntry(DebugAbbrevParser.DebugAbbrevEntry abbrevEntry) {
        DebugInfoEntry entry = new DebugInfoEntry();
        entry.setTag(abbrevEntry.getTag());
        Vector<DebugAbbrevParser.DebugAbbrevAttribute> attributeTable = abbrevEntry.getAttributeTable();
        for (DebugAbbrevParser.DebugAbbrevAttribute abbrevAttribute : attributeTable) {
            String attributeValue = this.parseAttribute(abbrevAttribute);
            if (null == attributeValue) {
                Log.error("Fail to parse attribute of debug info entry", new Object[0]);
                return null;
            }
            if (attributeValue.isEmpty()) continue;
            entry.addAttribute(abbrevAttribute.getAttribute(), attributeValue);
            entry.addAttributeForm(abbrevAttribute.getAttribute(), abbrevAttribute.getForm());
        }
        return entry;
    }

    private String parseAddress() {
        long address;
        block4: {
            address = 0L;
            try {
                if (32L == this.addrBits) {
                    address = this.binaryFileReader.readUInt();
                    break block4;
                }
                if (64L == this.addrBits) {
                    address = this.binaryFileReader.readULong();
                    break block4;
                }
                Log.error("Address bits error", new Object[0]);
                return null;
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
        }
        return Long.toHexString(address);
    }

    private String parseBlock(long valueForm) {
        long blockLength = 0L;
        try {
            switch ((int)valueForm) {
                case 10: {
                    blockLength = this.binaryFileReader.readUByte();
                    break;
                }
                case 3: {
                    blockLength = this.binaryFileReader.readUShort();
                    break;
                }
                case 4: {
                    blockLength = this.binaryFileReader.readUInt();
                    break;
                }
                case 9: 
                case 24: {
                    blockLength = Leb128Parser.parseULeb128(this.binaryFileReader);
                    break;
                }
            }
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        byte[] array = new byte[(int)blockLength];
        if (!this.binaryFileReader.readByteArray(array)) {
            return null;
        }
        return DW_AT_location_prefix + Base64.getEncoder().encodeToString(array);
    }

    private String parseConstant(long valueForm) {
        long constant = 0L;
        try {
            switch ((int)valueForm) {
                case 11: 
                case 37: {
                    constant = this.binaryFileReader.readUByte();
                    if (constant != 8L) break;
                    boolean bl = true;
                    break;
                }
                case 5: 
                case 38: {
                    constant = this.binaryFileReader.readUShort();
                    break;
                }
                case 6: 
                case 40: {
                    constant = this.binaryFileReader.readUInt();
                    break;
                }
                case 7: {
                    constant = this.binaryFileReader.readULong();
                    break;
                }
                case 13: {
                    constant = Leb128Parser.parseSLeb128(this.binaryFileReader);
                    break;
                }
                case 15: 
                case 26: {
                    constant = Leb128Parser.parseULeb128(this.binaryFileReader);
                    break;
                }
                case 30: {
                    byte[] bytes = new byte[16];
                    this.binaryFileReader.readByteArray(bytes);
                    break;
                }
            }
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        return Long.toHexString(constant);
    }

    private String parseString() {
        StringBuilder stringBuffer = new StringBuilder();
        byte b = 0;
        try {
            while (0 != (b = this.binaryFileReader.readByte())) {
                stringBuffer.append((char)b);
            }
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        return stringBuffer.toString();
    }

    private String parseStringPointer() {
        long offset = 0L;
        try {
            if (32L == this.dwarfFormat) {
                offset = this.binaryFileReader.readUInt();
            } else if (64L == this.dwarfFormat) {
                offset = this.binaryFileReader.readULong();
            }
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        return Long.toHexString(offset);
    }

    private String parseFlag() {
        long flag = 0L;
        try {
            flag = this.binaryFileReader.readUByte();
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        return Long.toHexString(flag);
    }

    private String parseReference(long valueForm) {
        long reference = 0L;
        try {
            switch ((int)valueForm) {
                case 17: {
                    reference = this.binaryFileReader.readUByte();
                    break;
                }
                case 18: {
                    reference = this.binaryFileReader.readUShort();
                    break;
                }
                case 19: 
                case 28: {
                    reference = this.binaryFileReader.readUInt();
                    break;
                }
                case 20: 
                case 32: 
                case 36: {
                    reference = this.binaryFileReader.readULong();
                    break;
                }
                case 21: {
                    reference = Leb128Parser.parseULeb128(this.binaryFileReader);
                    break;
                }
            }
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        return Long.toHexString(reference);
    }

    private String parseSectionOffset() {
        long offset = 0L;
        try {
            if (32L == this.dwarfFormat) {
                offset = this.binaryFileReader.readUInt();
            } else if (64L == this.dwarfFormat) {
                offset = this.binaryFileReader.readULong();
            }
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        return Long.toHexString(offset);
    }

    private String parseDebugStrOffset(long valueForm) {
        long constant = 0L;
        try {
            switch ((int)valueForm) {
                case 37: {
                    constant = this.binaryFileReader.readUByte();
                    break;
                }
                case 38: {
                    constant = this.binaryFileReader.readUShort();
                    break;
                }
                case 39: {
                    byte[] bytes = new byte[3];
                    this.binaryFileReader.readByteArray(bytes);
                    break;
                }
                case 40: {
                    constant = this.binaryFileReader.readUInt();
                    break;
                }
                case 26: {
                    constant = Leb128Parser.parseULeb128(this.binaryFileReader);
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return Long.toHexString(constant);
    }

    private String parseDebugAddrOffset(long valueForm) {
        long constant = 0L;
        try {
            switch ((int)valueForm) {
                case 41: {
                    constant = this.binaryFileReader.readUByte();
                    break;
                }
                case 42: {
                    constant = this.binaryFileReader.readUShort();
                    break;
                }
                case 43: {
                    byte[] bytes = new byte[3];
                    this.binaryFileReader.readByteArray(bytes);
                    break;
                }
                case 44: {
                    constant = this.binaryFileReader.readUInt();
                    break;
                }
                case 27: {
                    constant = Leb128Parser.parseULeb128(this.binaryFileReader);
                    break;
                }
            }
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        return Long.toHexString(constant);
    }

    private String parseLoclist(long valueForm) {
        long constant = 0L;
        try {
            switch ((int)valueForm) {
                case 34: {
                    constant = Leb128Parser.parseULeb128(this.binaryFileReader);
                    break;
                }
            }
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        return Long.toHexString(constant);
    }

    private String parseRnglist(long valueForm) {
        long constant = 0L;
        try {
            switch ((int)valueForm) {
                case 35: {
                    constant = Leb128Parser.parseULeb128(this.binaryFileReader);
                    break;
                }
            }
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        return Long.toHexString(constant);
    }

    private String parseIndirect() {
        long indirect = 0L;
        try {
            indirect = Leb128Parser.parseULeb128(this.binaryFileReader);
            return this.parseForm2((int)indirect);
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
    }

    private String parseReferenceAddress() {
        long offset;
        block7: {
            offset = 0L;
            try {
                if (2L == this.header.getVersion()) {
                    if (32L == this.addrBits) {
                        offset = this.binaryFileReader.readUInt();
                        break block7;
                    }
                    if (64L == this.addrBits) {
                        offset = this.binaryFileReader.readULong();
                        break block7;
                    }
                    Log.error("Address bits error", new Object[0]);
                    return null;
                }
                if (32L == this.dwarfFormat) {
                    offset = this.binaryFileReader.readUInt();
                    break block7;
                }
                if (64L == this.dwarfFormat) {
                    offset = this.binaryFileReader.readULong();
                    break block7;
                }
                Log.warn("Debug_info \u5730\u5740\u4f4d\u6570\uff08%d\u4f4d\uff09\u9519\u8bef", this.addrBits);
                return null;
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
        }
        return Long.toHexString(offset);
    }

    private String parseAttribute(DebugAbbrevParser.DebugAbbrevAttribute abbrevAttribute) {
        long valueForm = abbrevAttribute.getForm();
        String attributeValue = null;
        switch ((int)valueForm) {
            case 1: {
                attributeValue = this.parseAddress();
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 24: {
                attributeValue = this.parseBlock(valueForm);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 30: {
                attributeValue = this.parseConstant(valueForm);
                break;
            }
            case 8: {
                attributeValue = this.parseString();
                break;
            }
            case 14: 
            case 29: 
            case 31: {
                attributeValue = this.parseStringPointer();
                break;
            }
            case 12: {
                attributeValue = this.parseFlag();
                break;
            }
            case 25: {
                attributeValue = new String();
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 32: 
            case 36: {
                attributeValue = this.parseReference(valueForm);
                break;
            }
            case 16: {
                attributeValue = this.parseReferenceAddress();
                break;
            }
            case 22: {
                attributeValue = this.parseIndirect();
                break;
            }
            case 23: {
                attributeValue = this.parseSectionOffset();
                break;
            }
            case 26: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                attributeValue = this.parseDebugStrOffset(valueForm);
                break;
            }
            case 27: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                attributeValue = this.parseDebugAddrOffset(valueForm);
                break;
            }
            case 33: {
                attributeValue = "";
                break;
            }
            case 34: {
                attributeValue = this.parseLoclist(valueForm);
                break;
            }
            case 35: {
                attributeValue = this.parseRnglist(valueForm);
                break;
            }
            default: {
                Log.error("Form of attribute value error\uff1a0x%x", valueForm);
                return null;
            }
        }
        if (abbrevAttribute.getAttribute() == 2L && attributeValue != null && attributeValue.equals("0") && !this.m.containsKey(valueForm)) {
            System.out.println("DW_AT_location Form:" + abbrevAttribute.getForm());
            this.m.put(valueForm, 1L);
        }
        return attributeValue;
    }

    private String parseForm2(int valueForm) {
        String attributeValue = null;
        switch (valueForm) {
            case 1: {
                attributeValue = this.parseAddress();
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 24: {
                attributeValue = this.parseBlock(valueForm);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 30: {
                attributeValue = this.parseConstant(valueForm);
                break;
            }
            case 8: {
                attributeValue = this.parseString();
                break;
            }
            case 14: 
            case 29: 
            case 31: {
                attributeValue = this.parseStringPointer();
                break;
            }
            case 12: {
                attributeValue = this.parseFlag();
                break;
            }
            case 25: {
                attributeValue = new String();
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 28: 
            case 32: 
            case 36: {
                attributeValue = this.parseReference(valueForm);
                break;
            }
            case 16: {
                attributeValue = this.parseReferenceAddress();
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                attributeValue = this.parseSectionOffset();
                break;
            }
            case 26: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                attributeValue = this.parseDebugStrOffset(valueForm);
                break;
            }
            case 27: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                attributeValue = this.parseDebugAddrOffset(valueForm);
                break;
            }
            case 33: {
                attributeValue = "";
                break;
            }
            case 34: {
                attributeValue = this.parseLoclist(valueForm);
                break;
            }
            case 35: {
                attributeValue = this.parseRnglist(valueForm);
                break;
            }
            default: {
                Log.error("Form of attribute value error\uff1a0x%x", valueForm);
                return null;
            }
        }
        return attributeValue;
    }

    public String parseLocation(byte[] location) {
        String local = "";
        ParseBuffer buffer = new ParseBuffer(location, ByteOrder.LITTLE_ENDIAN);
        short op = buffer.readU8();
        if (op >= 80 && op <= 111) {
            local = "DW_OP_reg" + (op - 80);
            return local;
        }
        if (op >= 112 && op <= 143) {
            local = "DW_OP_breg" + (op - 112) + ": " + buffer.parseSLeb128();
            return local;
        }
        switch (op) {
            case 3: {
                local = "DW_OP_addr: " + buffer.parseAddress(this.addrBits);
                break;
            }
            case 144: {
                local = "DW_OP_regx: " + buffer.parseULeb128();
                break;
            }
            case 145: {
                local = "DW_OP_fbreg: " + buffer.parseSLeb128();
            }
        }
        return local;
    }

    public static class CompilationUnitHeader {
        public static final int HEADER_LENGTH_32 = 11;
        public static final int HEADER_LENGTH_64 = 23;
        public static final int IDENTIFICATION_OF_64BIT = -1;
        public static final int ADDRESS_SIZE_4 = 4;
        public static final int ADDRESS_SIZE_8 = 8;
        public long dwarfVersion = 4L;
        private BinaryFileReader binaryFileReader = null;
        private long dwarfFormat = 0L;
        private long unitLength = 0L;
        private long version = 0L;
        private long debugAbbrevOffset = 0L;
        private long addressSize = 0L;

        public CompilationUnitHeader(BinaryFileReader binaryFileReader) {
            this.setBinaryFileReader(binaryFileReader);
        }

        private boolean parseUnitLength() {
            try {
                this.unitLength = this.binaryFileReader.readUInt();
                if (-1L == this.unitLength) {
                    this.dwarfFormat = 64L;
                    this.unitLength = this.binaryFileReader.readULong();
                } else {
                    this.dwarfFormat = 32L;
                }
                this.binaryFileReader.resetReadBytes();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseVersion() {
            try {
                this.version = this.binaryFileReader.readUShort();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseUnitByte() {
            try {
                this.binaryFileReader.readUByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseDebugAbbrevOffset() {
            try {
                if (32L == this.dwarfFormat) {
                    this.debugAbbrevOffset = this.binaryFileReader.readUInt();
                } else if (64L == this.dwarfFormat) {
                    this.debugAbbrevOffset = this.binaryFileReader.readULong();
                }
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            return true;
        }

        private boolean parseAddressSize() {
            try {
                this.addressSize = this.binaryFileReader.readUByte();
            }
            catch (IOException e) {
                Log.error(e);
                return false;
            }
            if (4L != this.addressSize && 8L != this.addressSize) {
                Log.error("Address size of debug info header error: %d", this.addressSize);
                return false;
            }
            return true;
        }

        private void setBinaryFileReader(BinaryFileReader binaryFileReader) {
            this.binaryFileReader = binaryFileReader;
        }

        public boolean parse() {
            if (null == this.binaryFileReader) {
                return false;
            }
            if (!this.parseUnitLength()) {
                return false;
            }
            if (!this.parseVersion()) {
                return false;
            }
            if (this.version == 5L) {
                if (!this.parseUnitByte()) {
                    return false;
                }
                if (!this.parseAddressSize()) {
                    return false;
                }
                return this.parseDebugAbbrevOffset();
            }
            if (!this.parseDebugAbbrevOffset()) {
                return false;
            }
            return this.parseAddressSize();
        }

        public long getUnitLength() {
            return this.unitLength;
        }

        public long getVersion() {
            return this.version;
        }

        public long getDebugAbbrevOffset() {
            return this.debugAbbrevOffset;
        }

        public long getAddressSize() {
            return this.addressSize;
        }

        public long getDwarfFormat() {
            return this.dwarfFormat;
        }
    }

    public static class DebugInfoEntry {
        public long cuOffset = 0L;
        public List<Subroutine> subroutines;
        private long tag = 0L;
        private int level = 0;
        public HashMap<Long, String> attributeTable = null;
        public HashMap<Long, Long> attributeForm = null;
        private DebugInfoEntry parent;
        private String name = null;
        private DebugInfoEntry CompileUnit = null;

        public DebugInfoEntry() {
            this.setTag(0L);
            this.attributeTable = new HashMap();
            this.attributeForm = new HashMap();
        }

        public void addAttribute(long attribute, String value) {
            this.attributeTable.put(attribute, value);
        }

        public void addAttributeForm(long attribute, long form) {
            this.attributeForm.put(attribute, form);
        }

        public long getTag() {
            return this.tag;
        }

        public void setTag(long tag) {
            this.tag = tag;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public String getAttribute(long attribute) {
            return this.attributeTable.get(attribute);
        }

        public DebugInfoEntry getParent() {
            return this.parent;
        }

        public void setParent(DebugInfoEntry parent) {
            this.parent = parent;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getCuOffset() {
            return this.cuOffset;
        }

        public List<Subroutine> getSubroutines() {
            return this.subroutines;
        }

        public HashMap<Long, String> getAttributeTable() {
            return this.attributeTable;
        }

        public HashMap<Long, Long> getAttributeForm() {
            return this.attributeForm;
        }

        public DebugInfoEntry getCompileUnit() {
            return this.CompileUnit;
        }

        public void setCuOffset(long cuOffset) {
            this.cuOffset = cuOffset;
        }

        public void setSubroutines(List<Subroutine> subroutines) {
            this.subroutines = subroutines;
        }

        public void setAttributeTable(HashMap<Long, String> attributeTable) {
            this.attributeTable = attributeTable;
        }

        public void setAttributeForm(HashMap<Long, Long> attributeForm) {
            this.attributeForm = attributeForm;
        }

        public void setCompileUnit(DebugInfoEntry CompileUnit) {
            this.CompileUnit = CompileUnit;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebugInfoEntry)) {
                return false;
            }
            DebugInfoEntry other = (DebugInfoEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCuOffset() != other.getCuOffset()) {
                return false;
            }
            if (this.getTag() != other.getTag()) {
                return false;
            }
            if (this.getLevel() != other.getLevel()) {
                return false;
            }
            List<Subroutine> this$subroutines = this.getSubroutines();
            List<Subroutine> other$subroutines = other.getSubroutines();
            if (this$subroutines == null ? other$subroutines != null : !((Object)this$subroutines).equals(other$subroutines)) {
                return false;
            }
            HashMap<Long, String> this$attributeTable = this.getAttributeTable();
            HashMap<Long, String> other$attributeTable = other.getAttributeTable();
            if (this$attributeTable == null ? other$attributeTable != null : !((Object)this$attributeTable).equals(other$attributeTable)) {
                return false;
            }
            HashMap<Long, Long> this$attributeForm = this.getAttributeForm();
            HashMap<Long, Long> other$attributeForm = other.getAttributeForm();
            if (this$attributeForm == null ? other$attributeForm != null : !((Object)this$attributeForm).equals(other$attributeForm)) {
                return false;
            }
            DebugInfoEntry this$parent = this.getParent();
            DebugInfoEntry other$parent = other.getParent();
            if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            DebugInfoEntry this$CompileUnit = this.getCompileUnit();
            DebugInfoEntry other$CompileUnit = other.getCompileUnit();
            return !(this$CompileUnit == null ? other$CompileUnit != null : !((Object)this$CompileUnit).equals(other$CompileUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DebugInfoEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $cuOffset = this.getCuOffset();
            result = result * 59 + (int)($cuOffset >>> 32 ^ $cuOffset);
            long $tag = this.getTag();
            result = result * 59 + (int)($tag >>> 32 ^ $tag);
            result = result * 59 + this.getLevel();
            List<Subroutine> $subroutines = this.getSubroutines();
            result = result * 59 + ($subroutines == null ? 43 : ((Object)$subroutines).hashCode());
            HashMap<Long, String> $attributeTable = this.getAttributeTable();
            result = result * 59 + ($attributeTable == null ? 43 : ((Object)$attributeTable).hashCode());
            HashMap<Long, Long> $attributeForm = this.getAttributeForm();
            result = result * 59 + ($attributeForm == null ? 43 : ((Object)$attributeForm).hashCode());
            DebugInfoEntry $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            DebugInfoEntry $CompileUnit = this.getCompileUnit();
            result = result * 59 + ($CompileUnit == null ? 43 : ((Object)$CompileUnit).hashCode());
            return result;
        }

        public String toString() {
            return "DebugInfoPasrser.DebugInfoEntry(cuOffset=" + this.getCuOffset() + ", subroutines=" + this.getSubroutines() + ", tag=" + this.getTag() + ", level=" + this.getLevel() + ", attributeTable=" + this.getAttributeTable() + ", attributeForm=" + this.getAttributeForm() + ", parent=" + this.getParent() + ", name=" + this.getName() + ", CompileUnit=" + this.getCompileUnit() + ")";
        }
    }
}

