/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.dwarf.EndianSlice;
import com.uqm.crashsight.symtabtool.dwarf.Endianity;
import com.uqm.crashsight.symtabtool.dwarf.Format;
import com.uqm.crashsight.symtabtool.dwarf.ParseBuffer;
import com.uqm.crashsight.symtabtool.dwarf.Reader;
import com.uqm.crashsight.symtabtool.dwarf.UnwindSectionExt;

class DebugFrame<Endian extends Endianity>
implements UnwindSectionExt {
    Reader section;
    byte addressSize;
    byte segmentSize;

    DebugFrame() {
    }

    @Override
    public void setAddressSize(byte addressSize) {
        this.addressSize = addressSize;
    }

    public void setSegmentSize(byte segmentSize) {
        this.segmentSize = segmentSize;
    }

    public static <Endian extends Endianity> DebugFrame<Endian> from(EndianSlice<Endian> section) {
        DebugFrame<Endian> debugFrame = new DebugFrame<Endian>();
        debugFrame.section = section;
        debugFrame.addressSize = (byte)8;
        debugFrame.segmentSize = 0;
        return debugFrame;
    }

    public static <Endian extends Endianity> DebugFrame<Endian> _new(ParseBuffer section, Endian endian) {
        EndianSlice<Endian> slice = new EndianSlice<Endian>(section, endian);
        return DebugFrame.from(slice);
    }

    @Override
    public boolean isCie(Format format, long id) {
        if (format == Format.Dwarf32) {
            return id == 0xFFFFFFFFL;
        }
        if (format == Format.Dwarf64) {
            return id == -1L;
        }
        return false;
    }

    @Override
    public Reader section() {
        return this.section;
    }

    @Override
    public boolean lengthValueIsEndOfEntries(Long offset) {
        return false;
    }

    @Override
    public boolean hasAddressAndSegmentSizes(short version) {
        return version == 4;
    }

    @Override
    public short addressSize() {
        return this.addressSize;
    }

    @Override
    public short segmentSize() {
        return this.segmentSize;
    }

    @Override
    public Long resolveCieOffset(long base, long offset) {
        return offset;
    }
}

