/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.Leb128Parser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

public class DebugAbbrevParser {
    private static final long RESERVED_CODE = 0L;
    private String fileName = null;
    public long sectionOffset = 0L;
    private long sectionSize = 0L;
    private BinaryFileReader binaryFileReader = null;

    public void setSectionSize(long sectionSize) {
        this.sectionSize = sectionSize;
    }

    public void setSectionOffset(long sectionOffset) {
        this.sectionOffset = sectionOffset;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public DebugAbbrevParser(String fileName, long sectionOffset, long sectionSize) {
        this.setFileName(fileName);
        this.setSectionOffset(sectionOffset);
        this.setSectionSize(sectionSize);
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            Log.error("Failed to open file\uff1a%s", this.fileName);
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
        return false != this.binaryFileReader.skip(this.sectionOffset);
    }

    public long getSectionRestLength() {
        long offset = this.binaryFileReader.getOffset() - this.sectionOffset;
        return this.sectionSize - offset;
    }

    private Vector<DebugAbbrevAttribute> parseAttributeTable() {
        Vector<DebugAbbrevAttribute> attributeTable = new Vector<DebugAbbrevAttribute>();
        while (true) {
            long attribute = 0L;
            long form = 0L;
            try {
                attribute = Leb128Parser.parseULeb128(this.binaryFileReader);
                form = Leb128Parser.parseULeb128(this.binaryFileReader);
                if (33L == form) {
                    Leb128Parser.parseULeb128(this.binaryFileReader);
                }
            }
            catch (IOException e) {
                Log.error(e);
                return null;
            }
            if (0L == attribute && 0L == form) break;
            DebugAbbrevAttribute entry = new DebugAbbrevAttribute();
            entry.setAttribute(attribute);
            entry.setForm(form);
            attributeTable.add(entry);
        }
        return attributeTable;
    }

    private DebugAbbrevEntry parseAbbrevEntry(long code) {
        long tag = 0L;
        byte hasChild = 0;
        try {
            tag = Leb128Parser.parseULeb128(this.binaryFileReader);
            hasChild = this.binaryFileReader.readByte();
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        Vector<DebugAbbrevAttribute> attributeTable = this.parseAttributeTable();
        if (null == attributeTable) {
            Log.error("Failed to parse attribute table of abbrev entry", new Object[0]);
            return null;
        }
        DebugAbbrevEntry entry = new DebugAbbrevEntry(code);
        entry.setTag(tag);
        entry.setHasChild(hasChild);
        entry.setAttributeTable(attributeTable);
        return entry;
    }

    private HashMap<Long, DebugAbbrevEntry> parseAbbrevTable() {
        if (this.getSectionRestLength() <= 0L) {
            return null;
        }
        HashMap<Long, DebugAbbrevEntry> abbrevTable = new HashMap<Long, DebugAbbrevEntry>();
        long code = 0L;
        try {
            while (0L != (code = Leb128Parser.parseULeb128(this.binaryFileReader))) {
                DebugAbbrevEntry entry = this.parseAbbrevEntry(code);
                if (null == entry) {
                    Log.error("Failed to parse abbrev entry", new Object[0]);
                    return null;
                }
                abbrevTable.put(new Long(entry.getCode()), entry);
            }
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
        return abbrevTable;
    }

    public HashMap<Long, DebugAbbrevEntry> getAbbrevTable(long offset) {
        if (offset < 0L || offset >= this.sectionSize) {
            return null;
        }
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(offset)) {
            this.close();
            return null;
        }
        HashMap<Long, DebugAbbrevEntry> abbrevTable = this.parseAbbrevTable();
        if (null == abbrevTable) {
            Log.error("Failed to parse abbrev table", new Object[0]);
        }
        this.close();
        return abbrevTable;
    }

    public static class DebugAbbrevEntry {
        private long code = 0L;
        private long tag = 0L;
        private byte hasChild = 0;
        private Vector<DebugAbbrevAttribute> attributeTable = null;

        public void setCode(long code) {
            this.code = code;
        }

        public void setTag(long tag) {
            this.tag = tag;
        }

        public void setHasChild(byte hasChild) {
            this.hasChild = hasChild;
        }

        public void setAttributeTable(Vector<DebugAbbrevAttribute> attributeTable) {
            this.attributeTable = attributeTable;
        }

        public DebugAbbrevEntry() {
            this.setCode(0L);
            this.setTag(0L);
            this.setHasChild((byte)0);
            this.setAttributeTable(null);
        }

        public DebugAbbrevEntry(long code) {
            this.setCode(code);
            this.setTag(0L);
            this.setHasChild((byte)0);
            this.setAttributeTable(null);
        }

        public long getCode() {
            return this.code;
        }

        public long getTag() {
            return this.tag;
        }

        public byte getHasChild() {
            return this.hasChild;
        }

        public Vector<DebugAbbrevAttribute> getAttributeTable() {
            return this.attributeTable;
        }
    }

    public static class DebugAbbrevAttribute {
        private long attribute = 0L;
        private long form = 0L;

        public DebugAbbrevAttribute() {
            this.setAttribute(0L);
            this.setForm(0L);
        }

        public DebugAbbrevAttribute(long attribute, long form) {
            this.setAttribute(attribute);
            this.setForm(form);
        }

        public void setAttribute(long attribute) {
            this.attribute = attribute;
        }

        public void setForm(long form) {
            this.form = form;
        }

        public long getAttribute() {
            return this.attribute;
        }

        public long getForm() {
            return this.form;
        }
    }
}

