/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.dwarf.Augmentation;
import com.uqm.crashsight.symtabtool.dwarf.BaseAddresses;
import com.uqm.crashsight.symtabtool.dwarf.CallFrameInstructionIter;
import com.uqm.crashsight.symtabtool.dwarf.Format;
import com.uqm.crashsight.symtabtool.dwarf.PointerEncodingParameters;
import com.uqm.crashsight.symtabtool.dwarf.Reader;
import com.uqm.crashsight.symtabtool.dwarf.Register;
import com.uqm.crashsight.symtabtool.dwarf.UnwindSection;
import com.uqm.crashsight.symtabtool.dwarf._UnwindSectionPrivate;

class CommonInformationEntry {
    Long offset;
    Long length;
    Format format;
    short version;
    Augmentation augmentation;
    short addressSize;
    short segmentSize;
    long codeAlignmentFactor;
    long dataAlignmentFactor;
    Register returnAddressRegister;
    Reader initialInstructions;

    CommonInformationEntry(long offset, long length, Format format, short version, Augmentation augmentation, short addressSize, short segmentSize, long codeAlignmentFactor, long dataAlignmentFactor, Register returnAddressRegister, Reader initialInstructions) {
        this.offset = offset;
        this.length = length;
        this.format = format;
        this.version = version;
        this.augmentation = augmentation;
        this.addressSize = addressSize;
        this.segmentSize = segmentSize;
        this.codeAlignmentFactor = codeAlignmentFactor;
        this.dataAlignmentFactor = dataAlignmentFactor;
        this.returnAddressRegister = returnAddressRegister;
        this.initialInstructions = initialInstructions;
    }

    public CallFrameInstructionIter instructions(UnwindSection section, BaseAddresses bases) {
        return new CallFrameInstructionIter(this.initialInstructions._clone(), null, new PointerEncodingParameters(bases.ehFrame, null, this.addressSize, section.section()));
    }

    public static CommonInformationEntry parseRest(Long offset, Long length, Format format, BaseAddresses bases, _UnwindSectionPrivate section, Reader rest) {
        short version = rest.readU8();
        if (version != 1 && version != 3 && version != 4) {
            throw new RuntimeException("UnknownVersion:" + version);
        }
        Reader augmentationString = rest.readNullTerminatedSlice();
        short addressSize = section.addressSize();
        short segmentSize = section.segmentSize();
        if (section.hasAddressAndSegmentSizes(version)) {
            addressSize = rest.readU8();
            segmentSize = rest.readU8();
        }
        long codeAlignmentFactor = rest.readULeb128();
        long dataAlignmentFactor = rest.readSLeb128();
        Register returnAddressRegister = null;
        returnAddressRegister = version == 1 ? new Register(rest.readU8()) : new Register((int)rest.readULeb128());
        Augmentation augmentation = null;
        if (!augmentationString.isEmpty()) {
            augmentation = Augmentation.parse(augmentationString, bases, addressSize, section, rest);
        }
        return new CommonInformationEntry(offset, length, format, version, augmentation, addressSize, segmentSize, codeAlignmentFactor, dataAlignmentFactor, returnAddressRegister, rest);
    }
}

