/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.AdvanceLoc;
import com.uqm.crashsight.symtabtool.dwarf.ArgsSize;
import com.uqm.crashsight.symtabtool.dwarf.Augmentation;
import com.uqm.crashsight.symtabtool.dwarf.CfaExpression;
import com.uqm.crashsight.symtabtool.dwarf.CfaRegister;
import com.uqm.crashsight.symtabtool.dwarf.DefCfa;
import com.uqm.crashsight.symtabtool.dwarf.DefCfaExpression;
import com.uqm.crashsight.symtabtool.dwarf.DefCfaOffset;
import com.uqm.crashsight.symtabtool.dwarf.DefCfaOffsetSf;
import com.uqm.crashsight.symtabtool.dwarf.DefCfaRegister;
import com.uqm.crashsight.symtabtool.dwarf.DefCfaSf;
import com.uqm.crashsight.symtabtool.dwarf.DwEhPe;
import com.uqm.crashsight.symtabtool.dwarf.Nop;
import com.uqm.crashsight.symtabtool.dwarf.Offset;
import com.uqm.crashsight.symtabtool.dwarf.OffsetExtendedSf;
import com.uqm.crashsight.symtabtool.dwarf.PointerEncodingParameters;
import com.uqm.crashsight.symtabtool.dwarf.Reader;
import com.uqm.crashsight.symtabtool.dwarf.Register;
import com.uqm.crashsight.symtabtool.dwarf.RememberState;
import com.uqm.crashsight.symtabtool.dwarf.Restore;
import com.uqm.crashsight.symtabtool.dwarf.RestoreState;
import com.uqm.crashsight.symtabtool.dwarf.SameValue;
import com.uqm.crashsight.symtabtool.dwarf.SetLoc;
import com.uqm.crashsight.symtabtool.dwarf.Undefined;
import com.uqm.crashsight.symtabtool.dwarf.UnknownCallFrameInstruction;
import com.uqm.crashsight.symtabtool.dwarf.ValExpression;
import com.uqm.crashsight.symtabtool.dwarf.ValueOffset;
import com.uqm.crashsight.symtabtool.dwarf.ValueOffsetSf;

class CallFrameInstruction {
    public static int CFI_INSTRUCTION_HIGH_BITS_MASK = 192;
    public static int CFI_INSTRUCTION_LOW_BITS_MASK = ~CFI_INSTRUCTION_HIGH_BITS_MASK;
    SetLoc setLoc;
    AdvanceLoc advanceLoc;
    DefCfa defCfa;
    DefCfaSf defCfaSf;
    DefCfaRegister defCfaRegister;
    DefCfaOffset defCfaOffset;
    DefCfaOffsetSf defCfaOffsetSf;
    DefCfaExpression defCfaExpression;
    Undefined undefined;
    SameValue sameValue;
    Offset offset;
    OffsetExtendedSf offsetExtendedSf;
    ValueOffset valueOffset;
    ValueOffsetSf valueOffsetSf;
    CfaRegister cfaRegister;
    CfaExpression expression;
    ValExpression valExpression;
    Restore restore;
    RememberState rememberState;
    RestoreState restoreState;
    ArgsSize argsSize;
    Nop nop;

    CallFrameInstruction() {
    }

    /*
     * Unable to fully structure code
     */
    public static CallFrameInstruction parse(Reader input, DwEhPe addressEncoding, PointerEncodingParameters parameters) throws UnknownCallFrameInstruction {
        callFrameInstruction = new CallFrameInstruction();
        instruction = input.readU8();
        highBits = instruction & CallFrameInstruction.CFI_INSTRUCTION_HIGH_BITS_MASK;
        if (highBits == 64) {
            delta = instruction & CallFrameInstruction.CFI_INSTRUCTION_LOW_BITS_MASK;
            callFrameInstruction.advanceLoc = new AdvanceLoc(delta);
            return callFrameInstruction;
        }
        if (highBits == 128) {
            register = new Register(instruction & CallFrameInstruction.CFI_INSTRUCTION_LOW_BITS_MASK);
            offset = input.readULeb128();
            callFrameInstruction.offset = new Offset(register, offset);
            return callFrameInstruction;
        }
        if (highBits == 192) {
            register = new Register(instruction & CallFrameInstruction.CFI_INSTRUCTION_LOW_BITS_MASK);
            callFrameInstruction.restore = new Restore(register);
            return callFrameInstruction;
        }
        switch (instruction) {
            case 0: {
                callFrameInstruction.nop = new Nop();
                break;
            }
            case 1: {
                address = 0L;
                if (addressEncoding == null) ** GOTO lbl31
                pointer = Augmentation.parseEncodedPointer(addressEncoding, parameters, input);
                if (pointer != null && pointer.direct != null) {
                    address = pointer.direct;
                } else {
                    Log.error("UnsupportedPointerEncoding", new Object[0]);
                    return null;
lbl31:
                    // 1 sources

                    address = input.readAddress(parameters.addressSize);
                }
                callFrameInstruction.setLoc = new SetLoc(address);
                break;
            }
            case 2: {
                delta = input.readU8();
                callFrameInstruction.advanceLoc = new AdvanceLoc(delta);
                break;
            }
            case 3: {
                delta = input.readU16();
                callFrameInstruction.advanceLoc = new AdvanceLoc(delta);
                break;
            }
            case 4: {
                delta = input.readU32();
                callFrameInstruction.advanceLoc = new AdvanceLoc(delta);
                break;
            }
            case 5: {
                register = new Register((int)input.readULeb128());
                callFrameInstruction.offset = new Offset(register, input.readULeb128());
                break;
            }
            case 6: {
                register = new Register((int)input.readULeb128());
                callFrameInstruction.restore = new Restore(register);
                break;
            }
            case 7: {
                register = new Register((int)input.readULeb128());
                callFrameInstruction.undefined = new Undefined(register);
                break;
            }
            case 8: {
                register = new Register((int)input.readULeb128());
                callFrameInstruction.sameValue = new SameValue(register);
                break;
            }
            case 9: {
                dest = new Register((int)input.readULeb128());
                src = new Register((int)input.readULeb128());
                callFrameInstruction.cfaRegister = new CfaRegister(dest, src);
                break;
            }
            case 10: {
                callFrameInstruction.rememberState = new RememberState();
                break;
            }
            case 11: {
                callFrameInstruction.restoreState = new RestoreState();
                break;
            }
            case 12: {
                register = new Register((int)input.readULeb128());
                offset = input.readULeb128();
                callFrameInstruction.defCfa = new DefCfa(register, offset);
                break;
            }
            case 13: {
                register = new Register((int)input.readULeb128());
                callFrameInstruction.defCfaRegister = new DefCfaRegister(register);
                break;
            }
            case 14: {
                offset = input.readULeb128();
                callFrameInstruction.defCfaOffset = new DefCfaOffset(offset);
                break;
            }
            case 15: {
                len = input.readULeb128();
                reader = input.split(len);
                callFrameInstruction.defCfaExpression = new DefCfaExpression(null);
                break;
            }
            case 16: {
                register = new Register((int)input.readULeb128());
                offset = input.readULeb128();
                reader = input.split(offset);
                callFrameInstruction.expression = new CfaExpression(register, null);
                break;
            }
            case 17: {
                register = new Register((int)input.readULeb128());
                offset = input.readSLeb128();
                callFrameInstruction.offsetExtendedSf = new OffsetExtendedSf(register, offset);
                break;
            }
            case 18: {
                register = new Register((int)input.readULeb128());
                offset = input.readSLeb128();
                callFrameInstruction.defCfaSf = new DefCfaSf(register, offset);
                break;
            }
            case 19: {
                offset = input.readSLeb128();
                callFrameInstruction.defCfaOffsetSf = new DefCfaOffsetSf(offset);
                break;
            }
            case 20: {
                register = new Register((int)input.readULeb128());
                offset = input.readULeb128();
                callFrameInstruction.valueOffset = new ValueOffset(register, offset);
                break;
            }
            case 21: {
                register = new Register((int)input.readULeb128());
                offset = input.readULeb128();
                callFrameInstruction.valueOffsetSf = new ValueOffsetSf(register, offset);
                break;
            }
            case 22: {
                register = new Register((int)input.readULeb128());
                offset = input.readULeb128();
                callFrameInstruction.valExpression = new ValExpression(register, null);
                break;
            }
            case 46: {
                size = input.readULeb128();
                callFrameInstruction.argsSize = new ArgsSize(size);
                break;
            }
            default: {
                throw new UnknownCallFrameInstruction(String.format("UnknownCallFrameInstruction[%d]", new Object[]{instruction}));
            }
        }
        return callFrameInstruction;
    }
}

