/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.BaseAddresses;
import com.uqm.crashsight.symtabtool.dwarf.DwEhPe;
import com.uqm.crashsight.symtabtool.dwarf.Personality;
import com.uqm.crashsight.symtabtool.dwarf.Pointer;
import com.uqm.crashsight.symtabtool.dwarf.PointerEncodingParameters;
import com.uqm.crashsight.symtabtool.dwarf.Reader;
import com.uqm.crashsight.symtabtool.dwarf._UnwindSectionPrivate;

class Augmentation {
    DwEhPe lsda;
    Personality personality;
    DwEhPe fdeAddressEncoding;
    boolean isSignalTrampoline;

    Augmentation() {
    }

    public static <R extends Reader> DwEhPe parsePointerEncoding(R input) {
        if (input == null) {
            Log.error("parsePointerEncoding input is null", new Object[0]);
            return null;
        }
        short ehPe = input.readU8();
        DwEhPe dwEhPe = new DwEhPe(ehPe);
        if (dwEhPe.isValidEncoding()) {
            return dwEhPe;
        }
        throw new RuntimeException("UnknownPointerEncoding");
    }

    public static Pointer parseEncodedPointer(DwEhPe encoding, PointerEncodingParameters parameters, Reader input) {
        long base;
        if (encoding == null) {
            throw new RuntimeException("parseEncodedPointer encoding is null");
        }
        if (!encoding.isValidEncoding()) {
            throw new RuntimeException("CannotParseOmitPointerEncoding");
        }
        if (encoding.val == 255) {
            throw new RuntimeException("CannotParseOmitPointerEncoding");
        }
        int application = encoding.application().val;
        switch (application) {
            case 0: {
                base = 0L;
                break;
            }
            case 16: {
                Long sectionBase = parameters.bases.section;
                if (sectionBase != null) {
                    Long offsetFromSection = input.offsetFrom(parameters.section);
                    base = sectionBase + offsetFromSection;
                    break;
                }
                throw new RuntimeException("PcRelativePointerButSectionBaseIsUndefined");
            }
            case 32: {
                if (parameters.bases.text != null) {
                    base = parameters.bases.text;
                    break;
                }
                Log.error("TextRelativePointerButTextBaseIsUndefined", new Object[0]);
                return null;
            }
            case 48: {
                if (parameters.bases.data != null) {
                    base = parameters.bases.data;
                    break;
                }
                Log.error("DataRelativePointerButDataBaseIsUndefined", new Object[0]);
                return null;
            }
            case 64: {
                if (parameters.funcBase != null) {
                    base = parameters.funcBase;
                    break;
                }
                Log.error("FuncRelativePointerInBadContext", new Object[0]);
                return null;
            }
            case 80: {
                Log.error("UnsupportedPointerEncoding", new Object[0]);
                return null;
            }
            default: {
                return null;
            }
        }
        long offset = 0L;
        int format = encoding.format().val;
        switch (format) {
            case 0: {
                offset = input.readAddress(parameters.addressSize);
                break;
            }
            case 1: {
                offset = input.readULeb128();
                break;
            }
            case 2: {
                offset = input.readU16();
                break;
            }
            case 3: {
                offset = input.readU32();
                break;
            }
            case 4: {
                offset = input.readU64();
                break;
            }
            case 9: {
                offset = input.readSLeb128();
                break;
            }
            case 10: {
                offset = input.readI16();
                break;
            }
            case 11: {
                offset = input.readI32();
                break;
            }
            case 12: {
                offset = input.readI64();
            }
        }
        return new Pointer(encoding, base + offset);
    }

    public static <R extends Reader> Augmentation parse(Reader augmentationString, BaseAddresses bases, short addressSize, _UnwindSectionPrivate section, Reader input) {
        Augmentation augmentation = new Augmentation();
        boolean parseFirst = false;
        Reader data = null;
        while (!augmentationString.isEmpty()) {
            char ch = (char)augmentationString.readU8();
            switch (ch) {
                case 'z': {
                    if (parseFirst) {
                        throw new RuntimeException("UnknownAugmentation");
                    }
                    long augmentationLength = input.readULeb128();
                    data = input.split(augmentationLength);
                    break;
                }
                case 'L': {
                    augmentation.lsda = Augmentation.parsePointerEncoding(data);
                    break;
                }
                case 'P': {
                    DwEhPe encoding = Augmentation.parsePointerEncoding(data);
                    PointerEncodingParameters parameters = new PointerEncodingParameters(bases.ehFrame, null, addressSize, section.section());
                    Pointer personality = Augmentation.parseEncodedPointer(encoding, parameters, data);
                    augmentation.personality = new Personality(encoding, personality);
                    break;
                }
                case 'R': {
                    augmentation.fdeAddressEncoding = Augmentation.parsePointerEncoding(data);
                    break;
                }
                case 'S': {
                    augmentation.isSignalTrampoline = true;
                    break;
                }
                default: {
                    Log.error("UnknownAugmentation", new Object[0]);
                    return null;
                }
            }
            parseFirst = true;
        }
        return augmentation;
    }
}

