/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.utils;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pe.Section;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class Utils {
    public static final long FIX_UBYTE = 255L;
    public static final long FIX_USHORT = 65535L;
    public static final long FIX_UINT = 0xFFFFFFFFL;
    private static HashMap<String, Long> recordTimes = new HashMap();
    private static HashMap<String, Long> startTimes = new HashMap();
    private static HashMap<String, Long> totalTimes = new HashMap();
    private static final String DEFAULT_RECORD_KEY = "default_record";
    private static final String ALGORITHM = "SHA1";
    private static final int ENCODE_BUFFER_SIZE = 4096;
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    public static long unsignedToLong(byte ubyte) {
        return (long)ubyte & 0xFFL;
    }

    public static long unsignedToLong(short ushort) {
        return (long)ushort & 0xFFFFL;
    }

    public static long unsignedToLong(int uint) {
        return (long)uint & 0xFFFFFFFFL;
    }

    public static void recordTime(String msg) {
        String timeKey;
        String string = timeKey = msg == null ? DEFAULT_RECORD_KEY : msg;
        if (recordTimes.containsKey(timeKey)) {
            Utils.printUsedTime(msg, recordTimes.get(timeKey), System.nanoTime());
        }
        recordTimes.put(timeKey, System.nanoTime());
    }

    public static void recordTime() {
        Utils.recordTime(null);
    }

    public static void recordBegin(String flag) {
        if (flag == null) {
            return;
        }
        startTimes.put(flag, System.nanoTime());
    }

    public static void recordEnd(String flag) {
        if (flag == null) {
            return;
        }
        if (!startTimes.containsKey(flag)) {
            return;
        }
        long totalTime = System.nanoTime() - startTimes.get(flag);
        if (totalTimes.containsKey(flag)) {
            totalTime += totalTimes.get(flag).longValue();
        }
        totalTimes.put(flag, totalTime);
    }

    public static void printRecordTime(String flag) {
        if (flag == null) {
            return;
        }
        if (!totalTimes.containsKey(flag)) {
            return;
        }
        Utils.printTotalUsedTime(flag, totalTimes.get(flag));
    }

    public static void printUsedTime(String msg, long startTime, long endTime) {
        Utils.printTotalUsedTime(msg, endTime - startTime);
    }

    public static void printTotalUsedTime(String msg, long totalTime) {
        String prmpt = "";
        prmpt = null != msg ? "<" + msg + "> time Used: " : "Time Used: ";
        Log.info(prmpt + Utils.getUsedTimeString(totalTime), new Object[0]);
    }

    public static String getUsedTimeString(long time) {
        StringBuilder stringBuilder = new StringBuilder();
        if (time > 60000000000L) {
            long min = time / 60000000000L;
            time %= 60000000000L;
            stringBuilder.append(String.valueOf(min) + "min ");
        }
        double sec = (double)time / 1.0E9;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(2);
        stringBuilder.append(numberFormat.format(sec) + "s");
        return stringBuilder.toString();
    }

    public static String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return dateFormat.format(new Date());
    }

    public static String byteArrayToHexString(byte[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b : array) {
            int n = b & 0xFF;
            if (n < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n));
        }
        return stringBuilder.toString();
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void reverseByteArray(byte[] array, int from, int to) {
        int left = from;
        for (int right = to - 1; left < right; ++left, --right) {
            byte tmp = array[left];
            array[left] = array[right];
            array[right] = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileSha1(String fileName) {
        if (null == fileName) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(fileName));
        }
        catch (FileNotFoundException e) {
            Log.error(e);
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(ALGORITHM);
            byte[] buffer = new byte[4096];
            int length = 0;
            while ((length = fileInputStream.read(buffer)) > 0) {
                messageDigest.update(buffer, 0, length);
            }
            String string = Utils.byteArrayToHexString(messageDigest.digest());
            return string;
        }
        catch (IOException e) {
            Log.error(e);
            String string = null;
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            Log.error(e);
            String string = null;
            return string;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException e) {
                Log.error(e);
            }
        }
    }

    public static String urlEncodeString(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.error(e);
            return null;
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static long findOffset(long rva, Section[] sections, long fileAliginment) {
        long offset = -1L;
        int PHYSICAL_ALIGN = 511;
        for (int i = 0; i < sections.length; ++i) {
            if (!sections[i].is_in_section(rva, fileAliginment)) continue;
            offset = rva - sections[i].virtualAddress + (sections[i].pointerToRawData & (long)(~PHYSICAL_ALIGN));
            break;
        }
        return offset;
    }
}

