/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.utils;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Log {
    public static final int DEBUG_LEVEL = 0;
    public static final int INFO_LEVEL = 1;
    public static final int WARN_LEVEL = 2;
    public static final int ERROR_LEVEL = 3;
    private static LogPrinter printer = null;
    private static final boolean isPrintDebug = false;
    private static boolean isDebug = false;
    private static boolean isEnable = false;
    public static BufferedWriter writer;
    private static Thread printThread;
    private static final Object PRINT_THREAD_LOCK;

    public static void setDebugMode(boolean debug) {
        isDebug = debug;
    }

    public static void setEnable(boolean enable) {
        isEnable = enable;
    }

    public static LogPrinter getPrinter() {
        if (printer == null) {
            printer = new DefaultLogPrinter();
        }
        return printer;
    }

    public static void setPrinter(LogPrinter printer) {
        System.setProperty("file.encoding", "UTF-8");
        Log.printer = printer;
    }

    public static String format(String format, Object ... args2) {
        if (format == null) {
            format = "";
        }
        String timeStamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
        if (args2 == null || args2.length == 0) {
            return String.format("[%s]%s", timeStamp, format);
        }
        return String.format("[%s]%s", timeStamp, String.format(Locale.US, format, args2));
    }

    private static boolean print(int level, String format, Object ... args2) {
        Log.stopBusyingLog();
        if (!isEnable) {
            return false;
        }
        LogPrinter printer = Log.getPrinter();
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String data = dataFormat.format(new Date());
        System.out.print(data + " ");
        String msg = Log.format(format, args2);
        switch (level) {
            case 0: {
                if (isDebug) {
                    printer.printDebug(msg);
                }
                return true;
            }
            case 1: {
                printer.printInfo(msg);
                return true;
            }
            case 2: {
                printer.printWarn(msg);
                return true;
            }
            case 3: {
                printer.printError(msg);
                return true;
            }
        }
        return false;
    }

    private static boolean print(int level, Throwable thr) {
        String msg = Log.parseThrowable(thr);
        return Log.print(level, msg, new Object[0]);
    }

    public static boolean info(String format, Object ... args2) {
        return Log.print(1, format, args2);
    }

    public static boolean debug(String format, Object ... args2) {
        return false;
    }

    public static boolean warn(String format, Object ... args2) {
        return Log.print(2, format, args2);
    }

    public static boolean warn(Throwable thr) {
        return Log.print(2, thr);
    }

    public static boolean error(String format, Object ... args2) {
        return Log.print(3, format, args2);
    }

    public static boolean error(Throwable thr) {
        return Log.print(3, thr);
    }

    public static String parseThrowable(Throwable thr) {
        if (thr == null) {
            return "";
        }
        try {
            StringWriter writer = new StringWriter();
            thr.printStackTrace(new PrintWriter(writer));
            return writer.getBuffer().toString();
        }
        catch (Throwable ex) {
            if (!Log.warn(ex)) {
                ex.printStackTrace();
            }
            return "fail";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printBusyingLog(String msg, final long interval) {
        if (printThread != null) {
            Log.stopBusyingLog();
        }
        Object object = PRINT_THREAD_LOCK;
        synchronized (object) {
            SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String data = dataFormat.format(new Date());
            System.out.print(data + " ");
            System.out.print(Log.getPrinter().infoTag + msg);
            printThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            Thread.sleep(interval);
                            System.out.print(".");
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            });
            printThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopBusyingLog() {
        if (printThread == null) {
            return;
        }
        Object object = PRINT_THREAD_LOCK;
        synchronized (object) {
            if (printThread == null) {
                return;
            }
            printThread.interrupt();
            if (!printThread.isInterrupted()) {
                printThread.stop();
            }
            printThread = null;
            System.out.println("");
        }
    }

    static {
        try {
            writer = new BufferedWriter(new FileWriter("log"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        printThread = null;
        PRINT_THREAD_LOCK = new Object();
    }

    private static class DefaultLogPrinter
    extends LogPrinter {
        private DefaultLogPrinter() {
        }

        @Override
        protected void setTag() {
            this.infoTag = "[I] ";
            this.debugTag = "[D] ";
            this.warnTag = "[W] ";
            this.errorTag = "[E] ";
        }
    }

    public static abstract class LogPrinter {
        public String infoTag = null;
        public String debugTag = null;
        public String warnTag = null;
        public String errorTag = null;

        public LogPrinter() {
            this.setTag();
        }

        protected abstract void setTag();

        public void printInfo(String msg) {
            if (this.infoTag != null) {
                System.out.print(this.infoTag);
            }
            System.out.println(msg);
        }

        public void printDebug(String msg) {
            if (this.debugTag != null) {
                System.out.print(this.debugTag);
            }
            System.out.println(msg);
        }

        public void printWarn(String msg) {
            if (this.warnTag != null) {
                System.out.print(this.warnTag);
            }
            System.out.println(msg);
        }

        public void printError(String msg) {
            if (this.errorTag != null) {
                System.out.print(this.errorTag);
            }
            System.out.println(msg);
        }
    }
}

