/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.upload;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.uqm.crashsight.symtabtool.common.upload.HttpClientHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import java.io.File;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SymtabFileUploader {
    public static final String CRASHSIGHT_VERSION_2X = "2.x";
    private static final String SYMBOL_UPLOAD_API_VERSION = "1";
    private static final String CRASHSIGHT_1X_WEBSITE_MANAGE = "e";
    private static final String CRASHSIGHT_2X_WEBSITE_SYMBOL = "";
    private static final String UPLOAD_URL = "";
    private static final String UPLOAD_URL_RQD = "";
    private static final String UPLOAD_OLD_URL_JAVA = "";
    private static final String UPLOAD_OLD_URL_NATIVE = "";
    private static final String UPLOAD_OLD_URL_IOS = "";
    private static final String PARAM_APP_ID = "app_id";
    private static final String PARAM_APP_KEY = "app_key";
    private static final String PARAM_API_VERSION = "api_version";
    private static final String PARAM_APP_CHANNEL = "channel";
    private static final String PARAM_APP_PACKAGE = "bundleId";
    private static final String PARAM_APP_VERSION = "productVersion";
    private static final String PARAM_SYMBOL_TYPE = "symbolType";
    private static final String PARAM_FILE_NAME = "fileName";
    private static final int MAX_UPLOAD_TIMES = 2;
    private static final long NEXT_UPLOAD_WAIT_TIME = 3000L;

    private static String getUploadUrl(UploadInfo uploadInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!uploadInfo.isRqd) {
            stringBuilder.append(uploadInfo.uploadUrl == null ? "" : uploadInfo.uploadUrl);
        } else {
            stringBuilder.append("");
        }
        stringBuilder.append("?");
        stringBuilder.append(Utils.urlEncodeString(PARAM_APP_KEY));
        stringBuilder.append("=");
        stringBuilder.append(Utils.urlEncodeString(uploadInfo.appKey));
        stringBuilder.append("&");
        stringBuilder.append(Utils.urlEncodeString(PARAM_APP_ID));
        stringBuilder.append("=");
        stringBuilder.append(Utils.urlEncodeString(uploadInfo.appId));
        return stringBuilder.toString();
    }

    private static String getOldUploadUrl(UploadInfo uploadInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        if (uploadInfo.symbolType.equals(SYMBOL_UPLOAD_API_VERSION)) {
            stringBuilder.append("");
            stringBuilder.append("?pid=1");
        } else if (uploadInfo.symbolType.equals("3")) {
            stringBuilder.append("");
            stringBuilder.append("?pid=1");
        } else if (uploadInfo.symbolType.equals("2")) {
            stringBuilder.append("");
            stringBuilder.append("?pid=2");
        }
        stringBuilder.append("&app=");
        stringBuilder.append(Utils.urlEncodeString(uploadInfo.appId));
        stringBuilder.append("&key=");
        stringBuilder.append(Utils.urlEncodeString(uploadInfo.appKey));
        stringBuilder.append("&ver=");
        stringBuilder.append(Utils.urlEncodeString(uploadInfo.appVersion));
        stringBuilder.append("&bid=");
        stringBuilder.append(Utils.urlEncodeString(uploadInfo.appPackage));
        stringBuilder.append("&n=");
        stringBuilder.append(Utils.urlEncodeString(uploadInfo.fileName));
        return stringBuilder.toString();
    }

    private static JsonObject uploadSymtabFileToCrashSight1x(UploadInfo uploadInfo) {
        String responseMessage;
        Pattern pattern;
        Matcher matcher;
        JsonObject jsonObject;
        String uploadUrl = SymtabFileUploader.getOldUploadUrl(uploadInfo);
        int type = 1;
        if (uploadInfo.symbolType.equals(SYMBOL_UPLOAD_API_VERSION)) {
            type = 0;
        }
        if ((jsonObject = HttpClientHelper.uploadFile(uploadUrl, false, uploadInfo.file, type, null)) != null && jsonObject.get("result").getAsBoolean() && (matcher = (pattern = Pattern.compile("\"ok\":([^,]*)")).matcher(responseMessage = jsonObject.get("data").getAsJsonObject().get("responseMessage").getAsString())).find() && matcher.groupCount() == 1) {
            String response = matcher.group(1);
            if (!response.equals("true")) {
                jsonObject.addProperty("result", false);
                jsonObject.addProperty("message", responseMessage);
            }
            Log.warn("Reponse from server is %s.", matcher.group(1));
        }
        return jsonObject;
    }

    private static JsonObject uploadSymtabFileToCrashSight(UploadInfo uploadInfo) {
        String uploadUrl = SymtabFileUploader.getUploadUrl(uploadInfo);
        Log.info("upload url: " + uploadUrl, new Object[0]);
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put(PARAM_API_VERSION, SYMBOL_UPLOAD_API_VERSION);
        httpHeaders.put(PARAM_APP_ID, uploadInfo.appId);
        httpHeaders.put(PARAM_APP_KEY, uploadInfo.appKey);
        httpHeaders.put(PARAM_SYMBOL_TYPE, uploadInfo.symbolType);
        httpHeaders.put(PARAM_FILE_NAME, uploadInfo.fileName);
        if (uploadInfo.appPackage != null) {
            httpHeaders.put(PARAM_APP_PACKAGE, uploadInfo.appPackage);
        }
        if (uploadInfo.appVersion != null) {
            httpHeaders.put(PARAM_APP_VERSION, uploadInfo.appVersion);
        }
        int type = 1;
        if (uploadInfo.symbolType.equals(SYMBOL_UPLOAD_API_VERSION)) {
            if (uploadInfo.appChannel != null) {
                httpHeaders.put(PARAM_APP_CHANNEL, uploadInfo.appChannel);
            }
            httpHeaders.put(PARAM_APP_VERSION, uploadInfo.appVersion);
            type = 0;
        }
        JsonObject jsonObject = HttpClientHelper.uploadFile(uploadUrl, true, uploadInfo.file, type, httpHeaders);
        Log.info("json object:%s", jsonObject.toString());
        if (jsonObject != null && jsonObject.get("result").getAsBoolean()) {
            int statusCode;
            Gson gson = new Gson();
            JsonObject jsonObject1 = gson.fromJson(jsonObject.get("data").getAsString(), JsonObject.class);
            String responseMessage = jsonObject1.get("responseMessage").getAsString();
            boolean flag = true;
            if (responseMessage.contains("\"code\":\"0\"") && (statusCode = jsonObject1.get("statusCode").getAsInt()) == 200) {
                flag = false;
            }
            if (flag) {
                jsonObject.addProperty("result", "false");
                jsonObject.addProperty("message", responseMessage);
            }
        }
        return jsonObject;
    }

    private static String getManualUploadUrl(UploadInfo uploadInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        if (uploadInfo.crashSightVersion != null && uploadInfo.crashSightVersion.equals(CRASHSIGHT_VERSION_2X)) {
            stringBuilder.append("");
            stringBuilder.append("/");
            stringBuilder.append(uploadInfo.appId);
            stringBuilder.append("?pid=");
            if (uploadInfo.symbolType.equals("2")) {
                stringBuilder.append("2");
            } else {
                stringBuilder.append(SYMBOL_UPLOAD_API_VERSION);
            }
        } else {
            stringBuilder.append(CRASHSIGHT_1X_WEBSITE_MANAGE);
            stringBuilder.append("?app=");
            stringBuilder.append(uploadInfo.appId);
            stringBuilder.append("&");
            if (uploadInfo.symbolType.equals(SYMBOL_UPLOAD_API_VERSION) || uploadInfo.symbolType.equals("3")) {
                stringBuilder.append("pid=1");
            } else if (uploadInfo.symbolType.equals("2")) {
                stringBuilder.append("pid=2");
            }
        }
        return stringBuilder.toString();
    }

    public static JsonObject uploadSymtabFile(UploadInfo uploadInfo) {
        if (!uploadInfo.validate()) {
            Log.info("Can not upload symtab file.", new Object[0]);
            return null;
        }
        Log.info("Upload symbol file: %s", uploadInfo.fileName);
        JsonObject jsonObject = null;
        for (int i = 0; i < 2; ++i) {
            if (i > 0) {
                Utils.sleep(3000L);
            }
            if ((jsonObject = SymtabFileUploader.uploadSymtabFileToCrashSight(uploadInfo)) == null || !jsonObject.get("result").getAsBoolean()) continue;
            Log.info("Successfully uploaded.", new Object[0]);
            return jsonObject;
        }
        Log.error("Failed to upload symtab file.", new Object[0]);
        return jsonObject;
    }

    public static class UploadInfo {
        public static final String SYMBOL_TYPE_JAVA = "1";
        public static final String SYMBOL_TYPE_IOS = "2";
        public static final String SYMBOL_TYPE_NATIVE = "3";
        public static final String SYMBOL_TYPE_PC = "10";
        public static final String SYMBOL_TYPE_PC_STIF = "11";
        public static final String SYMBOL_TYPE_PC_SYM = "12";
        public static final String SYMBOL_TYPE_MAPPING_JS = "30";
        public static final String SYMBOL_TYPE_PS5 = "14";
        public static final String SYMBOL_TYPE_NSS = "13";
        public String appId = null;
        public String appKey = null;
        public String appChannel = null;
        public String appPackage = null;
        public String appVersion = null;
        public String symbolType = null;
        public String fileName = null;
        public String crashSightVersion = "2.x";
        public File file = null;
        public boolean isRqd = false;
        public String uploadUrl;

        public boolean validate() {
            if (this.appId == null) {
                Log.warn("Uploading info is missing: APP ID", new Object[0]);
                return false;
            }
            if (this.appKey == null) {
                Log.warn("Uploading info is missing: APP key", new Object[0]);
                return false;
            }
            if (this.symbolType == null) {
                Log.warn("Uploading info is missing: symbol type", new Object[0]);
                return false;
            }
            if (this.file == null) {
                Log.warn("Uploading info is missing: file", new Object[0]);
                return false;
            }
            if (this.fileName == null) {
                Log.warn("Uploading info is missing: file name", new Object[0]);
                return false;
            }
            if (this.crashSightVersion != null && this.crashSightVersion.equals(SymtabFileUploader.CRASHSIGHT_VERSION_2X)) {
                if (this.symbolType.equals("1") && this.appVersion == null) {
                    Log.warn("Uploading info is missing: APP version", new Object[0]);
                    return false;
                }
                return true;
            }
            if (this.appPackage == null) {
                Log.debug("Uploading info for CrashSight 1.x is missing: APP package", new Object[0]);
                return false;
            }
            if (this.appVersion == null) {
                Log.debug("Uploading info for CrashSight 1.x is missing: APP version", new Object[0]);
                return false;
            }
            return true;
        }
    }
}

