/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.upload;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;

public class HttpClientHelper {
    public static final int FILE_TYPE_TXT = 0;
    public static final int FILE_TYPE_ZIP = 1;
    private static final int MIN_NETWORK_TIMEOUT = 20000;
    private static int connection_timeout = 300000;
    private static int socket_timeout = 300000;

    public static void setNetworkTimeout(int timeout2) {
        if (timeout2 <= 0) {
            Log.error("Timeout of network set is invalid: %d", timeout2);
            return;
        }
        if (timeout2 < 20000) {
            Log.warn("Timeout of network should be at least: %d", 20000);
            socket_timeout = 20000;
            connection_timeout = 20000;
        } else {
            Log.info("Timeout of network is set to: %d", timeout2);
            socket_timeout = timeout2;
            connection_timeout = timeout2;
        }
    }

    private static boolean isRedirect(int code) {
        return code == 301 || code == 302 || code == 303 || code == 307;
    }

    private static CloseableHttpClient getHttpClient() {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, null, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            return HttpClientBuilder.create().useSystemProperties().setSSLSocketFactory(sslsf).build();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonObject post(String url, boolean https, HttpEntity httpEntity) {
        JsonObject retJson = new JsonObject();
        retJson.addProperty("result", false);
        CloseableHttpClient httpClient = https ? HttpClientHelper.getHttpClient() : HttpClients.createSystem();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.copy(RequestConfig.custom().build()).setSocketTimeout(socket_timeout).setConnectTimeout(connection_timeout).build();
        httpPost.setConfig(requestConfig);
        httpPost.setEntity(httpEntity);
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 == statusCode || 201 == statusCode || 202 == statusCode || 204 == statusCode) {
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    retJson.addProperty("message", "Failed because HTTP entity from server is null.");
                    Log.error("Failed because HTTP entity from server is null.", new Object[0]);
                    JsonObject jsonObject = retJson;
                    return jsonObject;
                }
                StringBuilder jsonString = new StringBuilder();
                InputStream in = entity.getContent();
                int n = -1;
                byte[] tmp = new byte[1024];
                while ((n = in.read(tmp)) != -1) {
                    jsonString.append(new String(tmp, 0, n, "utf-8"));
                }
                Log.debug("Response message from server for uploading: %s", jsonString.toString());
                HttpResponseBean responseBean = new HttpResponseBean();
                responseBean.statusCode = statusCode;
                responseBean.responseMessage = jsonString.toString();
                Gson gson = new Gson();
                retJson.addProperty("result", true);
                retJson.addProperty("data", gson.toJson(responseBean));
                JsonObject jsonObject = retJson;
                return jsonObject;
            }
            if (HttpClientHelper.isRedirect(statusCode)) {
                Header headers = response.getFirstHeader("Location");
                if (headers == null) {
                    retJson.addProperty("message", "Failed to location info of headers to redirect.");
                    Log.error("Failed to location info of headers to redirect.", new Object[0]);
                    JsonObject jsonString = retJson;
                    return jsonString;
                }
                String redirectUrl = headers.getValue();
                Log.error("Connection is redirecting to %s.", redirectUrl);
                JsonObject jsonObject = HttpClientHelper.post(redirectUrl, https, httpEntity);
                return jsonObject;
            }
            retJson.addProperty("message", "Failed to execute POST");
            Log.error("Failed to execute POST for \"%s\"", response.getStatusLine());
            JsonObject jsonObject = retJson;
            return jsonObject;
        }
        catch (Exception e) {
            retJson.addProperty("result", false);
            retJson.addProperty("message", "Connection timed out! Please Check your network.");
            Log.error("Connection timed out! Please Check your network.", new Object[0]);
            JsonObject jsonObject = retJson;
            return jsonObject;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                Log.error(e);
            }
        }
    }

    private static HttpResponseBean get(String url, boolean https) {
        CloseableHttpClient httpClient = https ? HttpClientHelper.getHttpClient() : HttpClients.createDefault();
        HttpGet httpget = new HttpGet(url);
        RequestConfig requestConfig = RequestConfig.copy(RequestConfig.custom().build()).setSocketTimeout(socket_timeout).setConnectTimeout(connection_timeout).build();
        httpget.setConfig(requestConfig);
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute(httpget);
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 == statusCode || 201 == statusCode || 202 == statusCode || 204 == statusCode) {
                HttpEntity entity = response.getEntity();
                HttpResponseBean responseBean = new HttpResponseBean();
                responseBean.statusCode = statusCode;
                responseBean.httpClient = httpClient;
                responseBean.entity = entity;
                return responseBean;
            }
            if (HttpClientHelper.isRedirect(statusCode)) {
                Header headers = response.getFirstHeader("Location");
                if (headers == null) {
                    Log.error("Failed to location info of headers to redirect.", new Object[0]);
                    return null;
                }
                String redirectUrl = headers.getValue();
                Log.error("Connection is redirecting to %s.", redirectUrl);
                return HttpClientHelper.get(redirectUrl, https);
            }
            Log.error("Failed to execute POST for \"%s\"", response.getStatusLine());
            return null;
        }
        catch (ConnectTimeoutException e) {
            Log.error("Connection timed out! Please Check your network.", new Object[0]);
            return null;
        }
        catch (SocketTimeoutException e) {
            Log.error("Socket timed out! Please Check your network.", new Object[0]);
            return null;
        }
        catch (ClientProtocolException e) {
            Log.error("Failed to execute GET!", new Object[0]);
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            Log.error("Failed to execute GET!", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadString(String url, boolean https) {
        InputStream in = null;
        HttpResponseBean responseBean = HttpClientHelper.get(url, https);
        if (null == responseBean) {
            Log.error("Failed to download.", new Object[0]);
            return null;
        }
        String ret = "";
        try {
            if (responseBean.entity == null) {
                Log.error("Entity downloaded is null.", new Object[0]);
                String string = null;
                return string;
            }
            in = responseBean.entity.getContent();
            int n = -1;
            byte[] tmp = new byte[1024];
            while ((n = in.read(tmp)) != -1) {
                ret = ret + new String(tmp, 0, n, "utf-8");
            }
            String string = ret;
            return string;
        }
        catch (IOException e) {
            Log.error(e);
            String string = null;
            return string;
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
                if (responseBean.httpClient != null) {
                    responseBean.httpClient.close();
                }
            }
            catch (IOException e) {
                Log.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadFile(String url, boolean https, String fileName) {
        Log.info("Downloading the file: " + fileName, new Object[0]);
        InputStream in = null;
        FileOutputStream fout = null;
        HttpResponseBean responseBean = HttpClientHelper.get(url, https);
        if (null == responseBean) {
            Log.error("Failed to download.", new Object[0]);
            return false;
        }
        try {
            if (responseBean.entity == null) {
                Log.error("Entity downloaded is null.", new Object[0]);
                boolean bl = false;
                return bl;
            }
            in = responseBean.entity.getContent();
            fout = new FileOutputStream(new File(fileName));
            int n = -1;
            byte[] tmp = new byte[1024];
            while ((n = in.read(tmp)) != -1) {
                fout.write(tmp, 0, n);
            }
            fout.flush();
            Log.info("Successfully downloaded!", new Object[0]);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
                if (null != fout) {
                    fout.close();
                }
                if (responseBean.httpClient != null) {
                    responseBean.httpClient.close();
                }
            }
            catch (IOException e) {
                Log.error(e);
            }
        }
    }

    public static JsonObject uploadFile(String url, boolean https, File file, int fileType) {
        String mimeType = null;
        switch (fileType) {
            case 0: {
                mimeType = "text/plain";
                break;
            }
            case 1: {
                mimeType = "application/zip";
                break;
            }
            default: {
                Log.error("File type is not acceptable", new Object[0]);
                return null;
            }
        }
        FileEntity fileEntity = new FileEntity(file, ContentType.create(mimeType, Consts.UTF_8));
        return HttpClientHelper.post(url, https, fileEntity);
    }

    public static JsonObject uploadFile(String url, boolean https, File file, int fileType, Map<String, String> headers) {
        if (https) {
            ContentType contentType;
            switch (fileType) {
                case 0: {
                    contentType = ContentType.TEXT_PLAIN;
                    break;
                }
                case 1: {
                    contentType = ContentType.APPLICATION_OCTET_STREAM;
                    break;
                }
                default: {
                    Log.error("File type is not acceptable", new Object[0]);
                    return null;
                }
            }
            FileBody fileBody = new FileBody(file, contentType);
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().addPart("file", fileBody);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    Log.debug("key = %s, value = %s", entry.getKey(), entry.getValue());
                    StringBody stringBody = new StringBody(entry.getValue(), ContentType.TEXT_PLAIN);
                    entityBuilder.addPart(entry.getKey(), stringBody);
                }
            }
            Log.debug("url = %s", url);
            return HttpClientHelper.post(url, https, entityBuilder.build());
        }
        String contentType = null;
        switch (fileType) {
            case 0: {
                contentType = "text/plain";
                break;
            }
            case 1: {
                contentType = "application/zip";
                break;
            }
            default: {
                Log.error("File type is not acceptable", new Object[0]);
                return null;
            }
        }
        FileEntity fileEntity = new FileEntity(file, contentType);
        return HttpClientHelper.post(url, https, fileEntity);
    }

    public static class HttpResponseBean {
        public CloseableHttpClient httpClient = null;
        public int statusCode;
        public String responseMessage = null;
        public HttpEntity entity = null;
    }
}

