/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.file;

import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SettingFileParser {
    public static final String NOTE_PREFIX = "*";
    public static final String INPUT_FILE = "input";
    public static final String OUTPUT_FILE = "output";
    public static final String SHOULD_UPLOAD = "upload";
    public static final String IS_DEBUG = "debug";
    public static final String APP_ID = "id";
    public static final String APP_KEY = "key";
    public static final String APP_PACKAGE = "package";
    public static final String APP_CHANNEL = "channel";
    public static final String APP_VERSION = "version";
    public static final String OFFSET_ADDRESS = "offset";
    public static final String CRASHSIGHT_VERSION = "crashsight";
    public static final String DEFAULT_SETTING_FILE_NAME = "settings.txt";
    private final File file;
    private Map<String, String> settings = new HashMap<String, String>();

    private SettingFileParser(String fileName) throws Exception {
        this.file = new File(fileName);
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parse() {
        Log.info("Begin to parse configuration file: %s", this.file.getAbsolutePath());
        BufferedReader reader = FileHelper.openFileReader(this.file);
        if (reader == null) {
            Log.info("Failed to open configuration file: %s", this.file.getAbsolutePath());
            return false;
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] infos;
                if ((line = line.replaceAll("[ ]*", "")) == null || line.startsWith(NOTE_PREFIX) || (infos = line.split("[=]+")).length != 2 || infos[0].isEmpty() || infos[1].isEmpty()) continue;
                this.settings.put(infos[0].toLowerCase(), infos[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            FileHelper.closeFile(reader);
        }
        return true;
    }

    public static SettingFileParser create(String fileName) {
        SettingFileParser parser;
        if (fileName == null) {
            return null;
        }
        try {
            parser = new SettingFileParser(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (!parser.parse()) {
            return null;
        }
        return parser;
    }
}

