/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.file;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileHelper {
    private static String tempFileDirName = null;
    private static final int ZIP_BUFFER = 2048;
    public static final String ZIP_FILE_SUFFIX = ".zip";
    private static final int MERGE_BUFFER_SIZE = 4096;

    public static void setTempFileDirName(String tempFileDirName) {
        FileHelper.tempFileDirName = tempFileDirName;
    }

    public static String changeFileSuffix(String fileName, String suffix) {
        if (null == fileName || fileName.isEmpty()) {
            return fileName;
        }
        String ret = fileName;
        if (fileName.lastIndexOf(".") > 0) {
            ret = fileName.substring(0, fileName.lastIndexOf("."));
        }
        ret = ret + "." + suffix;
        return ret;
    }

    public static String changeFilePath(String fileName, String path) {
        if (null == fileName || null == path) {
            return fileName;
        }
        String ret = path + "/";
        int index = fileName.lastIndexOf("/") + 1;
        if (index < 0) {
            return path + fileName;
        }
        ret = ret + fileName.substring(index);
        return ret;
    }

    public static String getFileNameFromPath(String path) {
        return new File(path).getName();
    }

    public static Vector<File> getDirFileList(File dir) {
        if (null == dir) {
            return null;
        }
        Vector<File> ret = new Vector<File>();
        File[] tmp = dir.listFiles();
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i].isFile()) {
                ret.add(tmp[i]);
            }
            if (!tmp[i].isDirectory()) continue;
            ret.addAll(FileHelper.getDirFileList(tmp[i]));
        }
        return ret;
    }

    public static MappedByteBuffer mapSymtabIndexFile(String fileName, long position, long size) {
        try {
            RandomAccessFile fileRandomAccess = new RandomAccessFile(fileName, "rw");
            MappedByteBuffer mbb = null;
            mbb = fileRandomAccess.getChannel().map(FileChannel.MapMode.READ_WRITE, position, size);
            fileRandomAccess.close();
            return mbb;
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
    }

    public static File createTempFile(String prefix, String suffix) {
        try {
            File file = null;
            if (null != tempFileDirName) {
                File dir = new File(tempFileDirName);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                file = File.createTempFile(prefix, suffix, dir);
            } else {
                file = File.createTempFile(prefix, suffix);
            }
            file.deleteOnExit();
            return file;
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
    }

    public static boolean closeFile(RandomAccessFile randomAccessFile) {
        if (null == randomAccessFile) {
            return false;
        }
        try {
            randomAccessFile.close();
            return true;
        }
        catch (IOException e) {
            Log.error(e);
            return false;
        }
    }

    public static boolean closeFile(BufferedWriter bufferedWriter) {
        if (null == bufferedWriter) {
            return false;
        }
        try {
            bufferedWriter.flush();
            bufferedWriter.close();
            return true;
        }
        catch (IOException e) {
            Log.error(e);
            return false;
        }
    }

    public static boolean closeFile(BufferedReader bufferedReader) {
        if (null == bufferedReader) {
            return false;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException e) {
            Log.error(e);
            return false;
        }
        return true;
    }

    public static boolean closeFiles(Vector<BufferedReader> bufferedReaders) {
        for (BufferedReader bufferedReader : bufferedReaders) {
            FileHelper.closeFile(bufferedReader);
        }
        return true;
    }

    public static Vector<BufferedReader> openFiles(Vector<File> fileTable) {
        Vector<BufferedReader> brTable = new Vector<BufferedReader>();
        for (File file : fileTable) {
            BufferedReader bufferedReader = FileHelper.openFileReader(file);
            if (null == bufferedReader) {
                Log.error("Failed to open file!", new Object[0]);
                return null;
            }
            brTable.add(bufferedReader);
        }
        return brTable;
    }

    public static RandomAccessFile openRandomAccessFile(String fileName) {
        return FileHelper.openRandomAccessFile(new File(fileName));
    }

    public static RandomAccessFile openRandomAccessFile(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            RandomAccessFile fileRandomAccess = new RandomAccessFile(file, "rw");
            return fileRandomAccess;
        }
        catch (IOException e) {
            Log.error(e);
            return null;
        }
    }

    public static BufferedReader openFileReader(String fileName) {
        return FileHelper.openFileReader(new File(fileName));
    }

    public static BufferedReader openFileReader(File file) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            return br;
        }
        catch (UnsupportedEncodingException e) {
            Log.error(e);
        }
        catch (FileNotFoundException e) {
            Log.error(e);
        }
        return null;
    }

    public static BufferedWriter openFileWriter(String fileName) {
        return FileHelper.openFileWriter(new File(fileName));
    }

    public static BufferedWriter openFileWriter(File file) {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            Log.error(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipFiles(Vector<File> fileList, String zipFileName, String entryPrefix) {
        if (null == fileList || null == zipFileName) {
            return false;
        }
        byte[] buf = new byte[2048];
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFileName));
            HashSet<String> zippedEntry = new HashSet<String>();
            ZipEntry ze = null;
            int readLen = 0;
            for (int i = 0; i < fileList.size(); ++i) {
                File file = fileList.elementAt(i);
                ze = entryPrefix != null ? new ZipEntry(entryPrefix + File.separator + file.getName()) : new ZipEntry(file.getName());
                ze.setSize(file.length());
                ze.setTime(0L);
                if (!zippedEntry.contains(ze.getName())) {
                    zos.putNextEntry(ze);
                    zippedEntry.add(ze.getName());
                }
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                while ((readLen = ((InputStream)is).read(buf, 0, 2048)) != -1) {
                    zos.write(buf, 0, readLen);
                }
                ((InputStream)is).close();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    Log.error(e);
                }
            }
        }
    }

    public static boolean zipFiles(Vector<File> fileList, String zipFileName) {
        return FileHelper.zipFiles(fileList, zipFileName, null);
    }

    public static boolean zipFile(File file, String zipFileName) {
        Vector<File> fileList = new Vector<File>();
        fileList.add(file);
        return FileHelper.zipFiles(fileList, zipFileName);
    }

    public static boolean zipFile(String fileName, String zipFileName) {
        return FileHelper.zipFile(new File(fileName), zipFileName);
    }

    public static Vector<String> upZipFile(String fileName, String dirName) {
        return FileHelper.unzipFile(fileName, dirName, null);
    }

    public static Vector<String> upZipFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        return FileHelper.unzipFile(fileName, file.getParent(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<String> unzipFile(String zipFileName, String outputDirName, String suffix) {
        byte[] buf = new byte[1024];
        Vector<String> ret = new Vector<String>();
        if (!zipFileName.endsWith(ZIP_FILE_SUFFIX)) {
            Log.error("Not a zip file", new Object[0]);
            return null;
        }
        File dir = new File(outputDirName);
        if (!dir.isDirectory()) {
            Log.error("Not a directory" + outputDirName, new Object[0]);
            return null;
        }
        if (!dir.canExecute()) {
            Log.error("No right to access the directory" + outputDirName, new Object[0]);
            return null;
        }
        ZipFile zfile = null;
        try {
            zfile = new ZipFile(zipFileName);
            Enumeration<? extends ZipEntry> zList = zfile.entries();
            while (zList.hasMoreElements()) {
                ZipEntry ze = zList.nextElement();
                if (ze.isDirectory() || null != suffix && !ze.getName().endsWith(suffix)) continue;
                String path = new File(outputDirName, FileHelper.getFileNameFromPath(ze.getName())).getAbsolutePath();
                ret.add(path);
                BufferedOutputStream os = null;
                InputStream is = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(path));
                    is = new BufferedInputStream(zfile.getInputStream(ze));
                    int readLen = 0;
                    while ((readLen = is.read(buf, 0, 1024)) != -1) {
                        ((OutputStream)os).write(buf, 0, readLen);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (os == null) continue;
                    ((OutputStream)os).close();
                }
            }
            Vector<String> vector = ret;
            return vector;
        }
        catch (IOException e) {
            Log.error(e);
            Vector<String> vector = null;
            return vector;
        }
        finally {
            if (zfile != null) {
                try {
                    zfile.close();
                }
                catch (IOException e) {
                    Log.error(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean mergeFiles(File a, File b) {
        if (null == a) return false;
        if (null == b) {
            return false;
        }
        try {
            FileOutputStream outputStream2 = new FileOutputStream(a, true);
            FileInputStream inputStream2 = new FileInputStream(b);
            try {
                byte[] buffer = new byte[4096];
                int length = 0;
                while ((length = inputStream2.read(buffer)) > 0) {
                    outputStream2.write(buffer, 0, length);
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                Log.error(e);
                boolean bl2 = false;
                return bl2;
            }
            finally {
                try {
                    outputStream2.close();
                    inputStream2.close();
                }
                catch (IOException e4) {
                    Log.error(e4);
                }
            }
        }
        catch (FileNotFoundException e3) {
            Log.error(e3);
            return false;
        }
    }

    public static Vector<File> getRelativeSymtabZipFileName(String soFileName, String dirName) {
        File soFile = new File(soFileName);
        if (!soFile.exists()) {
            Log.error("File not exsist.", new Object[0]);
            return null;
        }
        String patternStr = soFile.getName().replaceAll(".so", "");
        patternStr = patternStr + ".*\\.zip";
        Pattern pattern = Pattern.compile(patternStr);
        File dir = soFile.getParentFile();
        if (null != dirName && new File(dirName).isDirectory()) {
            dir = new File(dirName);
        }
        File[] files = dir.listFiles();
        Vector<File> foundFiles = new Vector<File>();
        for (File file : files) {
            String fileName = file.getName();
            Matcher matcher = pattern.matcher(fileName);
            if (!matcher.find()) continue;
            foundFiles.add(file);
        }
        return foundFiles;
    }
}

