/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.common.file;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class BinaryFileReader {
    public static long INVALID_ENDIAN = -1L;
    public static long BIG_ENDIAN = 0L;
    public static long LITTLE_ENDIAN = 1L;
    private byte[] shortByteArray = new byte[2];
    private byte[] intByteArray = new byte[4];
    private byte[] longByteArray = new byte[8];
    private static final int LONG_BYTES_NUMBER = 8;
    private static final int INT_BYTES_NUMBER = 4;
    private static final int SHORT_BYTES_NUMBER = 2;
    private static final long FIX_UBYTE = 255L;
    private static final long FIX_USHORT = 65535L;
    private static final long FIX_UINT = 0xFFFFFFFFL;
    private long endian = LITTLE_ENDIAN;
    private String fileName = null;
    private BufferedInputStream bis = null;
    private long offset = 0L;
    private long readBytes = 0L;

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getEndian() {
        return this.endian;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getReadBytesNum() {
        return this.readBytes;
    }

    public void setEndian(long endian) {
        this.endian = endian;
    }

    public void resetReadBytes() {
        this.readBytes = 0L;
    }

    public BinaryFileReader(String fileName) throws Exception {
        this.open(fileName);
    }

    public BinaryFileReader(String fileName, long endian) throws Exception {
        this.open(fileName, endian);
    }

    private void open() throws Exception {
        if (null == this.fileName) {
            throw new Exception("File name is null!");
        }
        this.bis = new BufferedInputStream(new FileInputStream(this.fileName));
        this.offset = 0L;
        this.readBytes = 0L;
    }

    private void open(String fileName, long endian) throws Exception {
        this.setFileName(fileName);
        this.setEndian(endian);
        this.open();
    }

    private void open(String fileName) throws Exception {
        this.open(fileName, LITTLE_ENDIAN);
    }

    public boolean close() {
        try {
            if (null != this.bis) {
                this.bis.close();
            }
            this.bis = null;
            this.fileName = null;
            this.offset = 0L;
            this.readBytes = 0L;
            return true;
        }
        catch (IOException e) {
            Log.error(e);
            return false;
        }
    }

    public boolean skip(long num) {
        if (null == this.bis) {
            Log.error("Please open file first\uff01", new Object[0]);
            return false;
        }
        if (0L == num) {
            return true;
        }
        for (long numShouldSkip = num; numShouldSkip > 0L; numShouldSkip -= this.bis.skip(numShouldSkip)) {
            try {
                continue;
            }
            catch (IOException e) {
                Log.error("Failed to skip file pointer\uff01", new Object[0]);
                return false;
            }
        }
        this.offset += num;
        return true;
    }

    public boolean readByteArray(byte[] array) {
        try {
            this.bis.read(array);
        }
        catch (IOException e) {
            Log.error(e);
            return false;
        }
        this.offset += (long)array.length;
        this.readBytes += (long)array.length;
        return true;
    }

    public byte readByte() throws IOException {
        byte ret = 0;
        if (null == this.bis) {
            Log.error("Failed to skip file pointer\uff01", new Object[0]);
            return ret;
        }
        ret = (byte)this.bis.read();
        ++this.offset;
        ++this.readBytes;
        return ret;
    }

    public short readShort() throws IOException {
        short ret = 0;
        if (null == this.bis) {
            Log.error("Failed to skip file pointer\uff01", new Object[0]);
            return ret;
        }
        this.bis.read(this.shortByteArray);
        ret = BinaryFileReader.byteArrayToShort(this.shortByteArray, this.endian);
        this.offset += 2L;
        this.readBytes += 2L;
        return ret;
    }

    public int readInt() throws IOException {
        int ret = 0;
        if (null == this.bis) {
            Log.error("Failed to skip file pointer\uff01", new Object[0]);
            return ret;
        }
        this.bis.read(this.intByteArray);
        ret = BinaryFileReader.byteArrayToInt(this.intByteArray, this.endian);
        this.offset += 4L;
        this.readBytes += 4L;
        return ret;
    }

    public long readLong() throws IOException {
        long ret = 0L;
        if (null == this.bis) {
            Log.error("Failed to skip file pointer\uff01", new Object[0]);
            return ret;
        }
        this.bis.read(this.longByteArray);
        ret = BinaryFileReader.byteArrayToLong(this.longByteArray, this.endian);
        this.offset += 8L;
        this.readBytes += 8L;
        return ret;
    }

    public long readUByte() throws IOException {
        return (long)this.readByte() & 0xFFL;
    }

    public long readUShort() throws IOException {
        return (long)this.readShort() & 0xFFFFL;
    }

    public long readUInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readULong() throws IOException {
        return this.readLong();
    }

    private static short byteArrayToShortLE(byte[] ba) {
        if (null == ba || ba.length > 2) {
            return -1;
        }
        return (short)BinaryFileReader.byteArrayToIntLE(ba);
    }

    private static int byteArrayToIntLE(byte[] ba) {
        if (null == ba || ba.length > 4) {
            return -1;
        }
        return (int)BinaryFileReader.byteArrayToLongLE(ba);
    }

    private static long byteArrayToLongLE(byte[] ba) {
        if (null == ba || ba.length > 8) {
            return -1L;
        }
        long ret = 0L;
        for (int i = ba.length - 1; i >= 0; --i) {
            ret <<= 8;
            ret |= (long)ba[i] & 0xFFL;
        }
        return ret;
    }

    private static short byteArrayToShortBE(byte[] ba) {
        if (null == ba || ba.length > 2) {
            return -1;
        }
        return (short)BinaryFileReader.byteArrayToIntBE(ba);
    }

    private static int byteArrayToIntBE(byte[] ba) {
        if (null == ba || ba.length > 4) {
            return -1;
        }
        return (int)BinaryFileReader.byteArrayToLongBE(ba);
    }

    private static long byteArrayToLongBE(byte[] ba) {
        if (null == ba || ba.length > 8) {
            return -1L;
        }
        long ret = 0L;
        for (int i = 0; i < ba.length; ++i) {
            ret <<= 8;
            ret |= (long)ba[i] & 0xFFL;
        }
        return ret;
    }

    public static short byteArrayToShort(byte[] ba, long endian) {
        if (LITTLE_ENDIAN == endian) {
            return BinaryFileReader.byteArrayToShortLE(ba);
        }
        return BinaryFileReader.byteArrayToShortBE(ba);
    }

    public static int byteArrayToInt(byte[] ba, long endian) {
        if (LITTLE_ENDIAN == endian) {
            return BinaryFileReader.byteArrayToIntLE(ba);
        }
        return BinaryFileReader.byteArrayToIntBE(ba);
    }

    public static long byteArrayToLong(byte[] ba, long endian) {
        if (LITTLE_ENDIAN == endian) {
            return BinaryFileReader.byteArrayToLongLE(ba);
        }
        return BinaryFileReader.byteArrayToLongBE(ba);
    }
}

