/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser.stif;

import com.uqm.crashsight.symtabparser.common.file.FileHelper;
import com.uqm.crashsight.symtabparser.common.utils.IDemangle;
import com.uqm.crashsight.symtabparser.common.utils.Log;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFileHeader;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFileInfoBean;
import com.uqm.crashsight.symtabtool.dwarf.Leb128Parser;
import com.uqm.crashsight.symtabtool.symtab.Symbol;
import com.uqm.crashsight.symtabtool.symtab.SymbolEntry;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SymtabIndexFile {
    public static final int SYMTAB_INDEX_FILE_MAJOR_VERSION = 3;
    public static final int SYMTAB_INDEX_FILE_MINOR_VERSION = 0;
    public static final String SYMTAB_STIF_FILE_SUFFIX = "stif";
    public static final String SYMTAB_INDEX_FILE_SUFFIX = "index";
    public static final String SYMTAB_OFFSET_FILE_SUFFIX = "offset";
    public static final String SYMTAB_STR_FILE_SUFFIX = "str";
    public static final String SYMTAB_ADDRESS_FILE_SUFFIX = "address";
    public static final int BYTE_BUFFER_SIZE = 0x6400000;
    public static final int MAX_LEB128_LENGTH = 16;
    public static final int INDEX_USE_CACHE_THRESHOLD = 1048576000;
    public static long vmAddr = 0L;
    public static long pvAddr = 0L;
    public static long moduleBase = 0L;
    public static String fileType = null;
    public static Map<Integer, Integer> stringOffsetMap = new HashMap<Integer, Integer>();
    private static RandomAccessFile stifRandomAccessFile = null;
    private static File indexFile = null;
    private static RandomAccessFile indexRandomAccessFile = null;
    private static File offsetFile = null;
    private static RandomAccessFile offsetRandomAccessFile = null;
    private static File strFile = null;
    private static RandomAccessFile strRandomAccessFile = null;

    private static void fixSymbolAddr(Symbol symbol) {
        if (symbol.fixedVmAddr) {
            return;
        }
        symbol.fixedVmAddr = true;
        if (fileType.equals("ELF") || fileType.equals("LINUX_ELF")) {
            symbol.setAddress(symbol.getAddress() + vmAddr);
            symbol.setEndAddress(symbol.getEndAddress() + vmAddr);
        } else if (fileType.equalsIgnoreCase("Mach-O")) {
            symbol.setAddress(symbol.getAddress() & 0xFFFFFFFFL);
            symbol.setEndAddress(symbol.getEndAddress() & 0xFFFFFFFFL);
        }
    }

    private static FileChannel createFileChannel(String fileName, String outputDirName, String suffix) {
        if (null == fileName) {
            return null;
        }
        String newFileName = FileHelper.changeFileSuffix(new File(fileName).getName(), suffix);
        newFileName = FileHelper.changeFilePath(newFileName, outputDirName);
        switch (suffix) {
            case "stif": {
                File stifFile = new File(newFileName);
                if (stifFile.exists() && !stifFile.delete()) {
                    Log.error("Fail to delete " + newFileName, new Object[0]);
                }
                if (null == (stifRandomAccessFile = FileHelper.openRandomAccessFile(stifFile))) {
                    Log.error("Fail to open stif file", new Object[0]);
                    return null;
                }
                return stifRandomAccessFile.getChannel();
            }
            case "index": {
                indexFile = new File(newFileName);
                if (indexFile.exists() && !indexFile.delete()) {
                    Log.error("Fail to delete " + newFileName, new Object[0]);
                }
                if (null == (indexRandomAccessFile = FileHelper.openRandomAccessFile(indexFile))) {
                    Log.error("Fail to open index file", new Object[0]);
                    return null;
                }
                return indexRandomAccessFile.getChannel();
            }
            case "offset": {
                offsetFile = new File(newFileName);
                if (offsetFile.exists() && !offsetFile.delete()) {
                    Log.error("Fail to delete " + newFileName, new Object[0]);
                }
                if (null == (offsetRandomAccessFile = FileHelper.openRandomAccessFile(offsetFile))) {
                    Log.error("Fail to open offset file", new Object[0]);
                    return null;
                }
                return offsetRandomAccessFile.getChannel();
            }
            case "str": {
                strFile = new File(newFileName);
                if (strFile.exists() && !strFile.delete()) {
                    Log.error("Fail to delete " + newFileName, new Object[0]);
                }
                if (null == (strRandomAccessFile = FileHelper.openRandomAccessFile(strFile))) {
                    Log.error("Fail to open str file", new Object[0]);
                    return null;
                }
                return strRandomAccessFile.getChannel();
            }
        }
        return null;
    }

    private static File createSymtabAddressFile(String fileName, String outputDirName) {
        if (null == fileName) {
            return null;
        }
        String addressFileName = FileHelper.changeFileSuffix(new File(fileName).getName(), SYMTAB_ADDRESS_FILE_SUFFIX);
        File offsetFile = new File(addressFileName = FileHelper.changeFilePath(addressFileName, outputDirName));
        if (offsetFile.exists() && !offsetFile.delete()) {
            Log.error("Fail to delete " + addressFileName, new Object[0]);
        }
        return offsetFile;
    }

    private static boolean constructIndexHeader(SymtabIndexFileHeader header, ByteBuffer byteBuffer, long indexSize, FileChannel offsetFc, FileChannel strFc) {
        try {
            header.setIndexOffset(header.getHeaderLength());
            header.setIndexSize(indexSize);
            header.setOffsetOffset(header.getIndexOffset() + header.getIndexSize());
            header.setOffsetSize(offsetFc.position());
            header.setStrOffset(header.getOffsetOffset() + header.getOffsetSize());
            header.setStrSize(strFc.position());
            byteBuffer.putShort((short)header.getMajorVersion());
            byteBuffer.putShort((short)header.getMinorVersion());
            byteBuffer.putInt(header.getFormat());
            byteBuffer.putLong(header.getSymtabEntryNum());
            byteBuffer.putLong(vmAddr);
            byteBuffer.putLong(pvAddr);
            byteBuffer.putLong(header.getMinEntryStartAddress());
            byteBuffer.putLong(header.getMaxEntryEndAddress());
            byteBuffer.putLong(header.getMaxEntryAddressSize());
            byteBuffer.putLong(header.getIndexOffset());
            byteBuffer.putLong(header.getIndexSize());
            byteBuffer.putLong(header.getOffsetOffset());
            byteBuffer.putLong(header.getOffsetSize());
            byteBuffer.putLong(header.getStrOffset());
            byteBuffer.putLong(header.getStrSize());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void flushByteBufferToFile(FileChannel fc, ByteBuffer buffer) {
        try {
            buffer.flip();
            fc.write(buffer);
            buffer.clear();
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    private static long writeStr(FileChannel fc, ByteBuffer byteBuffer, String str) {
        long offset = -1L;
        try {
            int hashCode = str.hashCode();
            offset = stringOffsetMap.getOrDefault(hashCode, -1).intValue();
            if (offset == -1L) {
                byte[] bytes = str.getBytes();
                if (byteBuffer.remaining() < bytes.length + 1) {
                    SymtabIndexFile.flushByteBufferToFile(fc, byteBuffer);
                }
                offset = fc.position() + (long)byteBuffer.position();
                byteBuffer.put(str.getBytes());
                byteBuffer.put((byte)0);
                stringOffsetMap.put(hashCode, (int)offset);
            }
        }
        catch (Exception e) {
            Log.error(e);
        }
        return offset;
    }

    private static void writeSymbol(Symbol symbol, byte next, FileChannel offsetFc, ByteBuffer offsetByteBuffer, FileChannel strFc, ByteBuffer strByteBuffer, SymtabIndexFileHeader header) {
        try {
            for (int j = 0; j < symbol.getEntries().size(); ++j) {
                header.setMinEntryStartAddress(Long.min(header.getMinEntryStartAddress(), symbol.getAddress()));
                header.setMaxEntryEndAddress(Long.max(header.getMaxEntryEndAddress(), symbol.getEndAddress()));
                header.setMaxEntryAddressSize(Long.max(header.getMaxEntryAddressSize(), symbol.getEndAddress() - symbol.getAddress()));
                if (offsetByteBuffer.remaining() < 32) {
                    offsetByteBuffer.flip();
                    offsetFc.write(offsetByteBuffer);
                    offsetByteBuffer.clear();
                }
                byte inlineNext = 0;
                if (j == 0) {
                    inlineNext = next;
                }
                if (j < symbol.getEntries().size() - 1) {
                    inlineNext = (byte)(inlineNext | 0x80);
                }
                String p = Long.toHexString(inlineNext);
                offsetByteBuffer.put(inlineNext);
                SymbolEntry entry = symbol.getEntries().get(j);
                String oriFunction = entry.getFuncString();
                if (oriFunction.startsWith("_Z") || oriFunction.startsWith("__Z")) {
                    String ret;
                    String string = ret = IDemangle.INSTANCE != null ? IDemangle.INSTANCE.demangleCppSymbol(oriFunction) : null;
                    if (oriFunction.startsWith("__Z") && StringUtils.isEmpty(ret) && IDemangle.INSTANCE != null) {
                        ret = IDemangle.INSTANCE.demangleCppSymbol(oriFunction.substring(1));
                    }
                    if (!StringUtils.isEmpty(ret) && !oriFunction.equals(ret)) {
                        entry.setFuncString(ret);
                    }
                }
                Leb128Parser.writeUnsignedLeb128(offsetByteBuffer, SymtabIndexFile.writeStr(strFc, strByteBuffer, entry.getDirString()));
                Leb128Parser.writeUnsignedLeb128(offsetByteBuffer, SymtabIndexFile.writeStr(strFc, strByteBuffer, entry.getFileString()));
                Leb128Parser.writeUnsignedLeb128(offsetByteBuffer, SymtabIndexFile.writeStr(strFc, strByteBuffer, entry.getFuncString()));
                Leb128Parser.writeUnsignedLeb128(offsetByteBuffer, SymtabIndexFile.writeStr(strFc, strByteBuffer, entry.getLineString()));
            }
        }
        catch (Exception e) {
            Log.error("write symbol error", new Object[0]);
            Log.error(e);
        }
    }

    private static long writeIndexItem(FileChannel indexFc, ByteBuffer indexByteBuffer, boolean isIndexUseMapped, List<IndexItem> indexItems, SymtabIndexFileHeader header) {
        long indexSize = 0L;
        try {
            if (isIndexUseMapped) {
                for (IndexItem indexItem : indexItems) {
                    long offsetStart = indexItem.startAddress - header.getMinEntryStartAddress();
                    if (offsetStart > Integer.MAX_VALUE) {
                        Log.error("address[%s] offset overflow!!!", Long.toHexString(offsetStart));
                        continue;
                    }
                    indexByteBuffer.position((int)offsetStart);
                    Leb128Parser.writeUnsignedLeb128(indexByteBuffer, indexItem.offset);
                    indexByteBuffer.put((byte)0);
                }
                indexSize = indexByteBuffer.position();
            } else {
                indexByteBuffer.clear();
                for (IndexItem indexItem : indexItems) {
                    long offsetStart = indexItem.startAddress - header.getMinEntryStartAddress();
                    if (offsetStart > Integer.MAX_VALUE) {
                        Log.error("address[%s] offset overflow!!!", Long.toHexString(offsetStart));
                        continue;
                    }
                    Leb128Parser.writeUnsignedLeb128(indexByteBuffer, indexItem.offset);
                    indexByteBuffer.put((byte)0);
                    indexByteBuffer.flip();
                    indexFc.write(indexByteBuffer, offsetStart);
                    indexByteBuffer.clear();
                }
                indexSize = indexFc.size();
            }
            return indexSize;
        }
        catch (Exception e) {
            Log.error("Failed to write index items", new Object[0]);
            Log.error(e);
            return indexSize;
        }
    }

    private static boolean writeBufferToFile(FileChannel stifFc, FileChannel fc, ByteBuffer buffer) {
        try {
            fc.position(0L);
            while (fc.read(buffer) > 0) {
                buffer.flip();
                stifFc.write(buffer);
                buffer.clear();
            }
            return true;
        }
        catch (Exception e) {
            Log.error(e);
            return false;
        }
    }

    private static void saveAddress(BufferedWriter addressWriter, Symbol symbol) {
        try {
            long middleAddress = (symbol.getAddress() + symbol.getEndAddress()) / 2L;
            if (middleAddress == 5515L) {
                Log.info("", new Object[0]);
            }
            addressWriter.write(Long.toHexString(middleAddress) + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean construct(SymtabIndexFileInfoBean infoBean, SymbolTable symbolTable) {
        long beginTime = System.currentTimeMillis();
        String fileName = infoBean.getFileName();
        FileChannel stifFc = SymtabIndexFile.createFileChannel(fileName, infoBean.getOutputDirName(), SYMTAB_STIF_FILE_SUFFIX);
        FileChannel indexFc = SymtabIndexFile.createFileChannel(fileName, infoBean.getOutputDirName(), SYMTAB_INDEX_FILE_SUFFIX);
        ByteBuffer indexByteBuffer = ByteBuffer.allocate(16);
        FileChannel offsetFc = SymtabIndexFile.createFileChannel(fileName, infoBean.getOutputDirName(), SYMTAB_OFFSET_FILE_SUFFIX);
        ByteBuffer offsetByteBuffer = ByteBuffer.allocate(0x6400000);
        FileChannel strFc = SymtabIndexFile.createFileChannel(fileName, infoBean.getOutputDirName(), SYMTAB_STR_FILE_SUFFIX);
        ByteBuffer strByteBuffer = ByteBuffer.allocate(0x6400000);
        SymtabIndexFileHeader header = infoBean.getHeader();
        Log.info("Begin to construct stif file", new Object[0]);
        try {
            boolean bl;
            boolean isIndexUseMapped;
            stringOffsetMap.clear();
            ArrayList<IndexItem> indexItems = new ArrayList<IndexItem>();
            long startTime = System.currentTimeMillis();
            for (Symbol symbol : symbolTable.symbolTable) {
                if (symbol.getAddress() != 13136244L) continue;
                Log.error("", new Object[0]);
            }
            symbolTable.rewind();
            Symbol symbol = symbolTable.lastNext();
            ArrayList<Symbol> overlappedSymbols = new ArrayList<Symbol>();
            int symbolCount = 0;
            while (null != symbol) {
                Symbol overlappedSymbol;
                if (symbol.getAddress() == 13136240L) {
                    Log.error("", new Object[0]);
                }
                SymtabIndexFile.fixSymbolAddr(symbol);
                if (symbol.getAddress() <= 0L || symbol.getEndAddress() <= 0L) {
                    symbol = symbolTable.lastNext();
                    continue;
                }
                long offsetOffset = offsetFc.position() + (long)offsetByteBuffer.position();
                indexItems.add(new IndexItem(symbol.getAddress(), offsetOffset));
                indexByteBuffer.clear();
                int num = Leb128Parser.writeUnsignedLeb128(indexByteBuffer, offsetOffset);
                overlappedSymbols.clear();
                byte next = 0;
                while (null != (overlappedSymbol = symbolTable.lastNext())) {
                    if (overlappedSymbol.getAddress() == 13136244L) {
                        Log.error("", new Object[0]);
                    }
                    SymtabIndexFile.fixSymbolAddr(overlappedSymbol);
                    if (overlappedSymbol.getAddress() <= 0L || overlappedSymbol.getEndAddress() <= 0L) continue;
                    long offset = overlappedSymbol.getAddress() - symbol.getAddress();
                    if ((long)(num + 1) <= offset) break;
                    if (offset < 6L) {
                        overlappedSymbols.add(overlappedSymbol);
                        next = (byte)(next | 1 << (int)offset);
                        continue;
                    }
                    Log.info("distance of overlapped symbol's start address from symbol > 6 !!!", new Object[0]);
                }
                if (!overlappedSymbols.isEmpty()) {
                    next = (byte)(next | 0x40);
                }
                SymtabIndexFile.writeSymbol(symbol, next, offsetFc, offsetByteBuffer, strFc, strByteBuffer, header);
                if (++symbolCount % 1000000 == 0) {
                    Log.info("Symbom count %d", symbolCount);
                }
                for (Symbol overlappedSym : overlappedSymbols) {
                    next = 0;
                    next = (byte)(next | 1 << (int)(overlappedSym.getAddress() - symbol.getAddress()));
                    SymtabIndexFile.writeSymbol(overlappedSym, next, offsetFc, offsetByteBuffer, strFc, strByteBuffer, header);
                }
                symbol = overlappedSymbol;
            }
            offsetByteBuffer.flip();
            offsetFc.write(offsetByteBuffer);
            strByteBuffer.flip();
            strFc.write(strByteBuffer);
            Log.info("[Time]write string and offset cost %d[ms] string size: %d, offset size: %d", System.currentTimeMillis() - startTime, strFc.position(), offsetFc.position());
            startTime = System.currentTimeMillis();
            boolean bl2 = isIndexUseMapped = header.getMaxEntryEndAddress() < 1048576000L;
            if (isIndexUseMapped) {
                indexByteBuffer = ByteBuffer.allocate((int)(header.getMaxEntryEndAddress() - header.getMinEntryStartAddress() + 16L));
            }
            long indexSize = SymtabIndexFile.writeIndexItem(indexFc, indexByteBuffer, isIndexUseMapped, indexItems, header);
            Log.info("[Time]write index cost " + (System.currentTimeMillis() - startTime) + "ms", new Object[0]);
            offsetByteBuffer.clear();
            if (!SymtabIndexFile.constructIndexHeader(header, offsetByteBuffer, indexSize, offsetFc, strFc)) {
                Log.error("Failed to construct header of stif file", new Object[0]);
                bl = false;
                return bl;
            }
            offsetByteBuffer.flip();
            stifFc.write(offsetByteBuffer);
            offsetByteBuffer.clear();
            Log.info("indexOffset: %d indexSize: %s offsetOffset: %s offsetSize: %s strOffset: %s strSize: %d", header.getIndexOffset(), Long.toHexString(header.getIndexSize()), Long.toHexString(header.getOffsetOffset()), Long.toHexString(header.getOffsetSize()), header.getStrOffset(), header.getStrSize());
            if (isIndexUseMapped) {
                indexByteBuffer.flip();
                stifFc.write(indexByteBuffer);
            } else if (!SymtabIndexFile.writeBufferToFile(stifFc, indexFc, offsetByteBuffer)) {
                Log.info("Fail to write offset buffer", new Object[0]);
                bl = false;
                return bl;
            }
            if (!SymtabIndexFile.writeBufferToFile(stifFc, offsetFc, offsetByteBuffer)) {
                Log.info("Fail to write offset buffer", new Object[0]);
                bl = false;
                return bl;
            }
            if (!SymtabIndexFile.writeBufferToFile(stifFc, strFc, offsetByteBuffer)) {
                Log.info("Fail to write str buffer", new Object[0]);
                bl = false;
                return bl;
            }
            Log.info("Successfully constructed index file cost %d[ms]", System.currentTimeMillis() - beginTime);
            bl = true;
            return bl;
        }
        catch (IOException | RuntimeException e) {
            Log.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            FileHelper.closeFile(offsetRandomAccessFile);
            if (!offsetFile.delete()) {
                offsetFile.deleteOnExit();
            }
            FileHelper.closeFile(strRandomAccessFile);
            if (!strFile.delete()) {
                strFile.deleteOnExit();
            }
            FileHelper.closeFile(indexRandomAccessFile);
            if (!indexFile.delete()) {
                indexFile.deleteOnExit();
            }
            FileHelper.closeFile(stifRandomAccessFile);
        }
    }

    static class IndexItem {
        final long startAddress;
        final long offset;

        public IndexItem(long address, long offset) {
            this.startAddress = address;
            this.offset = offset;
        }
    }
}

