/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser.stif;

import com.uqm.crashsight.symtabparser.common.utils.Log;
import com.uqm.crashsight.symtabparser.stif.Symbol;
import com.uqm.crashsight.symtabtool.symtab.SymbolEntry;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class SymtabIndexEntry {
    private long address = 0L;
    private long endAddress = 0L;
    private String symtabString = null;
    private long strEntryOffset = 0L;
    private List<SymbolEntry> symbolEntries;

    public long getAddress() {
        return this.address;
    }

    public long getEndAddress() {
        return this.endAddress;
    }

    public String getSymtabString() {
        return this.symtabString;
    }

    private String getSymtabString(Symbol symbol) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null == symbol.getFunction()) {
            return null;
        }
        stringBuilder.append(symbol.getFunction());
        String srcLineString = symbol.getSrcLineString();
        String[] inlines = null;
        if (null != symbol.getSourceFile()) {
            if (null != symbol.getInlineFunction()) {
                inlines = symbol.getInlineFunction().split(";");
            }
            stringBuilder.append(" (");
            stringBuilder.append(srcLineString);
            if (null != inlines && inlines.length > 0) {
                stringBuilder.append(" [Inline: ");
                stringBuilder.append(inlines[0]);
                stringBuilder.append("]");
            }
            stringBuilder.append(")");
            if (null != inlines && inlines.length > 0) {
                stringBuilder.append(" (Other infos:");
                for (int i = 1; i < inlines.length; ++i) {
                    stringBuilder.append(inlines[i]);
                }
                stringBuilder.append(")");
            }
        }
        return stringBuilder.toString();
    }

    private List<SymbolEntry> getSymbolEntryList(Symbol symbol) {
        ArrayList<SymbolEntry> entries = new ArrayList<SymbolEntry>();
        if (null == symbol.getFunction()) {
            return null;
        }
        String funString = symbol.getFunction();
        String sourceFile = symbol.getSourceFile();
        String lineString = "";
        String dirString = "";
        String fileNameString = "";
        if (null != sourceFile) {
            dirString = Paths.get(sourceFile, new String[0]).toFile().getParent();
            fileNameString = Paths.get(sourceFile, new String[0]).getFileName().toString();
        }
        if (null != symbol.getLineString()) {
            lineString = symbol.getLineString();
        }
        entries.add(SymbolEntry.create(dirString, fileNameString, funString, lineString));
        if (null != symbol.getInlineFunction()) {
            String[] inlines = symbol.getInlineFunction().split(";");
            for (int i = 1; i < inlines.length; ++i) {
                String[] splits = inlines[i].split("\t");
                if (splits.length != 2) continue;
                String funcString2 = splits[0];
                String[] splits2 = splits[1].split(":");
                if (splits2.length != 2) continue;
                String sourceFile2 = splits2[0];
                String dirString2 = Paths.get(sourceFile2, new String[0]).getParent().getFileName().toString();
                String fileString2 = Paths.get(sourceFile2, new String[0]).getFileName().toString();
                String lineString2 = splits[1];
                if (funcString2 == null || lineString2 == null) continue;
                entries.add(SymbolEntry.create(dirString2, fileString2, funcString2, lineString2));
            }
        }
        return entries;
    }

    private List<SymbolEntry> getSymbolEntryList(String sourceFile, String funString, String lineString, String inlineFunction) {
        ArrayList<SymbolEntry> entries = new ArrayList<SymbolEntry>();
        String dirString = "";
        String fileNameString = "";
        if (null != sourceFile) {
            dirString = Paths.get(sourceFile, new String[0]).toFile().getParent();
            fileNameString = Paths.get(sourceFile, new String[0]).getFileName().toString();
        }
        entries.add(SymbolEntry.create(dirString, fileNameString, funString, lineString));
        if (null != inlineFunction) {
            String[] inlines = inlineFunction.split(";");
            for (int i = 1; i < inlines.length; ++i) {
                String[] splits = inlines[i].split("\t");
                if (splits.length != 2) continue;
                String funcString2 = splits[0];
                String[] splits2 = splits[1].split(":");
                if (splits2.length != 2) continue;
                String sourceFile2 = splits2[0];
                String dirString2 = Paths.get(sourceFile2, new String[0]).getParent().getFileName().toString();
                String fileString2 = Paths.get(sourceFile2, new String[0]).getFileName().toString();
                String lineString2 = splits[1];
                if (funcString2 == null || lineString2 == null) continue;
                entries.add(SymbolEntry.create(dirString2, fileString2, funcString2, lineString2));
            }
        }
        return entries;
    }

    public long getStrEntryOffset() {
        return this.strEntryOffset;
    }

    public void setAddress(long address) {
        this.address = address;
    }

    public void setEndAddress(long endAddress) {
        this.endAddress = endAddress;
    }

    public void setSymtabString(String symtabString) {
        this.symtabString = symtabString;
    }

    public void setStrEntryOffset(long strEntryOffset) {
        this.strEntryOffset = strEntryOffset;
    }

    public List<SymbolEntry> getSymbolEntries() {
        return this.symbolEntries;
    }

    public void setSymbolEntries(List<SymbolEntry> symbolEntries) {
        this.symbolEntries = symbolEntries;
    }

    private boolean getInfoFromSymbol(Symbol symbol) {
        if (null == symbol) {
            return false;
        }
        this.address = symbol.getAddress();
        this.endAddress = symbol.getEndAddress();
        this.symbolEntries = this.getSymbolEntryList(symbol);
        return this.validate();
    }

    public static SymtabIndexEntry create(String symtabEntryString) {
        SymtabIndexEntry ret = new SymtabIndexEntry();
        ret.parseString(symtabEntryString);
        if (!ret.validate()) {
            return null;
        }
        return ret;
    }

    public void parseString(String line) {
        String[] array;
        if (line.contains("\n")) {
            line = line.substring(0, line.indexOf("\n"));
        }
        if ((array = line.split("-->")).length < 2) {
            Log.error("Failed to parse the string\uff1a%s", line);
            return;
        }
        String[] addresses = array[0].split("\t");
        this.address = Long.parseLong(addresses[0], 16);
        this.endAddress = Long.parseLong(addresses[1], 16);
        this.symbolEntries = new ArrayList<SymbolEntry>();
        for (int i = 1; i < array.length; ++i) {
            String[] funcFileLines = array[i].split("->");
            if (funcFileLines.length == 3) {
                String filePath = funcFileLines[1];
                String dirString = Paths.get(filePath, new String[0]).toFile().getParent();
                String fileName = Paths.get(filePath, new String[0]).getFileName().toString();
                this.symbolEntries.add(SymbolEntry.create(dirString, fileName, funcFileLines[0], funcFileLines[2]));
                continue;
            }
            if (funcFileLines.length != 1) continue;
            this.symbolEntries.add(SymbolEntry.create("", "", funcFileLines[0], ""));
        }
    }

    private boolean validate() {
        if (this.address < 0L) {
            return false;
        }
        if (this.endAddress < 0L) {
            return false;
        }
        return null != this.symbolEntries && !this.symbolEntries.isEmpty();
    }
}

