/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser.stif;

import com.uqm.crashsight.symtabparser.common.utils.Log;

public class Symbol {
    private long address = -1L;
    private long endAddress = 0L;
    private String function = null;
    private String sourceFile = null;
    private long sourceline = -1L;
    private long sourceEndLine = -1L;
    private String inlineFunction = null;
    private String inlineSourceFile = null;
    private long inlineSourceLine = -1L;
    public static final String SEPARATOR = "\t";
    public static final String NO_FUNCTION = "NoFunction";

    public boolean isCompelte() {
        return null != this.function;
    }

    public long getAddress() {
        return this.address;
    }

    public long getEndAddress() {
        return this.endAddress;
    }

    public String getFunction() {
        return this.function;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public long getSourceLine() {
        return this.sourceline;
    }

    public long getSourceEndLine() {
        return this.sourceEndLine;
    }

    public String getInlineFunction() {
        return this.inlineFunction;
    }

    public String getInlineSourceFile() {
        return this.inlineSourceFile;
    }

    public long getInlineSourceLine() {
        return this.inlineSourceLine;
    }

    public void setInlineFunction(String inlineFunction) {
        this.inlineFunction = inlineFunction;
    }

    public void setInlineSourceFile(String inlineSourceFile) {
        this.inlineSourceFile = inlineSourceFile;
    }

    public void setInlineSourceLine(long inlineSourceLine) {
        this.inlineSourceLine = inlineSourceLine;
    }

    public void setAddress(long address) {
        if (address == 51460L) {
            this.address = address;
        }
        this.address = address;
    }

    public void setEndAddress(long endAddress) {
        this.endAddress = endAddress;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void setSourceFile(String srcFile) {
        this.sourceFile = srcFile;
    }

    public void setSourceLine(long line) {
        this.sourceline = line;
    }

    public void setSourceEndLine(long endLine) {
        this.sourceEndLine = endLine;
    }

    public Symbol parseString(String line) {
        if (line.contains("\n")) {
            line = line.substring(0, line.indexOf("\n"));
        }
        String[] array = line.split(SEPARATOR);
        String[] extraFunctions = line.split(";");
        if (array.length < 3) {
            Log.error("Failed to parse the string\uff1a%s", line);
            return null;
        }
        this.address = Long.parseLong(array[0], 16);
        this.endAddress = Long.parseLong(array[1], 16);
        this.function = array[2];
        if (this.function.equals(NO_FUNCTION)) {
            this.function = "unknown";
        }
        if (array.length > 3) {
            int index = array[3].lastIndexOf(":");
            if (-1 == index) {
                Log.error("Failed to parse the string\uff1a%s", line);
                return null;
            }
            this.sourceFile = array[3].substring(0, index);
            String[] lineInfo = array[3].substring(index + 1).split("-");
            if (lineInfo[0].isEmpty()) {
                this.sourceline = -1L * Long.parseLong(lineInfo[1]);
            } else {
                this.sourceline = Long.parseLong(lineInfo[0]);
                if (lineInfo.length > 1) {
                    this.sourceEndLine = Long.parseLong(lineInfo[1]);
                }
            }
            if (array.length > 4) {
                this.inlineFunction = array[4] + ";";
                for (int i = 1; i < extraFunctions.length; ++i) {
                    this.inlineFunction = this.inlineFunction + extraFunctions[i] + ";";
                }
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (-1L == this.address) {
            Log.error("The symbol has no address!", new Object[0]);
            return null;
        }
        stringBuilder.append(Long.toHexString(this.address));
        stringBuilder.append(SEPARATOR);
        stringBuilder.append(Long.toHexString(this.endAddress));
        stringBuilder.append(SEPARATOR);
        if (null != this.function) {
            stringBuilder.append(this.function);
        } else {
            stringBuilder.append(NO_FUNCTION);
        }
        if (null != this.sourceFile) {
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(this.getSrcLineString());
            if (null != this.inlineFunction) {
                stringBuilder.append(SEPARATOR);
                stringBuilder.append(this.inlineFunction);
            }
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String getSrcLineString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != this.sourceFile) {
            stringBuilder.append(this.sourceFile);
            stringBuilder.append(":");
            stringBuilder.append(this.sourceline);
            if (-1L != this.sourceEndLine) {
                stringBuilder.append("-");
                stringBuilder.append(this.sourceEndLine);
            }
        }
        return stringBuilder.toString();
    }

    public String getLineString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.sourceline);
        if (-1L != this.sourceEndLine) {
            stringBuilder.append("-");
            stringBuilder.append(this.sourceEndLine);
        }
        return stringBuilder.toString();
    }

    public boolean contain(Symbol symbol) {
        return symbol.address >= this.address && symbol.endAddress <= this.endAddress;
    }

    public boolean contain(long address) {
        return address >= this.address && address < this.endAddress;
    }

    public boolean equals(Symbol symbol) {
        if (symbol.address != symbol.address) {
            return false;
        }
        if (!symbol.sourceFile.equals(this.sourceFile)) {
            return false;
        }
        if (symbol.sourceline != this.sourceline) {
            return false;
        }
        return symbol.sourceEndLine == this.sourceEndLine;
    }
}

