/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser.common.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public class Log {
    public static final int INFO_LEVEL = 0;
    public static final int DEBUG_LEVEL = 1;
    public static final int WARN_LEVEL = 2;
    public static final int ERROR_LEVEL = 3;
    private static LogPrinter printer = null;
    private static final boolean isPrintDebug = true;

    public static LogPrinter getPrinter() {
        return printer;
    }

    public static void setPrinter(LogPrinter printer) {
        System.setProperty("file.encoding", "UTF-8");
        Log.printer = printer;
    }

    private static String format(String format, Object ... args2) {
        if (format == null) {
            return "null";
        }
        if (args2 == null || args2.length == 0) {
            return format;
        }
        return String.format(Locale.US, format, args2);
    }

    private static boolean print(int level, String format, Object ... args2) {
        String msg = Log.format(format, args2);
        LogPrinter printer = Log.getPrinter();
        if (printer == null) {
            printer = new DefaultLogPrinter();
        }
        switch (level) {
            case 0: {
                printer.printInfo(msg);
                return true;
            }
            case 1: {
                printer.printDebug(msg);
                return true;
            }
            case 2: {
                printer.printWarn(msg);
                return true;
            }
            case 3: {
                printer.printError(msg);
                return true;
            }
        }
        return false;
    }

    private static boolean print(int level, Throwable thr) {
        String msg = Log.parseThrowable(thr);
        LogPrinter printer = Log.getPrinter();
        if (printer == null) {
            printer = new DefaultLogPrinter();
        }
        switch (level) {
            case 0: {
                printer.printInfo(msg);
                return true;
            }
            case 1: {
                printer.printDebug(msg);
                return true;
            }
            case 2: {
                printer.printWarn(msg);
                return true;
            }
            case 3: {
                printer.printError(msg);
                return true;
            }
        }
        return false;
    }

    public static boolean info(String format, Object ... args2) {
        return Log.print(0, format, args2);
    }

    public static boolean debug(String format, Object ... args2) {
        return Log.print(1, format, args2);
    }

    public static boolean warn(String format, Object ... args2) {
        return Log.print(2, format, args2);
    }

    public static boolean warn(Throwable thr) {
        return Log.print(2, thr);
    }

    public static boolean error(String format, Object ... args2) {
        return Log.print(3, format, args2);
    }

    public static boolean error(Throwable thr) {
        return Log.print(3, thr);
    }

    public static String parseThrowable(Throwable thr) {
        if (thr == null) {
            return "";
        }
        try {
            StringWriter writer = new StringWriter();
            thr.printStackTrace(new PrintWriter(writer));
            return writer.getBuffer().toString();
        }
        catch (Throwable e) {
            if (!Log.warn(e)) {
                e.printStackTrace();
            }
            return "fail";
        }
    }

    private static class DefaultLogPrinter
    implements LogPrinter {
        private DefaultLogPrinter() {
        }

        @Override
        public void printInfo(String msg) {
            System.out.print("[I]");
            System.out.println(msg);
        }

        @Override
        public void printDebug(String msg) {
            System.out.print("[D]");
            System.out.println(msg);
        }

        @Override
        public void printWarn(String msg) {
            System.out.print("[W]");
            System.out.println(msg);
        }

        @Override
        public void printError(String msg) {
            System.out.print("[E]");
            System.out.println(msg);
        }
    }

    public static interface LogPrinter {
        public void printInfo(String var1);

        public void printDebug(String var1);

        public void printWarn(String var1);

        public void printError(String var1);
    }
}

