/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser.common.utils;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.uqm.crashsight.symtabparser.common.utils.IDemangle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.springframework.core.io.ClassPathResource;

public class DemangleFactory {
    public static IDemangle createLibrary() {
        ClassPathResource resource = null;
        String originalFilename = null;
        if (Platform.isWindows()) {
            resource = new ClassPathResource("demangle.dll");
            originalFilename = "demangle.dll";
        } else if (Platform.isLinux()) {
            resource = new ClassPathResource("demangle.so");
            originalFilename = "demangle.so";
        }
        if (resource == null) {
            return null;
        }
        try {
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            File tempFile = new File(tempDir, originalFilename);
            Files.copy(resource.getInputStream(), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            NativeLibrary.addSearchPath(originalFilename, tempDir.getCanonicalPath());
            return Native.loadLibrary(originalFilename, IDemangle.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

