/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser;

import com.uqm.crashsight.symtabparser.ArgsParser;
import com.uqm.crashsight.symtabparser.SymtabFileInfoParser;
import com.uqm.crashsight.symtabparser.common.file.FileHelper;
import com.uqm.crashsight.symtabparser.common.utils.Log;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFile;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFileInfoBean;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import java.io.File;
import java.util.Vector;

public class SymtabFileParser {
    private static final String SYMTAB_FILE_DEFAULT_VERSION = "1.2";
    private static final String SYMTAB_FILE_SUFFIX = ".symbol";
    private static final String SYMTAB_FILE_SUFFIX2 = ".sym";

    private static boolean checkPara(String fileName, String outputDirName) {
        File file = new File(fileName);
        File dir = new File(outputDirName);
        if (!file.isFile()) {
            Log.error("The input is not file\uff1a" + fileName, new Object[0]);
            return false;
        }
        if (!fileName.endsWith(SYMTAB_FILE_SUFFIX) && !fileName.endsWith(SYMTAB_FILE_SUFFIX2)) {
            Log.error("The input is not symtab file: " + fileName, new Object[0]);
            return false;
        }
        if (!dir.isDirectory()) {
            Log.error("The output specified is not directory: " + outputDirName, new Object[0]);
            return false;
        }
        return true;
    }

    private static int getSymtabFileFormat(SymtabFileInfoParser infoParser) {
        int ret = -1;
        String format = infoParser.getInfo("Format");
        if (null == format) {
            return ret;
        }
        String symtabFileFormat = format;
        int index = format.indexOf("/");
        if (index >= 0) {
            symtabFileFormat = format.substring(index + 1);
        }
        if ((index = symtabFileFormat.indexOf("-")) < 0) {
            return ret;
        }
        symtabFileFormat = symtabFileFormat.substring(0, index);
        try {
            ret = Integer.parseInt(symtabFileFormat);
        }
        catch (NumberFormatException e) {
            Log.error(e);
            return ret;
        }
        return ret;
    }

    private static String getSymtabFileVersion(SymtabFileInfoParser infoParser) {
        String version = infoParser.getInfo("File Version");
        if (null == version) {
            version = SYMTAB_FILE_DEFAULT_VERSION;
        }
        if (!version.contains(".")) {
            return null;
        }
        return version;
    }

    private static int parseMajorVersion(String version) {
        try {
            return Integer.parseInt(version.substring(0, version.indexOf(".")));
        }
        catch (NumberFormatException e) {
            Log.error(e);
            return -1;
        }
    }

    private static int parseMinorVersion(String version) {
        try {
            return Integer.parseInt(version.substring(version.indexOf(".") + 1));
        }
        catch (NumberFormatException e) {
            Log.error(e);
            return -1;
        }
    }

    private static SymtabIndexFileInfoBean getSymtabFileInfoBean(SymtabFileInfoParser infoParser, String outputDirName) {
        SymtabIndexFileInfoBean infoBean = new SymtabIndexFileInfoBean();
        infoBean.setFileName(infoParser.getFileName());
        infoBean.setOutputDirName(outputDirName);
        infoBean.setHeaderInfoLineCount(infoParser.getHeaderInfoLineCount());
        infoBean.setSymtabEntryNum(infoParser.getSymbolNumbers());
        infoBean.setPvaddr(Long.parseLong(infoParser.getInfo("Program Virtual Address")));
        infoBean.setPoffset(Long.parseLong(infoParser.getInfo("Program Offset")));
        int symtabFileFormat = SymtabFileParser.getSymtabFileFormat(infoParser);
        if (symtabFileFormat < 0) {
            Log.error("The format of the symtab file is wrong", new Object[0]);
            return null;
        }
        infoBean.setFormat(symtabFileFormat);
        return infoBean;
    }

    private static boolean constructSymtabIndexFile(SymtabFileInfoParser infoParser, String outputDirName, SymbolTable symbolTable) {
        String version = SymtabFileParser.getSymtabFileVersion(infoParser);
        if (null == version) {
            Log.error("The version of the symtab file is wrong", new Object[0]);
        }
        assert (version != null);
        int majorVersion = SymtabFileParser.parseMajorVersion(version);
        SymtabIndexFileInfoBean infoBean = null;
        switch (majorVersion) {
            case 1: {
                Log.info("The major version of the symtab file is 1.", new Object[0]);
                infoBean = SymtabFileParser.getSymtabFileInfoBean(infoParser, outputDirName);
                assert (infoBean != null);
                return SymtabIndexFile.construct(infoBean, symbolTable);
            }
            case 2: 
            case 3: {
                Log.info("The major version of the symtab file is 2.", new Object[0]);
                infoBean = SymtabFileParser.getSymtabFileInfoBean(infoParser, outputDirName);
                assert (infoBean != null);
                return SymtabIndexFile.construct(infoBean, symbolTable);
            }
        }
        Log.error("The major version of the symtab file is wrong", new Object[0]);
        return false;
    }

    private static boolean parseSymtabFile(String fileName, String outputDirName, SymbolTable symbolTable) {
        if (!SymtabFileParser.checkPara(fileName, outputDirName)) {
            return false;
        }
        SymtabFileInfoParser infoParser = SymtabFileInfoParser.create(fileName);
        if (null == infoParser) {
            return false;
        }
        if (!SymtabFileParser.constructSymtabIndexFile(infoParser, outputDirName, symbolTable)) {
            Log.error("Failed to construct stif file", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean parseSymtabZipFile(String zipFileName, String outputDirName) {
        int i;
        if (null == zipFileName) {
            return false;
        }
        Log.info("Begin to unzip file: " + zipFileName, new Object[0]);
        Vector<String> fileList = FileHelper.unzipFile(zipFileName, outputDirName, SYMTAB_FILE_SUFFIX);
        if (null == fileList) {
            return false;
        }
        Log.info("Successfully unzipped, file list: ", new Object[0]);
        for (i = 0; i < fileList.size(); ++i) {
            Log.info("[" + i + "] " + fileList.elementAt(i), new Object[0]);
        }
        for (i = 0; i < fileList.size(); ++i) {
            String fileName = fileList.elementAt(i);
            if (SymtabFileParser.parseSymtabFile(fileName, outputDirName, null)) continue;
            return false;
        }
        return true;
    }

    public static boolean parseFile(String fileName, String outputDirName, SymbolTable symbolTable) {
        if (null == fileName) {
            return false;
        }
        if (fileName.endsWith(".zip")) {
            return SymtabFileParser.parseSymtabZipFile(fileName, outputDirName);
        }
        return SymtabFileParser.parseSymtabFile(fileName, outputDirName, symbolTable);
    }

    public static boolean parseIosSysSymtabFile(String fileName, String outputDirName) {
        return SymtabFileParser.parseSymtabFile(fileName, outputDirName, null);
    }

    public static boolean parseIosSysFolder(String folderName) {
        boolean ret = false;
        if (null == folderName) {
            return false;
        }
        File folder = new File(folderName);
        if (folder.exists() && folder.isDirectory()) {
            File[] subs;
            for (File sub : subs = folder.listFiles()) {
                if (!sub.isFile() || !sub.getName().endsWith(SYMTAB_FILE_SUFFIX2)) continue;
                SymtabFileParser.parseIosSysSymtabFile(sub.getAbsolutePath(), folderName);
            }
        } else {
            Log.error("No folder or is not dir", new Object[0]);
        }
        return ret;
    }

    public static boolean parseIosSysFolders(String folderName) {
        boolean ret = false;
        if (null == folderName) {
            return false;
        }
        File folder = new File(folderName);
        if (folder.exists() && folder.isDirectory()) {
            File[] subs;
            for (File sub : subs = folder.listFiles()) {
                if (sub.isDirectory()) {
                    SymtabFileParser.parseIosSysFolder(sub.getAbsolutePath());
                    continue;
                }
                Log.error("Folder is invalid " + folderName + " " + sub.getAbsolutePath(), new Object[0]);
            }
        } else {
            Log.error("No folder or is not dir", new Object[0]);
        }
        return ret;
    }

    public static void main(String[] args2) {
        ArgsParser argsParser = ArgsParser.create(args2);
        if (null == argsParser) {
            return;
        }
        String symbolFileName = argsParser.getFileName();
        String outputDirName = argsParser.getOutputDirName();
        if (null == outputDirName) {
            outputDirName = new File(symbolFileName).getParent();
        }
        SymtabFileParser.parseFile(symbolFileName, outputDirName, null);
    }
}

