/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabparser;

import com.uqm.crashsight.symtabparser.common.file.FileHelper;
import com.uqm.crashsight.symtabparser.common.utils.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class SymtabFileInfoParser {
    public static final String FILE_KEY = "File";
    public static final String FORMAT_KEY = "Format";
    public static final String ARCH_KEY = "Arch";
    public static final String APP_ID_KEY = "AppID";
    public static final String APP_VERSION_KEY = "AppVer";
    public static final String SYMBOLS_KEY = "Symbols";
    public static final String TOOL_VERSION_KEY = "Tool Version";
    public static final String FILE_VERSION_KEY = "File Version";
    public static final String BUILT_TIME_KEY = "Built Time";
    public static final String UUID_KEY = "UUID";
    public static final String SHA1_KEY = "SHA-1";
    public static final String P_VADDR = "Program Virtual Address";
    public static final String P_OFFSET = "Program Offset";
    private static final String SYMTAB_LABEL = "Symbol table";
    private static final String SYMTAB_DECOLLATOR = "\t";
    private static final int SYMBOL_MIN_LENGTH = 6;
    private String fileName = null;
    private HashMap<String, String> symtabHeaderInfos = null;
    private long symbolNumbers = 0L;
    private int headerLineCount = 0;

    private SymtabFileInfoParser() {
    }

    public String getFileName() {
        return this.fileName;
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getSymbolNumbers() {
        return this.symbolNumbers;
    }

    public int getHeaderInfoLineCount() {
        return this.headerLineCount;
    }

    public String getInfo(String key) {
        if (null == this.symtabHeaderInfos) {
            return null;
        }
        return this.symtabHeaderInfos.get(key);
    }

    private boolean validate() {
        return this.symtabHeaderInfos.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parse(String fileName) {
        if (null == fileName) {
            return false;
        }
        this.setFileName(fileName);
        BufferedReader bufferedReader = FileHelper.openFileReader(new File(fileName));
        if (null == bufferedReader) {
            return false;
        }
        this.symtabHeaderInfos = new HashMap();
        String line = null;
        try {
            while (null != (line = bufferedReader.readLine())) {
                if (line.contains(SYMTAB_LABEL)) {
                    line = bufferedReader.readLine();
                    ++this.headerLineCount;
                    break;
                }
                String[] strings = line.split(SYMTAB_DECOLLATOR);
                if (strings.length <= 1) {
                    boolean bl = false;
                    return bl;
                }
                if (strings.length > 2) break;
                String key = strings[0].substring(0, strings[0].length() - 1);
                this.symtabHeaderInfos.put(key, strings[1]);
                ++this.headerLineCount;
            }
            boolean strings = this.validate();
            return strings;
        }
        catch (IOException e) {
            Log.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            FileHelper.closeFile(bufferedReader);
        }
    }

    public static SymtabFileInfoParser create(String fileName) {
        SymtabFileInfoParser parser = new SymtabFileInfoParser();
        if (!fileName.endsWith(".symbol")) {
            Log.warn("Not a symbol file!", new Object[0]);
            return null;
        }
        Log.info("Begin to parse the file\uff1a%s", fileName);
        if (!parser.parse(fileName)) {
            Log.error("Failed to parse the file", new Object[0]);
            return null;
        }
        Log.info("Successfully parsed the file", new Object[0]);
        return parser;
    }
}

