/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.COSEncryptionClient;
import com.qcloud.cos.event.COSProgressPublisher;
import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.internal.UploadPartRequestFactory;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.EncryptedInitiateMultipartUploadRequest;
import com.qcloud.cos.model.EncryptedPutObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.ListPartsRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.PartSummary;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.transfer.PersistableUpload;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.TransferManagerUtils;
import com.qcloud.cos.transfer.TransferProgress;
import com.qcloud.cos.transfer.UploadImpl;
import com.qcloud.cos.transfer.UploadPartCallable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadCallable
implements Callable<UploadResult> {
    private final COS cos;
    private final ExecutorService threadPool;
    private final PutObjectRequest origReq;
    private String multipartUploadId;
    private final UploadImpl upload;
    private static final Logger log = LoggerFactory.getLogger(UploadCallable.class);
    private final TransferManagerConfiguration configuration;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private final ProgressListenerChain listener;
    private final TransferProgress transferProgress;
    private final List<PartETag> eTagsToSkip = new ArrayList<PartETag>();
    private PersistableUpload persistableUpload;

    public UploadCallable(TransferManager transferManager, ExecutorService threadPool, UploadImpl upload, PutObjectRequest origReq, ProgressListenerChain progressListenerChain, String uploadId, TransferProgress transferProgress) {
        this.cos = transferManager.getCOSClient();
        this.configuration = transferManager.getConfiguration();
        this.threadPool = threadPool;
        this.origReq = origReq;
        this.listener = progressListenerChain;
        this.upload = upload;
        this.multipartUploadId = uploadId;
        this.transferProgress = transferProgress;
    }

    List<Future<PartETag>> getFutures() {
        return this.futures;
    }

    List<PartETag> getETags() {
        return this.eTagsToSkip;
    }

    String getMultipartUploadId() {
        return this.multipartUploadId;
    }

    public boolean isMultipartUpload() {
        return TransferManagerUtils.shouldUseMultipartUpload(this.origReq, this.configuration);
    }

    @Override
    public UploadResult call() throws Exception {
        this.upload.setState(Transfer.TransferState.InProgress);
        if (this.isMultipartUpload()) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_STARTED_EVENT);
            return this.uploadInParts();
        }
        return this.uploadInOneChunk();
    }

    private UploadResult uploadInOneChunk() {
        PutObjectResult putObjectResult = this.cos.putObject(this.origReq);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(this.origReq.getBucketName());
        uploadResult.setKey(this.origReq.getKey());
        uploadResult.setETag(putObjectResult.getETag());
        uploadResult.setVersionId(putObjectResult.getVersionId());
        uploadResult.setRequestId(putObjectResult.getRequestId());
        uploadResult.setDateStr(putObjectResult.getDateStr());
        uploadResult.setCrc64Ecma(putObjectResult.getCrc64Ecma());
        uploadResult.setCiUploadResult(putObjectResult.getCiUploadResult());
        return uploadResult;
    }

    private void captureUploadStateIfPossible() {
        if (this.origReq.getSSECustomerKey() == null) {
            this.persistableUpload = new PersistableUpload(this.origReq.getBucketName(), this.origReq.getKey(), this.origReq.getFile().getAbsolutePath(), this.multipartUploadId, this.configuration.getMinimumUploadPartSize(), this.configuration.getMultipartUploadThreshold());
            this.notifyPersistableTransferAvailability();
        }
    }

    public PersistableUpload getPersistableUpload() {
        return this.persistableUpload;
    }

    private void notifyPersistableTransferAvailability() {
        COSProgressPublisher.publishTransferPersistable(this.listener, this.persistableUpload);
    }

    private UploadResult uploadInParts() throws Exception {
        boolean isUsingEncryption = this.cos instanceof COSEncryptionClient;
        long optimalPartSize = this.getOptimalPartSize(isUsingEncryption);
        try {
            if (this.multipartUploadId == null) {
                this.multipartUploadId = this.initiateMultipartUpload(this.origReq, isUsingEncryption, optimalPartSize);
            }
            UploadPartRequestFactory requestFactory = new UploadPartRequestFactory(this.origReq, this.multipartUploadId, optimalPartSize);
            if (TransferManagerUtils.isUploadParallelizable(this.origReq, isUsingEncryption)) {
                this.captureUploadStateIfPossible();
                this.uploadPartsInParallel(requestFactory, this.multipartUploadId);
                UploadResult uploadResult = null;
                return uploadResult;
            }
            UploadResult uploadResult = this.uploadPartsInSeries(requestFactory);
            return uploadResult;
        }
        catch (Exception e) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            this.performAbortMultipartUpload();
            throw e;
        }
        finally {
            if (this.origReq.getInputStream() != null) {
                try {
                    this.origReq.getInputStream().close();
                }
                catch (Exception e) {
                    log.warn("Unable to cleanly close input stream: " + e.getMessage(), e);
                }
            }
        }
    }

    void performAbortMultipartUpload() {
        try {
            if (this.multipartUploadId != null) {
                AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(this.origReq.getBucketName(), this.origReq.getKey(), this.multipartUploadId);
                TransferManagerUtils.populateEndpointAddr(this.origReq, abortMultipartUploadRequest);
                this.cos.abortMultipartUpload(abortMultipartUploadRequest);
            }
        }
        catch (Exception e2) {
            log.info("Unable to abort multipart upload, you may need to manually remove uploaded parts: " + e2.getMessage(), e2);
        }
    }

    private long getOptimalPartSize(boolean isUsingEncryption) {
        long optimalPartSize = TransferManagerUtils.calculateOptimalPartSize(this.origReq, this.configuration);
        if (isUsingEncryption && optimalPartSize % 32L > 0L) {
            optimalPartSize = optimalPartSize - optimalPartSize % 32L + 32L;
        }
        log.debug("Calculated optimal part size: " + optimalPartSize);
        return optimalPartSize;
    }

    private UploadResult uploadPartsInSeries(UploadPartRequestFactory requestFactory) {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        while (requestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            UploadPartRequest uploadPartRequest = requestFactory.getNextUploadPartRequest();
            InputStream inputStream2 = uploadPartRequest.getInputStream();
            if (inputStream2 != null && inputStream2.markSupported()) {
                if (uploadPartRequest.getPartSize() >= Integer.MAX_VALUE) {
                    inputStream2.mark(Integer.MAX_VALUE);
                } else {
                    inputStream2.mark((int)uploadPartRequest.getPartSize());
                }
            }
            partETags.add(this.cos.uploadPart(uploadPartRequest).getPartETag());
        }
        CompleteMultipartUploadRequest req = (CompleteMultipartUploadRequest)new CompleteMultipartUploadRequest(this.origReq.getBucketName(), this.origReq.getKey(), this.multipartUploadId, partETags).withGeneralProgressListener(this.origReq.getGeneralProgressListener());
        ObjectMetadata origMeta = this.origReq.getMetadata();
        if (origMeta != null) {
            ObjectMetadata objMeta = req.getObjectMetadata();
            if (objMeta == null) {
                objMeta = new ObjectMetadata();
            }
            objMeta.setUserMetadata(origMeta.getUserMetadata());
            req.setObjectMetadata(objMeta);
        }
        if (this.origReq.getPicOperations() != null) {
            req.setPicOperations(this.origReq.getPicOperations());
        }
        TransferManagerUtils.populateEndpointAddr(this.origReq, req);
        CompleteMultipartUploadResult res = this.cos.completeMultipartUpload(req);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(res.getBucketName());
        uploadResult.setKey(res.getKey());
        uploadResult.setETag(res.getETag());
        uploadResult.setVersionId(res.getVersionId());
        uploadResult.setRequestId(res.getRequestId());
        uploadResult.setDateStr(res.getDateStr());
        uploadResult.setCrc64Ecma(res.getCrc64Ecma());
        uploadResult.setCiUploadResult(res.getCiUploadResult());
        return uploadResult;
    }

    private void uploadPartsInParallel(UploadPartRequestFactory requestFactory, String uploadId) {
        Map<Integer, PartSummary> partNumbers = this.identifyExistingPartsForResume(uploadId);
        while (requestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            UploadPartRequest request = requestFactory.getNextUploadPartRequest();
            if (partNumbers.containsKey(request.getPartNumber())) {
                PartSummary summary = partNumbers.get(request.getPartNumber());
                this.eTagsToSkip.add(new PartETag(request.getPartNumber(), summary.getETag()));
                this.transferProgress.updateProgress(summary.getSize());
                continue;
            }
            this.futures.add(this.threadPool.submit(new UploadPartCallable(this.cos, request)));
        }
    }

    private Map<Integer, PartSummary> identifyExistingPartsForResume(String uploadId) {
        HashMap<Integer, PartSummary> partNumbers = new HashMap<Integer, PartSummary>();
        if (uploadId == null) {
            return partNumbers;
        }
        int partNumber = 0;
        while (true) {
            ListPartsRequest listPartsRequest = new ListPartsRequest(this.origReq.getBucketName(), this.origReq.getKey(), uploadId).withPartNumberMarker(partNumber);
            TransferManagerUtils.populateEndpointAddr(this.origReq, listPartsRequest);
            PartListing parts = this.cos.listParts(listPartsRequest);
            for (PartSummary partSummary : parts.getParts()) {
                partNumbers.put(partSummary.getPartNumber(), partSummary);
            }
            if (!parts.isTruncated()) {
                return partNumbers;
            }
            partNumber = parts.getNextPartNumberMarker();
        }
    }

    private String initiateMultipartUpload(PutObjectRequest origReq, boolean isUsingEncryption, long optimalPartSize) {
        InitiateMultipartUploadRequest req = null;
        if (isUsingEncryption && origReq instanceof EncryptedPutObjectRequest) {
            req = new EncryptedInitiateMultipartUploadRequest(origReq.getBucketName(), origReq.getKey()).withCannedACL(origReq.getCannedAcl()).withObjectMetadata(origReq.getMetadata());
            ((EncryptedInitiateMultipartUploadRequest)req).setMaterialsDescription(((EncryptedPutObjectRequest)origReq).getMaterialsDescription());
        } else {
            req = new InitiateMultipartUploadRequest(origReq.getBucketName(), origReq.getKey()).withCannedACL(origReq.getCannedAcl()).withObjectMetadata(origReq.getMetadata());
        }
        long dataSize = TransferManagerUtils.getContentLength(origReq);
        req.setDataSizePartSize(dataSize, optimalPartSize);
        TransferManager.appendMultipartUserAgent(req);
        req.withAccessControlList(origReq.getAccessControlList()).withStorageClass(origReq.getStorageClass()).withRedirectLocation(origReq.getRedirectLocation()).withSSECustomerKey(origReq.getSSECustomerKey()).withSSECOSKeyManagementParams(origReq.getSSECOSKeyManagementParams()).withGeneralProgressListener(origReq.getGeneralProgressListener());
        TransferManagerUtils.populateEndpointAddr(origReq, req);
        String uploadId = this.cos.initiateMultipartUpload(req).getUploadId();
        log.debug("Initiated new multipart upload: " + uploadId);
        return uploadId;
    }
}

