/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.transfer.PauseStatus;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;

public class TransferManagerUtils {
    public static ThreadPoolExecutor createDefaultExecutorService() {
        ThreadFactory threadFactory2 = new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread2 = new Thread(r);
                thread2.setName("cos-transfer-manager-worker-" + this.threadCount++);
                return thread2;
            }
        };
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(1, threadFactory2);
    }

    public static boolean isUploadParallelizable(PutObjectRequest putObjectRequest, boolean isUsingEncryption) {
        if (isUsingEncryption) {
            return false;
        }
        return TransferManagerUtils.getRequestFile(putObjectRequest) != null;
    }

    public static long getContentLength(PutObjectRequest putObjectRequest) {
        File file = TransferManagerUtils.getRequestFile(putObjectRequest);
        if (file != null) {
            return file.length();
        }
        if (putObjectRequest.getInputStream() != null && putObjectRequest.getMetadata().getContentLength() > 0L) {
            return putObjectRequest.getMetadata().getContentLength();
        }
        return -1L;
    }

    public static long calculateOptimalPartSize(PutObjectRequest putObjectRequest, TransferManagerConfiguration configuration) {
        double contentLength = TransferManagerUtils.getContentLength(putObjectRequest);
        double optimalPartSize = contentLength / 10000.0;
        optimalPartSize = Math.ceil(optimalPartSize);
        return (long)Math.max(optimalPartSize, (double)configuration.getMinimumUploadPartSize());
    }

    public static boolean shouldUseMultipartUpload(PutObjectRequest putObjectRequest, TransferManagerConfiguration configuration) {
        long contentLength = TransferManagerUtils.getContentLength(putObjectRequest);
        return contentLength >= configuration.getMultipartUploadThreshold();
    }

    public static File getRequestFile(PutObjectRequest putObjectRequest) {
        if (putObjectRequest.getFile() != null) {
            return putObjectRequest.getFile();
        }
        return null;
    }

    public static long calculateOptimalPartSizeForCopy(CopyObjectRequest copyObjectRequest, TransferManagerConfiguration configuration, long contentLengthOfSource) {
        double optimalPartSize = (double)contentLengthOfSource / 10000.0;
        optimalPartSize = Math.ceil(optimalPartSize);
        return (long)Math.max(optimalPartSize, (double)configuration.getMultipartCopyPartSize());
    }

    public static PauseStatus determinePauseStatus(Transfer.TransferState transferState, boolean forceCancel) {
        if (forceCancel) {
            if (transferState == Transfer.TransferState.Waiting) {
                return PauseStatus.CANCELLED_BEFORE_START;
            }
            if (transferState == Transfer.TransferState.InProgress) {
                return PauseStatus.CANCELLED;
            }
        }
        if (transferState == Transfer.TransferState.Waiting) {
            return PauseStatus.NOT_STARTED;
        }
        return PauseStatus.NO_EFFECT;
    }

    public static void populateEndpointAddr(CosServiceRequest originReq, CosServiceRequest newReq) {
        if (originReq != null && originReq.getFixedEndpointAddr() != null) {
            newReq.setFixedEndpointAddr(originReq.getFixedEndpointAddr());
        }
    }
}

