/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.BucketCrossOriginConfiguration;
import com.qcloud.cos.model.BucketDomainConfiguration;
import com.qcloud.cos.model.BucketIntelligentTierConfiguration;
import com.qcloud.cos.model.BucketLifecycleConfiguration;
import com.qcloud.cos.model.BucketLoggingConfiguration;
import com.qcloud.cos.model.BucketRefererConfiguration;
import com.qcloud.cos.model.BucketReplicationConfiguration;
import com.qcloud.cos.model.BucketTaggingConfiguration;
import com.qcloud.cos.model.BucketVersioningConfiguration;
import com.qcloud.cos.model.BucketWebsiteConfiguration;
import com.qcloud.cos.model.CORSRule;
import com.qcloud.cos.model.DomainRule;
import com.qcloud.cos.model.RedirectRule;
import com.qcloud.cos.model.ReplicationDestinationConfig;
import com.qcloud.cos.model.ReplicationRule;
import com.qcloud.cos.model.RoutingRule;
import com.qcloud.cos.model.RoutingRuleCondition;
import com.qcloud.cos.model.Tag.LifecycleTagPredicate;
import com.qcloud.cos.model.Tag.Tag;
import com.qcloud.cos.model.TagSet;
import com.qcloud.cos.model.bucketcertificate.BucketDomainCertificateInfo;
import com.qcloud.cos.model.bucketcertificate.BucketPutDomainCertificate;
import com.qcloud.cos.model.inventory.InventoryConfiguration;
import com.qcloud.cos.model.inventory.InventoryCosBucketDestination;
import com.qcloud.cos.model.inventory.InventoryDestination;
import com.qcloud.cos.model.inventory.InventoryEncryption;
import com.qcloud.cos.model.inventory.InventoryFilter;
import com.qcloud.cos.model.inventory.InventoryFilterPredicate;
import com.qcloud.cos.model.inventory.InventoryPrefixPredicate;
import com.qcloud.cos.model.inventory.InventorySchedule;
import com.qcloud.cos.model.inventory.ServerSideEncryptionCOS;
import com.qcloud.cos.model.lifecycle.LifecycleAndOperator;
import com.qcloud.cos.model.lifecycle.LifecycleFilter;
import com.qcloud.cos.model.lifecycle.LifecycleFilterPredicate;
import com.qcloud.cos.model.lifecycle.LifecyclePredicateVisitor;
import com.qcloud.cos.model.lifecycle.LifecyclePrefixPredicate;
import com.qcloud.cos.utils.CollectionUtils;
import com.qcloud.cos.utils.DateUtils;
import java.util.List;

public class BucketConfigurationXmlFactory {
    public byte[] convertToXmlByteArray(BucketCrossOriginConfiguration config) throws CosClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("CORSConfiguration");
        for (CORSRule rule : config.getRules()) {
            this.writeRule(xml, rule);
        }
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketLoggingConfiguration loggingConfiguration) {
        String logFilePrefix = loggingConfiguration.getLogFilePrefix();
        if (logFilePrefix == null) {
            logFilePrefix = "";
        }
        XmlWriter xml = new XmlWriter();
        xml.start("BucketLoggingStatus");
        if (loggingConfiguration.isLoggingEnabled()) {
            xml.start("LoggingEnabled");
            xml.start("TargetBucket").value(loggingConfiguration.getDestinationBucketName()).end();
            xml.start("TargetPrefix").value(loggingConfiguration.getLogFilePrefix()).end();
            xml.end();
        }
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketVersioningConfiguration versioningConfiguration) {
        XmlWriter xml = new XmlWriter();
        xml.start("VersioningConfiguration");
        xml.start("Status").value(versioningConfiguration.getStatus()).end();
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(InventoryConfiguration config) throws CosClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("InventoryConfiguration");
        xml.start("Id").value(config.getId()).end();
        xml.start("IsEnabled").value(String.valueOf(config.isEnabled())).end();
        xml.start("IncludedObjectVersions").value(config.getIncludedObjectVersions()).end();
        this.writeInventoryDestination(xml, config.getDestination());
        this.writeInventoryFilter(xml, config.getInventoryFilter());
        this.addInventorySchedule(xml, config.getSchedule());
        this.addInventoryOptionalFields(xml, config.getOptionalFields());
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketTaggingConfiguration config) throws CosClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("Tagging");
        for (TagSet tagset : config.getAllTagSets()) {
            this.writeRule(xml, tagset);
        }
        xml.end();
        return xml.getBytes();
    }

    private void writeInventoryDestination(XmlWriter xml, InventoryDestination destination) {
        if (destination == null) {
            return;
        }
        xml.start("Destination");
        InventoryCosBucketDestination s3BucketDestination = destination.getCosBucketDestination();
        if (s3BucketDestination != null) {
            xml.start("COSBucketDestination");
            this.addParameterIfNotNull(xml, "AccountId", s3BucketDestination.getAccountId());
            this.addParameterIfNotNull(xml, "Bucket", s3BucketDestination.getBucketArn());
            this.addParameterIfNotNull(xml, "Prefix", s3BucketDestination.getPrefix());
            this.addParameterIfNotNull(xml, "Format", s3BucketDestination.getFormat());
            this.writeInventoryEncryption(xml, s3BucketDestination.getEncryption());
            xml.end();
        }
        xml.end();
    }

    private void writeInventoryEncryption(XmlWriter xml, InventoryEncryption encryption) {
        if (encryption == null) {
            return;
        }
        xml.start("Encryption");
        if (encryption instanceof ServerSideEncryptionCOS) {
            xml.start("SSE-COS").end();
        }
        xml.end();
    }

    private void writeInventoryFilter(XmlWriter xml, InventoryFilter inventoryFilter) {
        if (inventoryFilter == null) {
            return;
        }
        xml.start("Filter");
        this.writeInventoryFilterPredicate(xml, inventoryFilter.getPredicate());
        xml.end();
    }

    private void writeInventoryFilterPredicate(XmlWriter xml, InventoryFilterPredicate predicate) {
        if (predicate == null) {
            return;
        }
        if (predicate instanceof InventoryPrefixPredicate) {
            this.writePrefix(xml, ((InventoryPrefixPredicate)predicate).getPrefix());
        }
    }

    private void addInventorySchedule(XmlWriter xml, InventorySchedule schedule2) {
        if (schedule2 == null) {
            return;
        }
        xml.start("Schedule");
        this.addParameterIfNotNull(xml, "Frequency", schedule2.getFrequency());
        xml.end();
    }

    private void addInventoryOptionalFields(XmlWriter xml, List<String> optionalFields) {
        if (CollectionUtils.isNullOrEmpty(optionalFields)) {
            return;
        }
        xml.start("OptionalFields");
        for (String field : optionalFields) {
            xml.start("Field").value(field).end();
        }
        xml.end();
    }

    public byte[] convertToXmlByteArray(BucketLifecycleConfiguration config) throws CosClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("LifecycleConfiguration");
        for (BucketLifecycleConfiguration.Rule rule : config.getRules()) {
            this.writeRule(xml, rule);
        }
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketWebsiteConfiguration websiteConfiguration) {
        RedirectRule redirectAllRequestsTo;
        XmlWriter xml = new XmlWriter();
        xml.start("WebsiteConfiguration");
        if (websiteConfiguration.getIndexDocumentSuffix() != null) {
            XmlWriter indexDocumentElement = xml.start("IndexDocument");
            indexDocumentElement.start("Suffix").value(websiteConfiguration.getIndexDocumentSuffix()).end();
            indexDocumentElement.end();
        }
        if (websiteConfiguration.getErrorDocument() != null) {
            XmlWriter errorDocumentElement = xml.start("ErrorDocument");
            errorDocumentElement.start("Key").value(websiteConfiguration.getErrorDocument()).end();
            errorDocumentElement.end();
        }
        if ((redirectAllRequestsTo = websiteConfiguration.getRedirectAllRequestsTo()) != null) {
            XmlWriter redirectAllRequestsElement = xml.start("RedirectAllRequestsTo");
            if (redirectAllRequestsTo.getprotocol() != null) {
                xml.start("Protocol").value(redirectAllRequestsTo.getprotocol()).end();
            }
            if (redirectAllRequestsTo.getHostName() != null) {
                xml.start("HostName").value(redirectAllRequestsTo.getHostName()).end();
            }
            if (redirectAllRequestsTo.getReplaceKeyPrefixWith() != null) {
                xml.start("ReplaceKeyPrefixWith").value(redirectAllRequestsTo.getReplaceKeyPrefixWith()).end();
            }
            if (redirectAllRequestsTo.getReplaceKeyWith() != null) {
                xml.start("ReplaceKeyWith").value(redirectAllRequestsTo.getReplaceKeyWith()).end();
            }
            redirectAllRequestsElement.end();
        }
        if (websiteConfiguration.getRoutingRules() != null && websiteConfiguration.getRoutingRules().size() > 0) {
            XmlWriter routingRules = xml.start("RoutingRules");
            for (RoutingRule rule : websiteConfiguration.getRoutingRules()) {
                this.writeRule(routingRules, rule);
            }
            routingRules.end();
        }
        xml.end();
        return xml.getBytes();
    }

    private void writeRule(XmlWriter xml, CORSRule rule) {
        xml.start("CORSRule");
        if (rule.getId() != null) {
            xml.start("ID").value(rule.getId()).end();
        }
        if (rule.getAllowedOrigins() != null) {
            for (String origin : rule.getAllowedOrigins()) {
                xml.start("AllowedOrigin").value(origin).end();
            }
        }
        if (rule.getAllowedMethods() != null) {
            for (CORSRule.AllowedMethods method : rule.getAllowedMethods()) {
                xml.start("AllowedMethod").value(method.toString()).end();
            }
        }
        if (rule.getMaxAgeSeconds() != 0) {
            xml.start("MaxAgeSeconds").value(Integer.toString(rule.getMaxAgeSeconds())).end();
        }
        if (rule.getExposedHeaders() != null) {
            for (String header : rule.getExposedHeaders()) {
                xml.start("ExposeHeader").value(header).end();
            }
        }
        if (rule.getAllowedHeaders() != null) {
            for (String header : rule.getAllowedHeaders()) {
                xml.start("AllowedHeader").value(header).end();
            }
        }
        xml.end();
    }

    private void writeRule(XmlWriter xml, BucketLifecycleConfiguration.Rule rule) {
        xml.start("Rule");
        if (rule.getId() != null) {
            xml.start("ID").value(rule.getId()).end();
        }
        xml.start("Status").value(rule.getStatus()).end();
        this.writeLifecycleFilter(xml, rule.getFilter());
        this.addTransitions(xml, rule.getTransitions());
        this.addNoncurrentTransitions(xml, rule.getNoncurrentVersionTransitions());
        if (this.hasCurrentExpirationPolicy(rule)) {
            xml.start("Expiration");
            if (rule.getExpirationInDays() != -1) {
                xml.start("Days").value("" + rule.getExpirationInDays()).end();
            }
            if (rule.getExpirationDate() != null) {
                xml.start("Date").value(DateUtils.formatISO8601Date(rule.getExpirationDate())).end();
            }
            if (rule.isExpiredObjectDeleteMarker()) {
                xml.start("ExpiredObjectDeleteMarker").value("true").end();
            }
            xml.end();
        }
        if (rule.getNoncurrentVersionExpirationInDays() != -1) {
            xml.start("NoncurrentVersionExpiration");
            xml.start("NoncurrentDays").value(Integer.toString(rule.getNoncurrentVersionExpirationInDays())).end();
            xml.end();
        }
        if (rule.getAbortIncompleteMultipartUpload() != null) {
            xml.start("AbortIncompleteMultipartUpload");
            xml.start("DaysAfterInitiation").value(Integer.toString(rule.getAbortIncompleteMultipartUpload().getDaysAfterInitiation())).end();
            xml.end();
        }
        xml.end();
    }

    private void writeRule(XmlWriter xml, RoutingRule rule) {
        xml.start("RoutingRule");
        RoutingRuleCondition condition = rule.getCondition();
        if (condition != null) {
            xml.start("Condition");
            xml.start("KeyPrefixEquals");
            if (condition.getKeyPrefixEquals() != null) {
                xml.value(condition.getKeyPrefixEquals());
            }
            xml.end();
            if (condition.getHttpErrorCodeReturnedEquals() != null) {
                xml.start("HttpErrorCodeReturnedEquals ").value(condition.getHttpErrorCodeReturnedEquals()).end();
            }
            xml.end();
        }
        xml.start("Redirect");
        RedirectRule redirect = rule.getRedirect();
        if (redirect != null) {
            if (redirect.getprotocol() != null) {
                xml.start("Protocol").value(redirect.getprotocol()).end();
            }
            if (redirect.getHostName() != null) {
                xml.start("HostName").value(redirect.getHostName()).end();
            }
            if (redirect.getReplaceKeyPrefixWith() != null) {
                xml.start("ReplaceKeyPrefixWith").value(redirect.getReplaceKeyPrefixWith()).end();
            }
            if (redirect.getReplaceKeyWith() != null) {
                xml.start("ReplaceKeyWith").value(redirect.getReplaceKeyWith()).end();
            }
            if (redirect.getHttpRedirectCode() != null) {
                xml.start("HttpRedirectCode").value(redirect.getHttpRedirectCode()).end();
            }
        }
        xml.end();
        xml.end();
    }

    private void writeRule(XmlWriter xml, DomainRule rule) {
        xml.start("DomainRule");
        xml.start("Status").value(rule.getStatus()).end();
        xml.start("Name").value(rule.getName()).end();
        xml.start("Type").value(rule.getType()).end();
        if (rule.getForcedReplacement() != null) {
            xml.start("ForcedReplacement").value(rule.getForcedReplacement()).end();
        }
        xml.end();
    }

    private void writeRule(XmlWriter xml, TagSet tagset) {
        xml.start("TagSet");
        for (String key : tagset.getAllTags().keySet()) {
            xml.start("Tag");
            xml.start("Key").value(key).end();
            xml.start("Value").value(tagset.getTag(key)).end();
            xml.end();
        }
        xml.end();
    }

    private void addTransitions(XmlWriter xml, List<BucketLifecycleConfiguration.Transition> transitions) {
        if (transitions == null || transitions.isEmpty()) {
            return;
        }
        for (BucketLifecycleConfiguration.Transition t : transitions) {
            if (t == null) continue;
            xml.start("Transition");
            if (t.getDate() != null) {
                xml.start("Date");
                xml.value(DateUtils.formatISO8601Date(t.getDate()));
                xml.end();
            }
            if (t.getDays() != -1) {
                xml.start("Days");
                xml.value(Integer.toString(t.getDays()));
                xml.end();
            }
            xml.start("StorageClass");
            xml.value(t.getStorageClass().toString());
            xml.end();
            xml.end();
        }
    }

    private void addNoncurrentTransitions(XmlWriter xml, List<BucketLifecycleConfiguration.NoncurrentVersionTransition> transitions) {
        if (transitions == null || transitions.isEmpty()) {
            return;
        }
        for (BucketLifecycleConfiguration.NoncurrentVersionTransition t : transitions) {
            if (t == null) continue;
            xml.start("NoncurrentVersionTransition");
            if (t.getDays() != -1) {
                xml.start("NoncurrentDays");
                xml.value(Integer.toString(t.getDays()));
                xml.end();
            }
            xml.start("StorageClass");
            xml.value(t.getStorageClassAsString());
            xml.end();
            xml.end();
        }
    }

    private void writeLifecycleFilter(XmlWriter xml, LifecycleFilter filter) {
        if (filter == null) {
            return;
        }
        xml.start("Filter");
        this.writeLifecycleFilterPredicate(xml, filter.getPredicate());
        xml.end();
    }

    private void writeLifecycleFilterPredicate(XmlWriter xml, LifecycleFilterPredicate predicate) {
        if (predicate == null) {
            return;
        }
        predicate.accept(new LifecyclePredicateVisitorImpl(xml));
    }

    public byte[] convertToXmlByteArray(BucketReplicationConfiguration replicationConfiguration) {
        XmlWriter xml = new XmlWriter();
        xml.start("ReplicationConfiguration");
        List<ReplicationRule> rules = replicationConfiguration.getRules();
        String role = replicationConfiguration.getRoleName();
        xml.start("Role").value(role).end();
        for (ReplicationRule rule : rules) {
            String ruleId = rule.getID();
            xml.start("Rule");
            xml.start("ID").value(ruleId).end();
            xml.start("Prefix").value(rule.getPrefix()).end();
            xml.start("Status").value(rule.getStatus()).end();
            ReplicationDestinationConfig config = rule.getDestinationConfig();
            xml.start("Destination");
            xml.start("Bucket").value(config.getBucketQCS()).end();
            if (config.getStorageClass() != null) {
                xml.start("StorageClass").value(config.getStorageClass()).end();
            }
            xml.end();
            xml.end();
        }
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketDomainConfiguration domainConfiguration) {
        XmlWriter xml = new XmlWriter();
        xml.start("DomainConfiguration");
        for (DomainRule rule : domainConfiguration.getDomainRules()) {
            this.writeRule(xml, rule);
        }
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketRefererConfiguration refererConfiguration) {
        XmlWriter xml = new XmlWriter();
        xml.start("RefererConfiguration");
        xml.start("Status").value(refererConfiguration.getStatus()).end();
        xml.start("RefererType").value(refererConfiguration.getRefererType()).end();
        xml.start("DomainList");
        for (String domain : refererConfiguration.getDomainList()) {
            xml.start("Domain").value(domain).end();
        }
        xml.end();
        String emptyReferConfiguration = refererConfiguration.getEmptyReferConfiguration();
        if (emptyReferConfiguration != null && (emptyReferConfiguration == BucketRefererConfiguration.DENY || emptyReferConfiguration == BucketRefererConfiguration.ALLOW)) {
            xml.start("EmptyReferConfiguration").value(emptyReferConfiguration).end();
        }
        xml.end();
        return xml.getBytes();
    }

    private boolean hasCurrentExpirationPolicy(BucketLifecycleConfiguration.Rule rule) {
        return rule.getExpirationInDays() != -1 || rule.getExpirationDate() != null || rule.isExpiredObjectDeleteMarker();
    }

    private void addParameterIfNotNull(XmlWriter xml, String xmlTagName, String value) {
        if (value != null) {
            xml.start(xmlTagName).value(value).end();
        }
    }

    private void writePrefix(XmlWriter xml, String prefix) {
        this.addParameterIfNotNull(xml, "Prefix", prefix);
    }

    private void writeTag(XmlWriter xml, Tag tag) {
        if (tag == null) {
            return;
        }
        xml.start("Tag");
        xml.start("Key").value(tag.getKey()).end();
        xml.start("Value").value(tag.getValue()).end();
        xml.end();
    }

    public byte[] convertToXmlByteArray(BucketIntelligentTierConfiguration configuration) throws CosClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("IntelligentTieringConfiguration");
        String status = configuration.getStatus();
        xml.start("Status").value(status).end();
        BucketIntelligentTierConfiguration.Transition transition = configuration.getTransition();
        if (status.equals("Enabled") && transition != null) {
            xml.start("Transition");
            xml.start("Days").value(Integer.toString(transition.getDays())).end();
            xml.start("RequestFrequent").value(Integer.toString(transition.getRequestFrequent())).end();
            xml.end();
        }
        xml.end();
        return xml.getBytes();
    }

    public byte[] convertToXmlByteArray(BucketPutDomainCertificate domainCertificate) throws CosClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("DomainCertificate");
        BucketDomainCertificateInfo certificateInfo = domainCertificate.getBucketDomainCertificateInfo();
        xml.start("CertificateInfo");
        xml.start("CertType").value(certificateInfo.getCertType()).end();
        xml.start("CustomCert");
        xml.start("Cert").value(certificateInfo.getCert()).end();
        xml.start("PrivateKey").value(certificateInfo.getPrivateKey()).end();
        xml.end();
        xml.end();
        xml.start("DomainList");
        for (String domain : domainCertificate.getDomainList()) {
            xml.start("DomainName").value(domain).end();
        }
        xml.end();
        xml.end();
        return xml.getBytes();
    }

    private class LifecyclePredicateVisitorImpl
    implements LifecyclePredicateVisitor {
        private final XmlWriter xml;

        public LifecyclePredicateVisitorImpl(XmlWriter xml) {
            this.xml = xml;
        }

        @Override
        public void visit(LifecyclePrefixPredicate lifecyclePrefixPredicate) {
            BucketConfigurationXmlFactory.this.writePrefix(this.xml, lifecyclePrefixPredicate.getPrefix());
        }

        @Override
        public void visit(LifecycleTagPredicate lifecycleTagPredicate) {
            BucketConfigurationXmlFactory.this.writeTag(this.xml, lifecycleTagPredicate.getTag());
        }

        @Override
        public void visit(LifecycleAndOperator lifecycleAndOperator) {
            this.xml.start("And");
            for (LifecycleFilterPredicate predicate : lifecycleAndOperator.getOperands()) {
                predicate.accept(this);
            }
            this.xml.end();
        }
    }
}

