/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.internal.HeaderHandler;
import com.qcloud.cos.internal.ObjectExpirationResult;
import com.qcloud.cos.utils.DateUtils;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectExpirationHeaderHandler<T extends ObjectExpirationResult>
implements HeaderHandler<T> {
    private static final Pattern datePattern = Pattern.compile("expiry-date=\"(.*?)\"");
    private static final Pattern rulePattern = Pattern.compile("rule-id=\"(.*?)\"");
    private static final Logger log = LoggerFactory.getLogger(ObjectExpirationHeaderHandler.class);

    @Override
    public void handle(T result, CosHttpResponse response) {
        String expirationHeader = response.getHeaders().get("x-cos-expiration");
        if (expirationHeader != null) {
            result.setExpirationTime(this.parseDate(expirationHeader));
            result.setExpirationTimeRuleId(this.parseRuleId(expirationHeader));
        }
    }

    private String parseRuleId(String expirationHeader) {
        Matcher matcher = rulePattern.matcher(expirationHeader);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private Date parseDate(String expirationHeader) {
        Matcher matcher = datePattern.matcher(expirationHeader);
        if (matcher.find()) {
            String date = matcher.group(1);
            try {
                return DateUtils.parseRFC822Date(date);
            }
            catch (Exception exception) {
                log.warn("Error parsing expiry-date from x-cos-expiration header.", exception);
            }
        }
        return null;
    }
}

