/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.event;

import com.qcloud.cos.event.DeliveryMode;
import com.qcloud.cos.event.ProgressEvent;
import com.qcloud.cos.event.ProgressEventFilter;
import com.qcloud.cos.event.ProgressListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressListenerChain
implements ProgressListener,
DeliveryMode {
    private static final Logger log = LoggerFactory.getLogger(ProgressListenerChain.class);
    private final List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private final ProgressEventFilter progressEventFilter;
    private volatile boolean syncCallSafe = true;

    public ProgressListenerChain(ProgressListener ... listeners) {
        this((ProgressEventFilter)null, listeners);
    }

    public ProgressListenerChain(ProgressEventFilter progressEventFilter, ProgressListener ... listeners) {
        if (listeners == null) {
            throw new IllegalArgumentException("Progress Listeners cannot be null.");
        }
        for (ProgressListener listener : listeners) {
            this.addProgressListener(listener);
        }
        this.progressEventFilter = progressEventFilter;
    }

    public synchronized void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        if (this.syncCallSafe) {
            this.syncCallSafe = DeliveryMode.Check.isSyncCallSafe(listener);
        }
        this.listeners.add(listener);
    }

    public synchronized void removeProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected List<ProgressListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void progressChanged(ProgressEvent progressEvent) {
        ProgressEvent filteredEvent = progressEvent;
        if (this.progressEventFilter != null && (filteredEvent = this.progressEventFilter.filter(progressEvent)) == null) {
            return;
        }
        for (ProgressListener listener : this.listeners) {
            try {
                listener.progressChanged(filteredEvent);
            }
            catch (RuntimeException e) {
                log.warn("Couldn't update progress listener", e);
            }
        }
    }

    @Override
    public boolean isSyncCallSafe() {
        return this.syncCallSafe;
    }
}

