/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkImage;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkText;
import com.qcloud.cos.model.ciModel.template.MediaWatermark;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class WatermarkTemplateDemo {
    public static void main(String[] args2) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        WatermarkTemplateDemo.describeMediaTemplates(client);
    }

    public static void createMediaTemplate1(COSClient client) throws UnsupportedEncodingException {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("DemoBucket-123456789");
        request.setTag("Watermark");
        request.setName("mark-watermark-01");
        MediaWatermark waterMark = request.getWatermark();
        waterMark.setType("Text");
        waterMark.setLocMode("Absolute");
        waterMark.setDx("128");
        waterMark.setDy("128");
        waterMark.setPos("TopRight");
        waterMark.setStartTime("0");
        waterMark.setEndTime("100.5");
        MediaWaterMarkText text = waterMark.getText();
        text.setText("\u6c34\u5370\u5185\u5bb9");
        text.setFontSize("30");
        text.setFontType("simfang.ttf");
        text.setFontColor("0x112233");
        text.setTransparency("30");
        MediaTemplateResponse response = client.createMediaTemplate(request);
        System.out.println(response);
    }

    public static void createMediaTemplate2(COSClient client) throws UnsupportedEncodingException {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("DemoBucket-123456789");
        request.setTag("Watermark");
        request.setName("mark-test6");
        MediaWatermark waterMark = request.getWatermark();
        waterMark.setType("Image");
        waterMark.setLocMode("Absolute");
        waterMark.setDx("128");
        waterMark.setDy("128");
        waterMark.setPos("TopRight");
        waterMark.setStartTime("0");
        waterMark.setEndTime("100.5");
        MediaWaterMarkImage image = waterMark.getImage();
        image.setUrl("http://DemoBucket-123456789.cos.ap-chongqing.myqcloud.com/1.png");
        image.setMode("Proportion");
        image.setWidth("10");
        image.setHeight("10");
        image.setTransparency("30");
        MediaTemplateResponse response = client.createMediaTemplate(request);
        System.out.println(response);
    }

    public static void deleteMediaTemplate(COSClient client) {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("DemoBucket-123456789");
        request.setTemplateId("t1c2da66ede73c423bae95d885f7a******");
        Boolean response = client.deleteMediaTemplate(request);
        System.out.println(response);
    }

    public static void describeMediaTemplates(COSClient client) {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("DemoBucket-123456789");
        MediaListTemplateResponse response = client.describeMediaTemplates(request);
        List<MediaTemplateObject> templateList = response.getTemplateList();
        for (MediaTemplateObject mediaTemplateObject : templateList) {
            System.out.println(mediaTemplateObject);
        }
    }

    public static void updateMediaTemplate(COSClient client) throws UnsupportedEncodingException {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("DemoBucket-123456789");
        request.setTemplateId("t1be67e35b0d3b46168cf125f56e*****");
        request.setTag("Watermark");
        request.setName("mark-test-watermark-01");
        MediaWatermark waterMark = request.getWatermark();
        waterMark.setType("Text");
        waterMark.setLocMode("Absolute");
        waterMark.setDx("128");
        waterMark.setDy("128");
        waterMark.setPos("TopRight");
        waterMark.setStartTime("0");
        waterMark.setEndTime("100.5");
        MediaWaterMarkText text = waterMark.getText();
        text.setText("\u4fee\u6539\u6c34\u5370\u5185\u5bb9");
        text.setFontSize("30");
        text.setFontType("simfang.ttf");
        text.setFontColor("0x112233");
        text.setTransparency("30");
        Boolean aBoolean = client.updateMediaTemplate(request);
        System.out.println(aBoolean);
    }
}

