/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.ColorEnhance;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.SuperResolution;
import com.qcloud.cos.model.ciModel.job.VideoEnhance;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import com.qcloud.cos.utils.Jackson;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class VideoEnhanceJobDemo {
    public static void main(String[] args2) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        VideoEnhanceJobDemo.createMediaJobs(client);
    }

    public static void createMediaJobs(COSClient client) throws UnsupportedEncodingException {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demo-1234567890");
        request.setTag("VideoEnhance");
        request.getInput().setObject("1.mp4");
        VideoEnhance videoEnhance = request.getOperation().getVideoEnhance();
        MediaTranscodeObject trascode = videoEnhance.getTrascode();
        MediaContainerObject container = trascode.getContainer();
        container.setFormat("mp4");
        MediaTranscodeVideoObject video = trascode.getVideo();
        video.setCodec("H.264");
        video.setBitrate("1000");
        video.setWidth("1280");
        video.setFps("30");
        MediaAudioObject audio = trascode.getAudio();
        audio.setCodec("aac");
        audio.setSamplerate("44100");
        audio.setBitrate("128");
        audio.setChannels("4");
        SuperResolution superResolution = videoEnhance.getSuperResolution();
        superResolution.setResolution("sdtohd");
        superResolution.setEnableScaleUp("true");
        superResolution.setVersion("Enhance");
        ColorEnhance colorEnhance = videoEnhance.getColorEnhance();
        colorEnhance.setContrast("50");
        colorEnhance.setCorrection("100");
        colorEnhance.setSaturation("100");
        videoEnhance.getMsSharpen().setSharpenLevel("5");
        videoEnhance.getSdrToHDR().setHdrMode("HDR10");
        videoEnhance.getFrameEnhance().setFrameDoubling("true");
        request.getOperation().getOutput().setBucket("demo-1234567890");
        request.getOperation().getOutput().setRegion("ap-chongqing");
        request.getOperation().getOutput().setObject("VideoEnhance.mp4");
        request.setQueueId("p9900025e4ec44b5e8225e70a52170834");
        request.setCallBack("https://cloud.tencent.com/xxx");
        MediaJobResponse response = client.createMediaJobs(request);
        System.out.println(response.getJobsDetail().getJobId());
    }

    public static void describeMediaJob(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demo-1234567890.");
        request.setJobId("j5ff9acb6a63f11ed8d022552f0a5c600");
        MediaJobResponse response = client.describeMediaJob(request);
        VideoEnhance videoEnhance = response.getJobsDetail().getOperation().getVideoEnhance();
        System.out.println(Jackson.toJsonString(videoEnhance));
    }

    public static void createMediaTemplate(COSClient client) throws UnsupportedEncodingException {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("demo-1234567890.");
        request.setTag("VideoEnhance");
        request.setName("mark-VideoEnhance");
        VideoEnhance videoEnhance = request.getVideoEnhance();
        MediaTranscodeObject trascode = videoEnhance.getTrascode();
        MediaContainerObject container = trascode.getContainer();
        container.setFormat("mp4");
        MediaTranscodeVideoObject video = trascode.getVideo();
        video.setCodec("H.264");
        video.setBitrate("1000");
        video.setWidth("1280");
        video.setFps("30");
        MediaAudioObject audio = trascode.getAudio();
        audio.setCodec("aac");
        audio.setSamplerate("44100");
        audio.setBitrate("128");
        audio.setChannels("4");
        SuperResolution superResolution = videoEnhance.getSuperResolution();
        superResolution.setResolution("sdtohd");
        superResolution.setEnableScaleUp("true");
        superResolution.setVersion("Enhance");
        ColorEnhance colorEnhance = videoEnhance.getColorEnhance();
        colorEnhance.setContrast("50");
        colorEnhance.setCorrection("100");
        colorEnhance.setSaturation("100");
        videoEnhance.getMsSharpen().setSharpenLevel("5");
        videoEnhance.getSdrToHDR().setHdrMode("HDR10");
        MediaTemplateResponse response = client.createMediaTemplate(request);
        System.out.println(response);
    }

    public static void describeMediaTemplate(COSClient client) {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("demo-1234567890.");
        request.setName("mark-VideoEnhance");
        MediaListTemplateResponse response = client.describeMediaTemplates(request);
        List<MediaTemplateObject> templateList = response.getTemplateList();
        for (MediaTemplateObject mediaTemplateObject : templateList) {
            System.out.println(Jackson.toJsonString(mediaTemplateObject.getVideoEnhance()));
        }
    }
}

