/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.AuditingResultUtil;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.auditing.AuditingInfo;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingResponse;
import java.util.List;

public class VideoAuditingJobDemo {
    public static void main(String[] args2) throws InterruptedException {
        COSClient client = ClientUtils.getTestClient();
        VideoAuditingJobDemo.describeAuditingJob(client);
    }

    public static void createVideoAuditingJob(COSClient client) {
        VideoAuditingRequest request = new VideoAuditingRequest();
        request.setBucketName("demo-123456789");
        request.getInput().setObject("1.mp4");
        request.getConf().setDetectType("all");
        request.getConf().getSnapshot().setCount("10");
        request.getConf().getSnapshot().setMode("Interval");
        request.getConf().getSnapshot().setTimeInterval("10");
        VideoAuditingResponse response = client.createVideoAuditingJob(request);
        System.out.println(response);
    }

    public static void describeAuditingJob(COSClient client) throws InterruptedException {
        VideoAuditingResponse response;
        String state;
        VideoAuditingRequest request = new VideoAuditingRequest();
        request.setBucketName("demo-123456789");
        request.setJobId("av2628fdd21c4d11ecb3fa5254009*****");
        while (true) {
            if ("Success".equalsIgnoreCase(state = (response = client.describeAuditingJob(request)).getJobsDetail().getState()) || "Failed".equalsIgnoreCase(state)) break;
            Thread.sleep(100L);
        }
        System.out.println(response.getRequestId());
        System.out.println(state);
        System.out.println(response.getJobsDetail());
        List<AuditingInfo> auditingInfoList = AuditingResultUtil.getAuditingInfoList(response.getJobsDetail());
        System.out.println(auditingInfoList);
    }
}

