/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.FileCompressConfig;
import com.qcloud.cos.model.ciModel.job.FileHashCodeConfig;
import com.qcloud.cos.model.ciModel.job.FileProcessJobResponse;
import com.qcloud.cos.model.ciModel.job.FileProcessJobType;
import com.qcloud.cos.model.ciModel.job.FileProcessRequest;
import com.qcloud.cos.model.ciModel.job.FileUnCompressConfig;
import com.qcloud.cos.utils.Jackson;
import java.util.List;

public class FileProcessJobDemo {
    public static void main(String[] args2) {
        COSClient client = ClientUtils.getTestClient();
        FileProcessJobDemo.describeFileProcessJob(client);
    }

    public static void createFileCompressJob(COSClient client) {
        FileProcessRequest request = new FileProcessRequest();
        request.setBucketName("demo-1234567890");
        request.setTag(FileProcessJobType.FileCompress);
        FileCompressConfig fileCompressConfig = request.getOperation().getFileCompressConfig();
        fileCompressConfig.setFormat("zip");
        fileCompressConfig.setFlatten("0");
        List<String> keyList = fileCompressConfig.getKey();
        keyList.add("mark/pic-1.jpg");
        keyList.add("mark/pic-1.pdf");
        request.setQueueId("p1ff062b35a494cf0ac4b572df22a5650");
        MediaOutputObject output = request.getOperation().getOutput();
        output.setBucket("demo-1234567890");
        output.setRegion("ap-shanghai");
        output.setObject("output/demo.zip");
        FileProcessJobResponse response = client.createFileProcessJob(request);
        System.out.println(response.getJobDetail().getJobId());
    }

    public static void createFileUncompressJob(COSClient client) {
        FileProcessRequest request = new FileProcessRequest();
        request.setBucketName("demo-1234567890");
        request.setTag(FileProcessJobType.FileUncompress);
        request.getInput().setObject("output/demo.zip");
        FileUnCompressConfig fileUnCompressConfig = request.getOperation().getFileUnCompressConfig();
        fileUnCompressConfig.setPrefix("output/");
        fileUnCompressConfig.setPrefixReplaced("1");
        request.setQueueId("p1ff062b35a494cf0ac4b572df22a5650");
        MediaOutputObject output = request.getOperation().getOutput();
        output.setBucket("demo-1234567890");
        output.setRegion("ap-shanghai");
        FileProcessJobResponse response = client.createFileProcessJob(request);
        System.out.println(response.getJobDetail().getJobId());
    }

    public static void createFileHashCodeJob(COSClient client) {
        FileProcessRequest request = new FileProcessRequest();
        request.setBucketName("demo-1234567890");
        request.setTag(FileProcessJobType.FileHashCode);
        request.getInput().setObject("input/1.mp4");
        FileHashCodeConfig fileHashCodeConfig = request.getOperation().getFileHashCodeConfig();
        fileHashCodeConfig.setType("MD5");
        fileHashCodeConfig.setAddToHeader("true");
        request.setQueueId("p1ff062b35a494cf0ac4b572df22a5650");
        FileProcessJobResponse response = client.createFileProcessJob(request);
        System.out.println(response.getJobDetail().getJobId());
    }

    public static void describeFileProcessJob(COSClient client) {
        FileProcessRequest request = new FileProcessRequest();
        request.setBucketName("demo-1234567890");
        request.setJobId("fda7eb1607b8411ed8c182156726*****");
        FileProcessJobResponse response = client.describeFileProcessJob(request);
        System.out.println(Jackson.toJsonString(response));
    }
}

