/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.ExtractDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class ExtractDigitalWatermarkJobDemo {
    public static void main(String[] args2) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        ExtractDigitalWatermarkJobDemo.createMediaJobs(client);
    }

    public static void createMediaJobs(COSClient client) throws UnsupportedEncodingException {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demobucket-1234567890");
        request.setTag("ExtractDigitalWatermark");
        request.getInput().setObject("DigitalWatermark.mp4");
        MediaJobOperation operation = request.getOperation();
        ExtractDigitalWatermark extractDigitalWatermark = operation.getExtractDigitalWatermark();
        extractDigitalWatermark.setType("Text");
        extractDigitalWatermark.setVersion("V1");
        request.setQueueId("p9900025e4ec44b5e8225e70a5217****");
        MediaJobResponse response = client.createMediaJobs(request);
        System.out.println(response);
    }

    public static void describeMediaJob(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demobucket-1234567890");
        request.setJobId("j747b787ebbbf11ec86f46b5fdc18f37f");
        MediaJobResponse response = client.describeMediaJob(request);
        System.out.println(response);
    }

    public static void describeMediaJobs(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demobucket-1234567890");
        request.setQueueId("p9900025e4ec44b5e8225e70a5217****");
        request.setTag("ExtractDigitalWatermark");
        MediaListJobResponse response = client.describeMediaJobs(request);
        List<MediaJobObject> jobsDetail = response.getJobsDetailList();
        for (MediaJobObject mediaJobObject : jobsDetail) {
            System.out.println(mediaJobObject);
        }
    }

    public static void cancelMediaJob(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demobucket-1234567890");
        request.setJobId("jfb4039b0bb9e11ecbd2081a7c70******");
        Boolean response = client.cancelMediaJob(request);
        System.out.println(response);
    }
}

