/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import com.qcloud.cos.utils.Jackson;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class ConcatTemplateDemo {
    public static void main(String[] args2) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        ConcatTemplateDemo.describeMediaTemplates(client);
    }

    public static void createMediaTemplate(COSClient client) throws UnsupportedEncodingException {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("demo-1234567890");
        request.setTag("Concat");
        request.setName("ConcatTemplate");
        MediaConcatTemplateObject concatTemplate = request.getConcat();
        concatTemplate.getContainer().setFormat("mp4");
        List<MediaConcatFragmentObject> concatList = concatTemplate.getConcatFragmentList();
        MediaConcatFragmentObject fragment = new MediaConcatFragmentObject();
        fragment.setMode("Start");
        fragment.setUrl("http://demo-1234567890.cos.ap-chongqing.myqcloud.com/demo1.mp4");
        concatList.add(fragment);
        fragment = new MediaConcatFragmentObject();
        fragment.setMode("End");
        fragment.setUrl("http://demo-1234567890.cos.ap-chongqing.myqcloud.com/demo2.mp4");
        concatList.add(fragment);
        MediaAudioObject audio = concatTemplate.getAudio();
        audio.setCodec("mp3");
        MediaVideoObject video = concatTemplate.getVideo();
        video.setCodec("H.264");
        video.setBitrate("1000");
        video.setWidth("1280");
        video.setFps("30");
        MediaTemplateResponse response = client.createMediaTemplate(request);
        System.out.println(response);
    }

    public static void describeMediaTemplates(COSClient client) {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("demo-1234567890");
        request.setTag("Concat");
        MediaListTemplateResponse response = client.describeMediaTemplates(request);
        List<MediaTemplateObject> templateList = response.getTemplateList();
        for (MediaTemplateObject mediaTemplateObject : templateList) {
            System.out.println(Jackson.toJsonString(mediaTemplateObject));
        }
    }
}

