/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyResult;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.Copy;
import com.qcloud.cos.transfer.Download;
import com.qcloud.cos.transfer.MultipleFileDownload;
import com.qcloud.cos.transfer.MultipleFileUpload;
import com.qcloud.cos.transfer.PersistableDownload;
import com.qcloud.cos.transfer.PersistableUpload;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.TransferProgress;
import com.qcloud.cos.transfer.Upload;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TransferManagerDemo {
    private static void showTransferProgress(Transfer transfer) {
        System.out.println(transfer.getDescription());
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                return;
            }
            TransferProgress progress = transfer.getProgress();
            long so_far = progress.getBytesTransferred();
            long total = progress.getTotalBytesToTransfer();
            double pct = progress.getPercentTransferred();
            System.out.printf("[%d / %d] = %.02f%%\n", so_far, total, pct);
        } while (!transfer.isDone());
        System.out.println((Object)transfer.getState());
    }

    public static void uploadFile() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        ExecutorService threadPool = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        String key = "aaa/bbb.txt";
        File localFile = new File("src/test/resources/len30M.txt");
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        try {
            long startTime = System.currentTimeMillis();
            Upload upload = transferManager.upload(putObjectRequest);
            TransferManagerDemo.showTransferProgress(upload);
            UploadResult uploadResult = upload.waitForUploadResult();
            long endTime = System.currentTimeMillis();
            System.out.println("used time: " + (endTime - startTime) / 1000L);
            System.out.println(uploadResult.getETag());
            System.out.println(uploadResult.getCrc64Ecma());
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
        cosclient.shutdown();
    }

    public static void pauseUploadFileAndResume() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        String key = "aaa/bbb.txt";
        File localFile = new File("src/test/resources/len30M.txt");
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        try {
            Upload upload = transferManager.upload(putObjectRequest);
            Thread.sleep(10000L);
            PersistableUpload persistableUpload = upload.pause();
            upload = transferManager.resumeUpload(persistableUpload);
            TransferManagerDemo.showTransferProgress(upload);
            UploadResult uploadResult = upload.waitForUploadResult();
            System.out.println(uploadResult.getETag());
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
        cosclient.shutdown();
    }

    public static void multipartUploadWithMetaData() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        String key = "aaa/bbb.txt";
        File localFile = new File("src/test/resources/len20M.txt");
        ObjectMetadata objectMetadata = new ObjectMetadata();
        HashMap<String, String> userMeta = new HashMap<String, String>();
        userMeta.put("usermeta", "hello-mult");
        objectMetadata.setUserMetadata(userMeta);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        putObjectRequest.withMetadata(objectMetadata);
        try {
            long startTime = System.currentTimeMillis();
            Upload upload = transferManager.upload(putObjectRequest);
            UploadResult uploadResult = upload.waitForUploadResult();
            long endTime = System.currentTimeMillis();
            System.out.println("used time: " + (endTime - startTime) / 1000L);
            System.out.println(uploadResult.getETag());
            System.out.println(uploadResult.getCrc64Ecma());
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
        cosclient.shutdown();
    }

    public static void uploadDirectory() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        String cos_path = "/prefix";
        String dir_path = "/to/mydir";
        Boolean recursive = false;
        try {
            MultipleFileUpload upload = transferManager.uploadDirectory(bucketName, cos_path, new File(dir_path), recursive);
            TransferManagerDemo.showTransferProgress(upload);
            upload.waitForCompletion();
            System.out.println("upload directory done.");
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
        cosclient.shutdown();
    }

    public static void downloadDirectory() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        String cos_path = "/prefix";
        String dir_path = "/to/mydir";
        try {
            MultipleFileDownload download = transferManager.downloadDirectory(bucketName, cos_path, new File(dir_path));
            TransferManagerDemo.showTransferProgress(download);
            download.waitForCompletion();
            System.out.println("download directory done.");
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
        cosclient.shutdown();
    }

    public static void downLoadFile() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        ExecutorService threadPool = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        String key = "aaa/bbb.txt";
        File downloadFile = new File("src/test/resources/download.txt");
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        try {
            Download download = transferManager.download(getObjectRequest, downloadFile);
            download.waitForCompletion();
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
        cosclient.shutdown();
    }

    public static void pauseDownloadFileAndResume() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        ExecutorService threadPool = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        String key = "aaa/bbb.txt";
        File downloadFile = new File("src/test/resources/download.txt");
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        try {
            Download download = transferManager.download(getObjectRequest, downloadFile);
            Thread.sleep(5000L);
            PersistableDownload persistableDownload = download.pause();
            download = transferManager.resumeDownload(persistableDownload);
            TransferManagerDemo.showTransferProgress(download);
            download.waitForCompletion();
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
        cosclient.shutdown();
    }

    public static void copyFileForDiffRegion() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        ExecutorService threadPool = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        Region srcBucketRegion = new Region("ap-shanghai");
        String srcBucketName = "srcBucket-1251668577";
        String srcKey = "aaa/bbb.txt";
        String destBucketName = "destBucket-1251668577";
        String destKey = "ccc/ddd.txt";
        COSClient srcCOSClient = new COSClient(cred, new ClientConfig(srcBucketRegion));
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucketRegion, srcBucketName, srcKey, destBucketName, destKey);
        try {
            Copy copy = transferManager.copy(copyObjectRequest, srcCOSClient, null);
            CopyResult copyResult = copy.waitForCopyResult();
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
        srcCOSClient.shutdown();
        cosclient.shutdown();
    }

    public static void copyFileForSameRegion() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        ExecutorService threadPool = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMultipartCopyThreshold(0x1400000L);
        transferManager.setConfiguration(transferManagerConfiguration);
        Region srcBucketRegion = new Region("ap-beijing-1");
        String srcBucketName = "srcBucket-1251668577";
        String srcKey = "aaa/bbb.txt";
        String destBucketName = "destBucket-1251668577";
        String destKey = "ccc/ddd.txt";
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucketRegion, srcBucketName, srcKey, destBucketName, destKey);
        try {
            Copy copy = transferManager.copy(copyObjectRequest);
            CopyResult copyResult = copy.waitForCopyResult();
            System.out.println(copyResult.getCrc64Ecma());
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
        cosclient.shutdown();
    }

    public static void copyFileSetMetadata() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        ClientConfig srcClientConfig = new ClientConfig(new Region("ap-shanghai"));
        COSClient srcCosclient = new COSClient(cred, srcClientConfig);
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMultipartCopyThreshold(0x500000L);
        transferManager.setConfiguration(transferManagerConfiguration);
        Region srcBucketRegion = new Region("ap-shanghai");
        String srcBucketName = "mysrcbucket-123456789";
        String srcKey = "aaa/bbb.txt";
        String destBucketName = "mydestbucekt-123456789";
        String destKey = "bbb/ccc.txt";
        ObjectMetadata objectMetadata = new ObjectMetadata();
        HashMap<String, String> userMeta = new HashMap<String, String>();
        userMeta.put("usermeta", "hello-mult-copy");
        objectMetadata.setUserMetadata(userMeta);
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucketRegion, srcBucketName, srcKey, destBucketName, destKey);
        System.out.println(copyObjectRequest.getDestinationBucketName());
        copyObjectRequest.setNewObjectMetadata(objectMetadata);
        try {
            Copy copy = transferManager.copy(copyObjectRequest, srcCosclient, null);
            CopyResult copyResult = copy.waitForCopyResult();
            System.out.println(copyResult.getCrc64Ecma());
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
        cosclient.shutdown();
    }

    public static void resumableDownloadFile() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        ExecutorService threadPool = Executors.newFixedThreadPool(5);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        GetObjectRequest getObj = new GetObjectRequest("mybucket-1000000000", "/path/to/key");
        File dstFile = new File("dstFile");
        Download download = transferManager.download(getObj, dstFile, true);
        TransferManagerDemo.showTransferProgress(download);
        try {
            download.waitForCompletion();
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
        cosclient.shutdown();
    }

    public static void main(String[] args2) {
        TransferManagerDemo.resumableDownloadFile();
    }
}

