/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.SSECOSKeyManagementParams;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.utils.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.LinkedList;

public class KmsUploadDemo {
    public static void main(String[] args2) {
        KmsUploadDemo.SimpleUploadWithKmsMeta();
        KmsUploadDemo.CopyObjectWithKmsMeta();
    }

    public static void SimpleUploadWithKmsMeta() {
        BasicCOSCredentials cred = new BasicCOSCredentials("SECRET_ID", "SECRET_KEY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        String key = "aaa/bbb.txt";
        File localFile = new File("/test.log");
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        String kmsKeyId = "your-kms-key-id";
        String encryptionContext = Base64.encodeAsString("{\"Ssekmstest\":\"Ssekmstest\"}".getBytes());
        SSECOSKeyManagementParams ssecosKeyManagementParams = new SSECOSKeyManagementParams(kmsKeyId, encryptionContext);
        putObjectRequest.setSSECOSKeyManagementParams(ssecosKeyManagementParams);
        System.setProperty("com.Qcloud.services.cos.disablePutObjectMD5Validation", "true");
        try {
            PutObjectResult putObjectResult = cosclient.putObject(putObjectRequest);
            String etag = putObjectResult.getETag();
            String string = putObjectResult.getCrc64Ecma();
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        cosclient.shutdown();
    }

    public static void MultipartUploadWithKmsMeta() {
        BasicCOSCredentials cred = new BasicCOSCredentials("SECRET_ID", "SECRET_KEY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        String key = "aaa/bbb.txt";
        String kmsKeyId = "your-kms-key-id";
        String encryptionContext = Base64.encodeAsString("{\"Ssekmstest\":\"Ssekmstest\"}".getBytes());
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(bucketName, key);
        SSECOSKeyManagementParams ssecosKeyManagementParams = new SSECOSKeyManagementParams(kmsKeyId, encryptionContext);
        System.setProperty("com.Qcloud.services.cos.disablePutObjectMD5Validation", "true");
        initiateMultipartUploadRequest.setSSECOSKeyManagementParams(ssecosKeyManagementParams);
        try {
            InitiateMultipartUploadResult initiateMultipartUploadResult = cosclient.initiateMultipartUpload(initiateMultipartUploadRequest);
            LinkedList<PartETag> partETags = new LinkedList<PartETag>();
            for (int i = 0; i < 2; ++i) {
                byte[] data = new byte[0x100000];
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(bucketName);
                uploadPartRequest.setKey(key);
                uploadPartRequest.setUploadId(initiateMultipartUploadResult.getUploadId());
                uploadPartRequest.setInputStream(new ByteArrayInputStream(data));
                uploadPartRequest.setPartSize(data.length);
                uploadPartRequest.setPartNumber(i + 1);
                UploadPartResult uploadPartResult = cosclient.uploadPart(uploadPartRequest);
                PartETag partETag = uploadPartResult.getPartETag();
                partETags.add(partETag);
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, key, initiateMultipartUploadResult.getUploadId(), partETags);
            CompleteMultipartUploadResult completeMultipartUploadResult = cosclient.completeMultipartUpload(completeMultipartUploadRequest);
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        cosclient.shutdown();
    }

    public static void CopyObjectWithKmsMeta() {
        BasicCOSCredentials cred = new BasicCOSCredentials("SECRET_ID", "SECRET_KEY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient cosclient = new COSClient(cred, clientConfig);
        String kmsKeyId = "your-kms-key-id";
        String encryptionContext = Base64.encodeAsString("{\"Ssekmstest\":\"Ssekmstest\"}".getBytes());
        Region srcBucketRegion = new Region("ap-guangzhou");
        String srcBucketName = "mybucket-1251668577";
        String srcKey = "aaa/bbb.txt";
        String destBucketName = "mybucket-1251668577";
        String destKey = "ccc/ddd.txt";
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucketRegion, srcBucketName, srcKey, destBucketName, destKey);
        copyObjectRequest.setSSECOSKeyManagementParams(new SSECOSKeyManagementParams(kmsKeyId, encryptionContext));
        try {
            CopyObjectResult copyObjectResult = cosclient.copyObject(copyObjectRequest);
            String string = copyObjectResult.getCrc64Ecma();
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        cosclient.shutdown();
    }
}

