/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.model.BucketRefererConfiguration;
import com.qcloud.cos.region.Region;

public class BucketRefererDemo {
    public static COSClient cosClient = null;
    public static String bucketName = "examplebucket-1251668577";

    public static void createCosClient() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKID********************************", "********************************");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        cosClient = new COSClient(cred, clientConfig);
    }

    public static void shutdown() {
        if (cosClient != null) {
            cosClient.shutdown();
            cosClient = null;
        }
    }

    public static void setBucketReferer() {
        BucketRefererConfiguration configuration = new BucketRefererConfiguration();
        configuration.setStatus(BucketRefererConfiguration.DISABLED);
        configuration.setRefererType(BucketRefererConfiguration.BLACKLIST);
        configuration.addDomain("test.com");
        configuration.addDomain("test.1.com");
        configuration.setEmptyReferConfiguration(BucketRefererConfiguration.DENY);
        cosClient.setBucketRefererConfiguration(bucketName, configuration);
    }

    public static void getBucketReferer() {
        BucketRefererConfiguration configuration = cosClient.getBucketRefererConfiguration(bucketName);
        if (configuration == null) {
            System.out.printf("bucket %s does not have referer configuration\n", bucketName);
            return;
        }
        System.out.printf("status: %s\n", configuration.getStatus());
        System.out.printf("referer type: %s\n", configuration.getRefererType());
        System.out.printf("empty referer config: %s\n", configuration.getEmptyReferConfiguration());
        for (String domain : configuration.getDomainList()) {
            System.out.printf("domain: %s\n", domain);
        }
    }

    public static void main(String[] args2) {
        BucketRefererDemo.createCosClient();
        BucketRefererDemo.setBucketReferer();
        BucketRefererDemo.getBucketReferer();
        BucketRefererDemo.shutdown();
    }
}

