/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.auth.InstanceCredentialsFetcher;
import com.qcloud.cos.auth.InstanceProfileCredentials;
import com.qcloud.cos.exception.CosClientException;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceCredentialsProvider
implements COSCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceCredentialsProvider.class);
    private static final long DEFAULT_REFRESH_INTERVAL_MILLISECONDS = 30000L;
    private static final int DEFAULT_MAX_FETCH_RETRY_TIMES = 3;
    private InstanceProfileCredentials credentials;
    private InstanceCredentialsFetcher fetcher;
    private long refreshIntervalInMilliseconds = 30000L;
    private int fetchRetryTimes = 3;
    private long lastFailedRefreshTimeInMilliseconds = 0L;
    private ReentrantLock lock = new ReentrantLock();

    public InstanceCredentialsProvider(InstanceCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public InstanceCredentialsProvider withRefreshInterval(long refreshIntervalInMilliseconds) {
        this.refreshIntervalInMilliseconds = refreshIntervalInMilliseconds;
        return this;
    }

    public InstanceCredentialsProvider withFetchRetryTimes(int fetchRetryTimes) {
        this.fetchRetryTimes = fetchRetryTimes;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public COSCredentials getCredentials() {
        if (null == this.credentials || this.credentials.isExpired()) {
            try {
                this.lock.lock();
                if (null != this.credentials && !this.credentials.isExpired()) return this.credentials;
                try {
                    this.credentials = (InstanceProfileCredentials)this.fetcher.fetch(this.fetchRetryTimes);
                    return this.credentials;
                }
                catch (CosClientException e) {
                    LOG.error("The InstanceCredentials fetch an exception.", e);
                    COSCredentials cOSCredentials = null;
                    this.lock.unlock();
                    return cOSCredentials;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (!this.credentials.willSoonExpire() || !this.shouldRefresh()) return this.credentials;
        try {
            this.lock.lock();
            try {
                this.credentials = (InstanceProfileCredentials)this.fetcher.fetch();
                return this.credentials;
            }
            catch (CosClientException e) {
                this.lastFailedRefreshTimeInMilliseconds = System.currentTimeMillis();
                LOG.warn("The InstanceCredentials fetch an exception. Wait for the next round to retry", e);
            }
            return this.credentials;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void refresh() {
    }

    public boolean shouldRefresh() {
        if (null == this.credentials) {
            return true;
        }
        return System.currentTimeMillis() - this.lastFailedRefreshTimeInMilliseconds > this.refreshIntervalInMilliseconds;
    }
}

